import type { TimeLabel, TimeLabelStore } from './timelabelstore';
import type {
  StudentGradeInDB, ResourceInDB, ResourceStore,
} from './resourcestore';
import type { ResourceHourInDB, ResourceHourStore } from './resourcehourstore';
import type { EventChangeInDB, EventInDB, EventStore } from './eventstore';


export interface ExportedData {
  timeLabels: TimeLabel[];
  studentGrades: StudentGradeInDB[];
  resources: ResourceInDB[];
  resourceHours: ResourceHourInDB[];
  events: EventInDB[],
  eventChanges: EventChangeInDB[],
}

export interface ImportDataImporterExporterMutationOp {
  opcode: 'import';
  param: ExportedData;
}

export type DataImporterExporterMutationOp = ImportDataImporterExporterMutationOp;

export function useDataImporterExporter(
  timeLabelStore: TimeLabelStore, resourceStore: ResourceStore,
  resourceHourStore: ResourceHourStore, eventStore: EventStore,
) {
  async function mutate(ops: DataImporterExporterMutationOp[]) {
    for(const op of ops) {
      if(op.opcode === 'import') {
        await timeLabelStore.import(op.param.timeLabels);
        await resourceStore.import({
          studentGrades: op.param.studentGrades,
          resources: op.param.resources,
        });
        await resourceHourStore.import({
          resourceHours: op.param.resourceHours,
        });
        await eventStore.import({
          events: op.param.events, eventChanges: op.param.eventChanges,
        })
      }
    }
  }

  async function query(param: {}): Promise<ExportedData> {
    return {
      timeLabels: await timeLabelStore.export(),
      ...await resourceStore.export(),
      ...await resourceHourStore.export(),
      ...await eventStore.export(),
    };
  }

  return { mutate, query };
}
