import { BaseError } from '../common/error';


export class ApiError extends BaseError {
  /**
   * @param {string} code
   * @param {unknown} payload
   */
  constructor(code, payload) {
    super();
    this._code = code;
    this._payload = payload;
  }

  get code() { return this._code; }
  get payload() { return this._payload; }
}

export class UnexpectedApiError extends ApiError {
  /**
   * @param {unknown} details
   */
  constructor(details) {
    super('unexpected', details);
  }
}

export class DataConstraintApiError extends ApiError {
  /**
   * @param {string} constraint_code
   * @param {unknown} param
   */
  constructor(constraint_code, param=null) {
    super('data_constraint', { constraint_code, param });
  }
}

export class ForeignKeyDataConstraintApiError extends DataConstraintApiError {
  /**
   * @param {string} collection
   * @param {string} id
   */
  constructor(collection, id) {
    super('foreignkey', { collection, id });
  }
}

export class UniqueDataConstraintApiError extends DataConstraintApiError {
  /**
   * @param {(string | number)[]} path
   */
  constructor(path) {
    super('unique', { path });
  }
}
