import { createRouter, createWebHistory } from 'vue-router';


export default createRouter({
  history: createWebHistory(),
  strict: true,
  routes: [{
    path: '/:pathMatch(.*)*/', redirect: to => `${to.path}index`,
  }, {
    path: '/',
    component: () => import('./pages/index.vue'),
  }, {
    path: '/printingtimeline',
    component: () => import('./pages/printingtimeline.vue'),
    props: route => ({
      classroom: route.query.classroom, mode: route.query.mode,
      resource: route.query.resource, date: route.query.date,
      hideConfidence: Boolean(route.query.hideconfidence),
    }),
  }, {
    path: '/master',
    component: () => import('./pages/master.vue'),
    children: [{
      path: 'index',
      component: () => import('./pages/master/index.vue'),
    }, {
      path: 'import-export',
      component: () => import('./pages/master/import-export.vue'),
    }, {
      path: 'config/index',
      component: () => import('./pages/master/config/index.vue'),
    }, {
      path: 'config/timelabel',
      component: () => import('./pages/master/config/timelabel.vue'),
    }, {
      path: 'config/classroom',
      component: () => import('./pages/master/config/classroom.vue'),
    }, {
      path: 'config/teacher',
      component: () => import('./pages/master/config/teacher.vue'),
    }, {
      path: 'config/student',
      component: () => import('./pages/master/config/student.vue'),
    }, {
      path: 'config/datareduction',
      component: () => import('./pages/master/config/datareduction.vue'),
    }, {
      path: 'timetable',
      component: () => import('./pages/master/timetable.vue'),
      children: [{
        path: 'index',
        component: () => import('./pages/master/timetable/index.vue'),
      }, {
        path: 'eventintegrity',
        component: () => import('./pages/master/timetable/eventintegrity.vue'),
      }, {
        path: 'resources/:id/',
        children: [{
          path: 'index',
          component: () => import('./pages/master/timetable/resources/[id]/index.vue'),
          props: route => ({ id: route.params.id }),
        }, {
          path: 'lessons',
          component: () => import('./pages/master/timetable/resources/[id]/lessons.vue'),
          props: route => ({ id: route.params.id }),
        }, {
          path: 'resourcehours',
          component: () => import('./pages/master/timetable/resources/[id]/resourcehours.vue'),
          props: route => ({ id: route.params.id }),
        }, {
          path: 'timeline',
          component: () => import('./pages/master/timetable/resources/[id]/timeline.vue'),
          props: route => ({ id: route.params.id }),
        }, {
          path: 'timelineeventinput',
          component: () => import('./pages/master/timetable/resources/[id]/timelineeventinput.vue'),
          props: route => ({ id: route.params.id }),
        }],
      }, {
        path: 'events/index',
        component: () => import('./pages/master/timetable/events/index.vue'),
      }, {
        path: 'events/new',
        component: () => import('./pages/master/timetable/events/new.vue'),
      }, {
        path: 'events/:id/index',
        component: () => import('./pages/master/timetable/events/[id]/index.vue'),
        props: route => ({ id: route.params.id }),
      }, {
        path: 'events/:id/edit',
        component: () => import('./pages/master/timetable/events/[id]/edit.vue'),
      }, {
        path: 'resourcehourcopy',
        component: () => import('./pages/master/timetable/resourcehourcopy.vue'),
      }, {
        path: 'datetimeline/:date',
        component: () => import('./pages/master/timetable/datetimeline.vue'),
        props: route => ({ date: route.params.date }),
      }, {
        path: 'timelineprint',
        component: () => import('./pages/master/timetable/timelineprint.vue'),
      }],
    }],
  }],
  scrollBehavior(to, from, savedPosition) {
    if(savedPosition) {
      return savedPosition;
    }
    const toURL = new URL(to.fullPath, 'http://exmaple.com/');
    const fromURL = new URL(from.fullPath, 'http://exmaple.com/');
    if(toURL.pathname === fromURL.pathname) {
      // クエリパラメータやハッシュのみが変わった時はスクロール位置のリセットをしない
      return {};
    }
    return { top: 0, left: 0 };
  },
});
