import { createApp } from 'vue';

import App from './App.vue';
import AppDialog from './components/global/AppDialog.vue';
import DateTime from './components/global/DateTime.vue';
import InputInteger from './components/global/InputInteger.vue';
import InputDate from './components/global/InputDate.vue';
import InputDateTime from './components/global/InputDateTime.vue';
import InputTime from './components/global/InputTime.vue';
import InputDateRange from './components/global/InputDateRange.vue';
import InputMultiDates from './components/global/InputMultiDates.vue';
import InputDailyTimeRanges from './components/global/InputDailyTimeRanges.vue';
import InputCalendarTimeRanges from './components/global/InputCalendarTimeRanges.vue';
import DataGrid from './components/global/DataGrid.vue';
import TimeTable from './components/global/TimeTable.vue';
import EventPopover from './components/global/EventPopover.vue';
import EventLink from './components/global/EventLink.vue';
import router from './router.js';


const app = createApp(App);

app.component('AppDialog', AppDialog);
app.component('DateTime', DateTime);
app.component('InputInteger', InputInteger);
app.component('InputDate', InputDate);
app.component('InputDateTime', InputDateTime);
app.component('InputTime', InputTime);
app.component('InputDateRange', InputDateRange);
app.component('InputMultiDates', InputMultiDates);
app.component('InputDailyTimeRanges', InputDailyTimeRanges);
app.component('InputCalendarTimeRanges', InputCalendarTimeRanges);
app.component('DataGrid', DataGrid);
app.component('TimeTable', TimeTable);
app.component('EventPopover', EventPopover);
app.component('EventLink', EventLink);

app.use(router);

app.mount('#app');
