import type { DateTime } from '@silane/datetime';

import type {
  ResourceHourStore as ServerResourceHourStore,
} from '../sharedworker/datastores/resourcehourstore';
import type { Database } from './database';


export type ResourceHour = { startTime: DateTime, endTime: DateTime };

export function useResourceHourStore(
  database: Database
) {
  async function mutate(
    ops: Parameters<ServerResourceHourStore['mutate']>[0]
  ): ReturnType<ServerResourceHourStore['mutate']> {
    return await database.mutate('resourceHour', ops) as any;
  }

  async function query(
    param: Parameters<ServerResourceHourStore['query']>[0]
  ): Promise<ResourceHour[]> {
    return await database.query('resourceHour', param) as any;
  }

  return { mutate, query };
}

export type ResourceHourStore = Awaited<ReturnType<
  typeof useResourceHourStore
>>;
