import { readonly, markRaw, shallowRef } from 'vue';
import { DateTime } from '@silane/datetime';


type LevelType = 'debug'|'info'|'warn'|'error';

export function useNotification() {
    const notifications = shallowRef<{
        time: DateTime, level: LevelType, text: string, details: string | null,
    }[]>([]);

    function add(
        level: LevelType, text: string, details: string | null=null,
    ) {
        notifications.value = [...notifications.value, {
            time: markRaw(DateTime.now()), level, text, details,
        }];
    }

    return { notifications: readonly(notifications), add };
}

export type Notification = ReturnType<typeof useNotification>;
