import type { Notification } from './notification';


export function useErrorHandler(notification: Notification) {
  function handleErrorAsync<F extends (...args: any[]) => Promise<any>>(fn: F) {
    return async (...args: Parameters<F>): Promise<Awaited<ReturnType<F>>> => {
      try {
        return await fn(...args);
      } catch(e) {
        throw e;
      }
    };
  }

  return { handleErrorAsync };
}

export type ErrorHandler = Awaited<ReturnType<typeof useErrorHandler>>;
