import { ref } from 'vue';

import type { Database } from './database.js';
import type {
  ExportedData,
} from  '../sharedworker/datastores/data-importer-exporter';
import type { TimeLabelStore } from './timelabelstore.js';
import type { ResourceStore } from './resourcestore.js';


export function useDataimporterexporter(
  database: Database,
  timeLabelStore: TimeLabelStore, resourceStore: ResourceStore,
) {
  const exportedData = ref<ExportedData | null>(null);

  async function load() {
    const data = await database.query(
      'dataImporterExporter', {}
    ) as ExportedData;
    exportedData.value = data;
  }

  async function import_(exportedData: ExportedData) {
    await database.mutate('dataImporterExporter', [{
      opcode: 'import', param: exportedData,
    }]);
    
    await load();
    await timeLabelStore.load();
    await resourceStore.load();
  }

  return { exportedData, load, import: import_ };
}
