import { readonly, shallowRef } from 'vue';


export interface ColorLabel {
  id: string;
  label: string;
  color: string;
}

export function useColorLabelStore() {
  const colorLabels = shallowRef<ColorLabel[]>([]);

  async function load() {
    colorLabels.value = [
      { id: '65dc7890db67e71cd80321b1', label: '対面予定授業', color: '#F9CB9B' },
      { id: '65dc7890db67e71cd80321b2', label: '対面確定授業(変更不可)', color: '#E69137' },
      { id: '65dc7890db67e71cd80321b3', label: 'オンライン予定授業', color: '#D8D8D8' },
      { id: '65dc7890db67e71cd80321b4', label: 'オンライン確定授業(変更不可)', color: '#999999' },
      { id: '6427ceeedb67e71cd80321b1', label: '元対面授業', color: '#FBBC04' },
      { id: '6427ceeedb67e71cd80321b2', label: '元オンライン授業', color: '#D9D9D9' },
      { id: '6427ceeedb67e71cd80321b3', label: '授業振替元', color: '#FFFFFF' },
      { id: '6427ceeedb67e71cd80321b4', label: '講師振替先', color: '#CFE2F3' },
      { id: '6427ceeedb67e71cd80321b5', label: '生徒振替先', color: '#FFFF00' },
      { id: '6427ceeedb67e71cd80321b6', label: 'AI', color: '#DD7E6B' },
      { id: '6427ceeedb67e71cd80321b7', label: 'オンライン振替先', color: '#D5A6BD' },
      { id: '6427ceeedb67e71cd80321b8', label: '外来', color: '#92D050' },
      { id: '6427ceeedb67e71cd80321b9', label: '講習のみ授業・体験', color: '#B4A7D6' },
      { id: '6427ceeedb67e71cd80321ba', label: '面談', color: '#3D85C6' },
      { id: '65fd8661db67e71cd8000001', label: '教務', color: '#C4BD97' },
      { id: '6427ceeedb67e71cd80321bb', label: 'その他', color: '#F4CCCC' },
    ];
  }

  return { colorLabels: readonly(colorLabels), load };
}

export type ColorLabelStore = ReturnType<typeof useColorLabelStore>;
