import ObjectID from 'bson-objectid';


export function getObjectID() {
    return ObjectID().toHexString();
}

/**
 * @param {{
 *   readonly id: unknown,
 *   readonly firstName: string, readonly lastName: string,
 * }[]} people
 * @returns {string[]}
 */
export function getUniquePeopleNames(people) {
    return people.map(x => {
        let firstNameLengthToDisplay = 0;
        const getName = person => {
            let name = '';
            name += person.lastName;
            if(firstNameLengthToDisplay !== 0)
                name += person.firstName.slice(0, firstNameLengthToDisplay);
            return name;
        }
        for(let other of people.filter(o => o.id !== x.id)) {
            for(; firstNameLengthToDisplay < x.firstName.length;
                    ++firstNameLengthToDisplay) {
                const name = getName(x);
                const othersName = getName(other);
                if(name !== othersName)
                    break;
            }
        }
        return getName(x);
    });
}

/**
 * @param {import('../composables/resourcestore').Resource} resource
 */
export function getResourceDisplayText(resource) {
 if(resource.type === 'classroom') {
   return `教室: ${resource.label}`;
 } else if(resource.type === 'teacher') {
   return `講師: ${resource.lastName} ${resource.firstName}`;
 } else if(resource.type === 'student') {
   return `生徒: ${
     resource.grade.label
   } ${resource.lastName} ${resource.firstName}`;
 }
 throw new Error('Unrecognized resource type');
}
