export class BaseError extends Error {
  /**
   * @param {string} message
   * @param {{ cause?: unknown }} options
   */
  constructor(message=undefined, options={}) {
    super(message, options);
    Object.defineProperty(this, 'name', {
        configurable: true,
        enumerable: false,
        value: this.constructor.name,
        writable: true,
    });
    if(Error.captureStackTrace) {
        Error.captureStackTrace(this, this.constructor);
    }
  }
}
