/**
 * Tagged template function to perform operations on datetime objects.
 * @param {string[]} strings Strings to be passed by tagged template.
 * @param  {...*} values Values to be passed by tagged template.
 */
export function dtexpr(strings: string[], ...values: any[]): any;
/**
 * Base exception of other exceptions raised in dtexpr.
 */
export class DtexprDateTimeError extends DateTimeError {
    /**
     * @param {*[]} expression The expression caused this error.
     * @param {[number, number]} pos Position of the error in the expression.
     * @param {string} message Error message.
     */
    constructor(expression: any[], pos: [number, number], message: string);
    expression: any[];
    pos: [number, number];
}
/**
 * Raised when there is a syntax error in dtexpr.
 */
export class SyntaxDtexprDateTimeError extends DtexprDateTimeError {
}
/**
 * Raised when there occur an error in execution phase in dtexpr, such as
 * inappropriate type passed to an operator.
 */
export class ExecutionDtexprDateTimeError extends DtexprDateTimeError {
    /**
     * @param {*[]} expression The expression caused this error.
     * @param {[number, number]} pos Position of the error in the expression.
     * @param {?Error} originalError The original error object.
     * @param {string} message Error message.
     */
    constructor(expression: any[], pos: [number, number], originalError: Error | null, message: string);
    originalError: Error | null;
}
import { DateTimeError } from './errors.js';
