/**
 * The base class of the other exceptions in this module.
 * It is a subclass of Error.
 */
export class DateTimeError extends Error {
    /**
     * @param {string} message Some error message.
     */
    constructor(message: string);
}
/**
 * Raised when derived classes should override the method.
 */
export class NotImplementedDateTimeError extends DateTimeError {
    constructor();
}
/**
 * Raised when an operation or function is applied to an object of
 * inappropriate type.
 */
export class TypeDateTimeError extends DateTimeError {
    constructor(message?: string);
}
/**
 * Raised when an operation or function receives an argument that has the
 * right type but an inappropriate value.
 */
export class ValueDateTimeError extends DateTimeError {
    constructor(message?: string);
}
