import {
  Fragment,
  Teleport,
  Transition,
  computed,
  createBaseVNode,
  createBlock,
  createCommentVNode,
  createElementBlock,
  createSlots,
  createTextVNode,
  createVNode,
  defineComponent,
  getCurrentScope,
  guardReactiveProps,
  isRef,
  mergeProps,
  nextTick,
  normalizeClass,
  normalizeProps,
  normalizeStyle,
  onBeforeUpdate,
  onMounted,
  onScopeDispose,
  onUnmounted,
  openBlock,
  reactive,
  ref,
  renderList,
  renderSlot,
  resolveDynamicComponent,
  toDisplayString,
  toRef,
  unref,
  useSlots,
  vShow,
  watch,
  withCtx,
  withDirectives,
  withKeys,
  withModifiers
} from "./chunk-J6475X5X.js";
import "./chunk-76J2PTFD.js";

// node_modules/@babel/runtime/helpers/esm/typeof.js
function _typeof(obj) {
  "@babel/helpers - typeof";
  return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(obj2) {
    return typeof obj2;
  } : function(obj2) {
    return obj2 && "function" == typeof Symbol && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
  }, _typeof(obj);
}

// node_modules/date-fns/esm/_lib/toInteger/index.js
function toInteger(dirtyNumber) {
  if (dirtyNumber === null || dirtyNumber === true || dirtyNumber === false) {
    return NaN;
  }
  var number = Number(dirtyNumber);
  if (isNaN(number)) {
    return number;
  }
  return number < 0 ? Math.ceil(number) : Math.floor(number);
}

// node_modules/date-fns/esm/_lib/requiredArgs/index.js
function requiredArgs(required, args) {
  if (args.length < required) {
    throw new TypeError(required + " argument" + (required > 1 ? "s" : "") + " required, but only " + args.length + " present");
  }
}

// node_modules/date-fns/esm/toDate/index.js
function toDate(argument) {
  requiredArgs(1, arguments);
  var argStr = Object.prototype.toString.call(argument);
  if (argument instanceof Date || _typeof(argument) === "object" && argStr === "[object Date]") {
    return new Date(argument.getTime());
  } else if (typeof argument === "number" || argStr === "[object Number]") {
    return new Date(argument);
  } else {
    if ((typeof argument === "string" || argStr === "[object String]") && typeof console !== "undefined") {
      console.warn("Starting with v2.0.0-beta.1 date-fns doesn't accept strings as date arguments. Please use `parseISO` to parse strings. See: https://github.com/date-fns/date-fns/blob/master/docs/upgradeGuide.md#string-arguments");
      console.warn(new Error().stack);
    }
    return /* @__PURE__ */ new Date(NaN);
  }
}

// node_modules/date-fns/esm/addDays/index.js
function addDays(dirtyDate, dirtyAmount) {
  requiredArgs(2, arguments);
  var date = toDate(dirtyDate);
  var amount = toInteger(dirtyAmount);
  if (isNaN(amount)) {
    return /* @__PURE__ */ new Date(NaN);
  }
  if (!amount) {
    return date;
  }
  date.setDate(date.getDate() + amount);
  return date;
}

// node_modules/date-fns/esm/addMonths/index.js
function addMonths(dirtyDate, dirtyAmount) {
  requiredArgs(2, arguments);
  var date = toDate(dirtyDate);
  var amount = toInteger(dirtyAmount);
  if (isNaN(amount)) {
    return /* @__PURE__ */ new Date(NaN);
  }
  if (!amount) {
    return date;
  }
  var dayOfMonth = date.getDate();
  var endOfDesiredMonth = new Date(date.getTime());
  endOfDesiredMonth.setMonth(date.getMonth() + amount + 1, 0);
  var daysInMonth = endOfDesiredMonth.getDate();
  if (dayOfMonth >= daysInMonth) {
    return endOfDesiredMonth;
  } else {
    date.setFullYear(endOfDesiredMonth.getFullYear(), endOfDesiredMonth.getMonth(), dayOfMonth);
    return date;
  }
}

// node_modules/date-fns/esm/add/index.js
function add(dirtyDate, duration) {
  requiredArgs(2, arguments);
  if (!duration || _typeof(duration) !== "object")
    return /* @__PURE__ */ new Date(NaN);
  var years = duration.years ? toInteger(duration.years) : 0;
  var months = duration.months ? toInteger(duration.months) : 0;
  var weeks = duration.weeks ? toInteger(duration.weeks) : 0;
  var days = duration.days ? toInteger(duration.days) : 0;
  var hours = duration.hours ? toInteger(duration.hours) : 0;
  var minutes = duration.minutes ? toInteger(duration.minutes) : 0;
  var seconds = duration.seconds ? toInteger(duration.seconds) : 0;
  var date = toDate(dirtyDate);
  var dateWithMonths = months || years ? addMonths(date, months + years * 12) : date;
  var dateWithDays = days || weeks ? addDays(dateWithMonths, days + weeks * 7) : dateWithMonths;
  var minutesToAdd = minutes + hours * 60;
  var secondsToAdd = seconds + minutesToAdd * 60;
  var msToAdd = secondsToAdd * 1e3;
  var finalDate = new Date(dateWithDays.getTime() + msToAdd);
  return finalDate;
}

// node_modules/date-fns/esm/addMilliseconds/index.js
function addMilliseconds(dirtyDate, dirtyAmount) {
  requiredArgs(2, arguments);
  var timestamp = toDate(dirtyDate).getTime();
  var amount = toInteger(dirtyAmount);
  return new Date(timestamp + amount);
}

// node_modules/date-fns/esm/_lib/defaultOptions/index.js
var defaultOptions = {};
function getDefaultOptions() {
  return defaultOptions;
}

// node_modules/date-fns/esm/startOfWeek/index.js
function startOfWeek(dirtyDate, options) {
  var _ref, _ref2, _ref3, _options$weekStartsOn, _options$locale, _options$locale$optio, _defaultOptions$local, _defaultOptions$local2;
  requiredArgs(1, arguments);
  var defaultOptions2 = getDefaultOptions();
  var weekStartsOn = toInteger((_ref = (_ref2 = (_ref3 = (_options$weekStartsOn = options === null || options === void 0 ? void 0 : options.weekStartsOn) !== null && _options$weekStartsOn !== void 0 ? _options$weekStartsOn : options === null || options === void 0 ? void 0 : (_options$locale = options.locale) === null || _options$locale === void 0 ? void 0 : (_options$locale$optio = _options$locale.options) === null || _options$locale$optio === void 0 ? void 0 : _options$locale$optio.weekStartsOn) !== null && _ref3 !== void 0 ? _ref3 : defaultOptions2.weekStartsOn) !== null && _ref2 !== void 0 ? _ref2 : (_defaultOptions$local = defaultOptions2.locale) === null || _defaultOptions$local === void 0 ? void 0 : (_defaultOptions$local2 = _defaultOptions$local.options) === null || _defaultOptions$local2 === void 0 ? void 0 : _defaultOptions$local2.weekStartsOn) !== null && _ref !== void 0 ? _ref : 0);
  if (!(weekStartsOn >= 0 && weekStartsOn <= 6)) {
    throw new RangeError("weekStartsOn must be between 0 and 6 inclusively");
  }
  var date = toDate(dirtyDate);
  var day = date.getDay();
  var diff = (day < weekStartsOn ? 7 : 0) + day - weekStartsOn;
  date.setDate(date.getDate() - diff);
  date.setHours(0, 0, 0, 0);
  return date;
}

// node_modules/date-fns/esm/startOfISOWeek/index.js
function startOfISOWeek(dirtyDate) {
  requiredArgs(1, arguments);
  return startOfWeek(dirtyDate, {
    weekStartsOn: 1
  });
}

// node_modules/date-fns/esm/getISOWeekYear/index.js
function getISOWeekYear(dirtyDate) {
  requiredArgs(1, arguments);
  var date = toDate(dirtyDate);
  var year = date.getFullYear();
  var fourthOfJanuaryOfNextYear = /* @__PURE__ */ new Date(0);
  fourthOfJanuaryOfNextYear.setFullYear(year + 1, 0, 4);
  fourthOfJanuaryOfNextYear.setHours(0, 0, 0, 0);
  var startOfNextYear = startOfISOWeek(fourthOfJanuaryOfNextYear);
  var fourthOfJanuaryOfThisYear = /* @__PURE__ */ new Date(0);
  fourthOfJanuaryOfThisYear.setFullYear(year, 0, 4);
  fourthOfJanuaryOfThisYear.setHours(0, 0, 0, 0);
  var startOfThisYear = startOfISOWeek(fourthOfJanuaryOfThisYear);
  if (date.getTime() >= startOfNextYear.getTime()) {
    return year + 1;
  } else if (date.getTime() >= startOfThisYear.getTime()) {
    return year;
  } else {
    return year - 1;
  }
}

// node_modules/date-fns/esm/startOfISOWeekYear/index.js
function startOfISOWeekYear(dirtyDate) {
  requiredArgs(1, arguments);
  var year = getISOWeekYear(dirtyDate);
  var fourthOfJanuary = /* @__PURE__ */ new Date(0);
  fourthOfJanuary.setFullYear(year, 0, 4);
  fourthOfJanuary.setHours(0, 0, 0, 0);
  var date = startOfISOWeek(fourthOfJanuary);
  return date;
}

// node_modules/date-fns/esm/_lib/getTimezoneOffsetInMilliseconds/index.js
function getTimezoneOffsetInMilliseconds(date) {
  var utcDate = new Date(Date.UTC(date.getFullYear(), date.getMonth(), date.getDate(), date.getHours(), date.getMinutes(), date.getSeconds(), date.getMilliseconds()));
  utcDate.setUTCFullYear(date.getFullYear());
  return date.getTime() - utcDate.getTime();
}

// node_modules/date-fns/esm/startOfDay/index.js
function startOfDay(dirtyDate) {
  requiredArgs(1, arguments);
  var date = toDate(dirtyDate);
  date.setHours(0, 0, 0, 0);
  return date;
}

// node_modules/date-fns/esm/differenceInCalendarDays/index.js
var MILLISECONDS_IN_DAY = 864e5;
function differenceInCalendarDays(dirtyDateLeft, dirtyDateRight) {
  requiredArgs(2, arguments);
  var startOfDayLeft = startOfDay(dirtyDateLeft);
  var startOfDayRight = startOfDay(dirtyDateRight);
  var timestampLeft = startOfDayLeft.getTime() - getTimezoneOffsetInMilliseconds(startOfDayLeft);
  var timestampRight = startOfDayRight.getTime() - getTimezoneOffsetInMilliseconds(startOfDayRight);
  return Math.round((timestampLeft - timestampRight) / MILLISECONDS_IN_DAY);
}

// node_modules/date-fns/esm/addYears/index.js
function addYears(dirtyDate, dirtyAmount) {
  requiredArgs(2, arguments);
  var amount = toInteger(dirtyAmount);
  return addMonths(dirtyDate, amount * 12);
}

// node_modules/date-fns/esm/constants/index.js
var daysInYear = 365.2425;
var maxTime = Math.pow(10, 8) * 24 * 60 * 60 * 1e3;
var millisecondsInMinute = 6e4;
var millisecondsInHour = 36e5;
var millisecondsInSecond = 1e3;
var minTime = -maxTime;
var secondsInHour = 3600;
var secondsInDay = secondsInHour * 24;
var secondsInWeek = secondsInDay * 7;
var secondsInYear = secondsInDay * daysInYear;
var secondsInMonth = secondsInYear / 12;
var secondsInQuarter = secondsInMonth * 3;

// node_modules/date-fns/esm/isDate/index.js
function isDate(value) {
  requiredArgs(1, arguments);
  return value instanceof Date || _typeof(value) === "object" && Object.prototype.toString.call(value) === "[object Date]";
}

// node_modules/date-fns/esm/isValid/index.js
function isValid(dirtyDate) {
  requiredArgs(1, arguments);
  if (!isDate(dirtyDate) && typeof dirtyDate !== "number") {
    return false;
  }
  var date = toDate(dirtyDate);
  return !isNaN(Number(date));
}

// node_modules/date-fns/esm/eachDayOfInterval/index.js
function eachDayOfInterval(dirtyInterval, options) {
  var _options$step;
  requiredArgs(1, arguments);
  var interval = dirtyInterval || {};
  var startDate = toDate(interval.start);
  var endDate = toDate(interval.end);
  var endTime = endDate.getTime();
  if (!(startDate.getTime() <= endTime)) {
    throw new RangeError("Invalid interval");
  }
  var dates = [];
  var currentDate = startDate;
  currentDate.setHours(0, 0, 0, 0);
  var step = Number((_options$step = options === null || options === void 0 ? void 0 : options.step) !== null && _options$step !== void 0 ? _options$step : 1);
  if (step < 1 || isNaN(step))
    throw new RangeError("`options.step` must be a number greater than 1");
  while (currentDate.getTime() <= endTime) {
    dates.push(toDate(currentDate));
    currentDate.setDate(currentDate.getDate() + step);
    currentDate.setHours(0, 0, 0, 0);
  }
  return dates;
}

// node_modules/date-fns/esm/endOfWeek/index.js
function endOfWeek(dirtyDate, options) {
  var _ref, _ref2, _ref3, _options$weekStartsOn, _options$locale, _options$locale$optio, _defaultOptions$local, _defaultOptions$local2;
  requiredArgs(1, arguments);
  var defaultOptions2 = getDefaultOptions();
  var weekStartsOn = toInteger((_ref = (_ref2 = (_ref3 = (_options$weekStartsOn = options === null || options === void 0 ? void 0 : options.weekStartsOn) !== null && _options$weekStartsOn !== void 0 ? _options$weekStartsOn : options === null || options === void 0 ? void 0 : (_options$locale = options.locale) === null || _options$locale === void 0 ? void 0 : (_options$locale$optio = _options$locale.options) === null || _options$locale$optio === void 0 ? void 0 : _options$locale$optio.weekStartsOn) !== null && _ref3 !== void 0 ? _ref3 : defaultOptions2.weekStartsOn) !== null && _ref2 !== void 0 ? _ref2 : (_defaultOptions$local = defaultOptions2.locale) === null || _defaultOptions$local === void 0 ? void 0 : (_defaultOptions$local2 = _defaultOptions$local.options) === null || _defaultOptions$local2 === void 0 ? void 0 : _defaultOptions$local2.weekStartsOn) !== null && _ref !== void 0 ? _ref : 0);
  if (!(weekStartsOn >= 0 && weekStartsOn <= 6)) {
    throw new RangeError("weekStartsOn must be between 0 and 6 inclusively");
  }
  var date = toDate(dirtyDate);
  var day = date.getDay();
  var diff = (day < weekStartsOn ? -7 : 0) + 6 - (day - weekStartsOn);
  date.setDate(date.getDate() + diff);
  date.setHours(23, 59, 59, 999);
  return date;
}

// node_modules/date-fns/esm/subMilliseconds/index.js
function subMilliseconds(dirtyDate, dirtyAmount) {
  requiredArgs(2, arguments);
  var amount = toInteger(dirtyAmount);
  return addMilliseconds(dirtyDate, -amount);
}

// node_modules/date-fns/esm/_lib/getUTCDayOfYear/index.js
var MILLISECONDS_IN_DAY2 = 864e5;
function getUTCDayOfYear(dirtyDate) {
  requiredArgs(1, arguments);
  var date = toDate(dirtyDate);
  var timestamp = date.getTime();
  date.setUTCMonth(0, 1);
  date.setUTCHours(0, 0, 0, 0);
  var startOfYearTimestamp = date.getTime();
  var difference = timestamp - startOfYearTimestamp;
  return Math.floor(difference / MILLISECONDS_IN_DAY2) + 1;
}

// node_modules/date-fns/esm/_lib/startOfUTCISOWeek/index.js
function startOfUTCISOWeek(dirtyDate) {
  requiredArgs(1, arguments);
  var weekStartsOn = 1;
  var date = toDate(dirtyDate);
  var day = date.getUTCDay();
  var diff = (day < weekStartsOn ? 7 : 0) + day - weekStartsOn;
  date.setUTCDate(date.getUTCDate() - diff);
  date.setUTCHours(0, 0, 0, 0);
  return date;
}

// node_modules/date-fns/esm/_lib/getUTCISOWeekYear/index.js
function getUTCISOWeekYear(dirtyDate) {
  requiredArgs(1, arguments);
  var date = toDate(dirtyDate);
  var year = date.getUTCFullYear();
  var fourthOfJanuaryOfNextYear = /* @__PURE__ */ new Date(0);
  fourthOfJanuaryOfNextYear.setUTCFullYear(year + 1, 0, 4);
  fourthOfJanuaryOfNextYear.setUTCHours(0, 0, 0, 0);
  var startOfNextYear = startOfUTCISOWeek(fourthOfJanuaryOfNextYear);
  var fourthOfJanuaryOfThisYear = /* @__PURE__ */ new Date(0);
  fourthOfJanuaryOfThisYear.setUTCFullYear(year, 0, 4);
  fourthOfJanuaryOfThisYear.setUTCHours(0, 0, 0, 0);
  var startOfThisYear = startOfUTCISOWeek(fourthOfJanuaryOfThisYear);
  if (date.getTime() >= startOfNextYear.getTime()) {
    return year + 1;
  } else if (date.getTime() >= startOfThisYear.getTime()) {
    return year;
  } else {
    return year - 1;
  }
}

// node_modules/date-fns/esm/_lib/startOfUTCISOWeekYear/index.js
function startOfUTCISOWeekYear(dirtyDate) {
  requiredArgs(1, arguments);
  var year = getUTCISOWeekYear(dirtyDate);
  var fourthOfJanuary = /* @__PURE__ */ new Date(0);
  fourthOfJanuary.setUTCFullYear(year, 0, 4);
  fourthOfJanuary.setUTCHours(0, 0, 0, 0);
  var date = startOfUTCISOWeek(fourthOfJanuary);
  return date;
}

// node_modules/date-fns/esm/_lib/getUTCISOWeek/index.js
var MILLISECONDS_IN_WEEK = 6048e5;
function getUTCISOWeek(dirtyDate) {
  requiredArgs(1, arguments);
  var date = toDate(dirtyDate);
  var diff = startOfUTCISOWeek(date).getTime() - startOfUTCISOWeekYear(date).getTime();
  return Math.round(diff / MILLISECONDS_IN_WEEK) + 1;
}

// node_modules/date-fns/esm/_lib/startOfUTCWeek/index.js
function startOfUTCWeek(dirtyDate, options) {
  var _ref, _ref2, _ref3, _options$weekStartsOn, _options$locale, _options$locale$optio, _defaultOptions$local, _defaultOptions$local2;
  requiredArgs(1, arguments);
  var defaultOptions2 = getDefaultOptions();
  var weekStartsOn = toInteger((_ref = (_ref2 = (_ref3 = (_options$weekStartsOn = options === null || options === void 0 ? void 0 : options.weekStartsOn) !== null && _options$weekStartsOn !== void 0 ? _options$weekStartsOn : options === null || options === void 0 ? void 0 : (_options$locale = options.locale) === null || _options$locale === void 0 ? void 0 : (_options$locale$optio = _options$locale.options) === null || _options$locale$optio === void 0 ? void 0 : _options$locale$optio.weekStartsOn) !== null && _ref3 !== void 0 ? _ref3 : defaultOptions2.weekStartsOn) !== null && _ref2 !== void 0 ? _ref2 : (_defaultOptions$local = defaultOptions2.locale) === null || _defaultOptions$local === void 0 ? void 0 : (_defaultOptions$local2 = _defaultOptions$local.options) === null || _defaultOptions$local2 === void 0 ? void 0 : _defaultOptions$local2.weekStartsOn) !== null && _ref !== void 0 ? _ref : 0);
  if (!(weekStartsOn >= 0 && weekStartsOn <= 6)) {
    throw new RangeError("weekStartsOn must be between 0 and 6 inclusively");
  }
  var date = toDate(dirtyDate);
  var day = date.getUTCDay();
  var diff = (day < weekStartsOn ? 7 : 0) + day - weekStartsOn;
  date.setUTCDate(date.getUTCDate() - diff);
  date.setUTCHours(0, 0, 0, 0);
  return date;
}

// node_modules/date-fns/esm/_lib/getUTCWeekYear/index.js
function getUTCWeekYear(dirtyDate, options) {
  var _ref, _ref2, _ref3, _options$firstWeekCon, _options$locale, _options$locale$optio, _defaultOptions$local, _defaultOptions$local2;
  requiredArgs(1, arguments);
  var date = toDate(dirtyDate);
  var year = date.getUTCFullYear();
  var defaultOptions2 = getDefaultOptions();
  var firstWeekContainsDate = toInteger((_ref = (_ref2 = (_ref3 = (_options$firstWeekCon = options === null || options === void 0 ? void 0 : options.firstWeekContainsDate) !== null && _options$firstWeekCon !== void 0 ? _options$firstWeekCon : options === null || options === void 0 ? void 0 : (_options$locale = options.locale) === null || _options$locale === void 0 ? void 0 : (_options$locale$optio = _options$locale.options) === null || _options$locale$optio === void 0 ? void 0 : _options$locale$optio.firstWeekContainsDate) !== null && _ref3 !== void 0 ? _ref3 : defaultOptions2.firstWeekContainsDate) !== null && _ref2 !== void 0 ? _ref2 : (_defaultOptions$local = defaultOptions2.locale) === null || _defaultOptions$local === void 0 ? void 0 : (_defaultOptions$local2 = _defaultOptions$local.options) === null || _defaultOptions$local2 === void 0 ? void 0 : _defaultOptions$local2.firstWeekContainsDate) !== null && _ref !== void 0 ? _ref : 1);
  if (!(firstWeekContainsDate >= 1 && firstWeekContainsDate <= 7)) {
    throw new RangeError("firstWeekContainsDate must be between 1 and 7 inclusively");
  }
  var firstWeekOfNextYear = /* @__PURE__ */ new Date(0);
  firstWeekOfNextYear.setUTCFullYear(year + 1, 0, firstWeekContainsDate);
  firstWeekOfNextYear.setUTCHours(0, 0, 0, 0);
  var startOfNextYear = startOfUTCWeek(firstWeekOfNextYear, options);
  var firstWeekOfThisYear = /* @__PURE__ */ new Date(0);
  firstWeekOfThisYear.setUTCFullYear(year, 0, firstWeekContainsDate);
  firstWeekOfThisYear.setUTCHours(0, 0, 0, 0);
  var startOfThisYear = startOfUTCWeek(firstWeekOfThisYear, options);
  if (date.getTime() >= startOfNextYear.getTime()) {
    return year + 1;
  } else if (date.getTime() >= startOfThisYear.getTime()) {
    return year;
  } else {
    return year - 1;
  }
}

// node_modules/date-fns/esm/_lib/startOfUTCWeekYear/index.js
function startOfUTCWeekYear(dirtyDate, options) {
  var _ref, _ref2, _ref3, _options$firstWeekCon, _options$locale, _options$locale$optio, _defaultOptions$local, _defaultOptions$local2;
  requiredArgs(1, arguments);
  var defaultOptions2 = getDefaultOptions();
  var firstWeekContainsDate = toInteger((_ref = (_ref2 = (_ref3 = (_options$firstWeekCon = options === null || options === void 0 ? void 0 : options.firstWeekContainsDate) !== null && _options$firstWeekCon !== void 0 ? _options$firstWeekCon : options === null || options === void 0 ? void 0 : (_options$locale = options.locale) === null || _options$locale === void 0 ? void 0 : (_options$locale$optio = _options$locale.options) === null || _options$locale$optio === void 0 ? void 0 : _options$locale$optio.firstWeekContainsDate) !== null && _ref3 !== void 0 ? _ref3 : defaultOptions2.firstWeekContainsDate) !== null && _ref2 !== void 0 ? _ref2 : (_defaultOptions$local = defaultOptions2.locale) === null || _defaultOptions$local === void 0 ? void 0 : (_defaultOptions$local2 = _defaultOptions$local.options) === null || _defaultOptions$local2 === void 0 ? void 0 : _defaultOptions$local2.firstWeekContainsDate) !== null && _ref !== void 0 ? _ref : 1);
  var year = getUTCWeekYear(dirtyDate, options);
  var firstWeek = /* @__PURE__ */ new Date(0);
  firstWeek.setUTCFullYear(year, 0, firstWeekContainsDate);
  firstWeek.setUTCHours(0, 0, 0, 0);
  var date = startOfUTCWeek(firstWeek, options);
  return date;
}

// node_modules/date-fns/esm/_lib/getUTCWeek/index.js
var MILLISECONDS_IN_WEEK2 = 6048e5;
function getUTCWeek(dirtyDate, options) {
  requiredArgs(1, arguments);
  var date = toDate(dirtyDate);
  var diff = startOfUTCWeek(date, options).getTime() - startOfUTCWeekYear(date, options).getTime();
  return Math.round(diff / MILLISECONDS_IN_WEEK2) + 1;
}

// node_modules/date-fns/esm/_lib/addLeadingZeros/index.js
function addLeadingZeros(number, targetLength) {
  var sign = number < 0 ? "-" : "";
  var output = Math.abs(number).toString();
  while (output.length < targetLength) {
    output = "0" + output;
  }
  return sign + output;
}

// node_modules/date-fns/esm/_lib/format/lightFormatters/index.js
var formatters = {
  // Year
  y: function y(date, token) {
    var signedYear = date.getUTCFullYear();
    var year = signedYear > 0 ? signedYear : 1 - signedYear;
    return addLeadingZeros(token === "yy" ? year % 100 : year, token.length);
  },
  // Month
  M: function M(date, token) {
    var month = date.getUTCMonth();
    return token === "M" ? String(month + 1) : addLeadingZeros(month + 1, 2);
  },
  // Day of the month
  d: function d(date, token) {
    return addLeadingZeros(date.getUTCDate(), token.length);
  },
  // AM or PM
  a: function a(date, token) {
    var dayPeriodEnumValue = date.getUTCHours() / 12 >= 1 ? "pm" : "am";
    switch (token) {
      case "a":
      case "aa":
        return dayPeriodEnumValue.toUpperCase();
      case "aaa":
        return dayPeriodEnumValue;
      case "aaaaa":
        return dayPeriodEnumValue[0];
      case "aaaa":
      default:
        return dayPeriodEnumValue === "am" ? "a.m." : "p.m.";
    }
  },
  // Hour [1-12]
  h: function h(date, token) {
    return addLeadingZeros(date.getUTCHours() % 12 || 12, token.length);
  },
  // Hour [0-23]
  H: function H(date, token) {
    return addLeadingZeros(date.getUTCHours(), token.length);
  },
  // Minute
  m: function m(date, token) {
    return addLeadingZeros(date.getUTCMinutes(), token.length);
  },
  // Second
  s: function s(date, token) {
    return addLeadingZeros(date.getUTCSeconds(), token.length);
  },
  // Fraction of second
  S: function S(date, token) {
    var numberOfDigits = token.length;
    var milliseconds2 = date.getUTCMilliseconds();
    var fractionalSeconds = Math.floor(milliseconds2 * Math.pow(10, numberOfDigits - 3));
    return addLeadingZeros(fractionalSeconds, token.length);
  }
};
var lightFormatters_default = formatters;

// node_modules/date-fns/esm/_lib/format/formatters/index.js
var dayPeriodEnum = {
  am: "am",
  pm: "pm",
  midnight: "midnight",
  noon: "noon",
  morning: "morning",
  afternoon: "afternoon",
  evening: "evening",
  night: "night"
};
var formatters2 = {
  // Era
  G: function G(date, token, localize2) {
    var era = date.getUTCFullYear() > 0 ? 1 : 0;
    switch (token) {
      case "G":
      case "GG":
      case "GGG":
        return localize2.era(era, {
          width: "abbreviated"
        });
      case "GGGGG":
        return localize2.era(era, {
          width: "narrow"
        });
      case "GGGG":
      default:
        return localize2.era(era, {
          width: "wide"
        });
    }
  },
  // Year
  y: function y2(date, token, localize2) {
    if (token === "yo") {
      var signedYear = date.getUTCFullYear();
      var year = signedYear > 0 ? signedYear : 1 - signedYear;
      return localize2.ordinalNumber(year, {
        unit: "year"
      });
    }
    return lightFormatters_default.y(date, token);
  },
  // Local week-numbering year
  Y: function Y(date, token, localize2, options) {
    var signedWeekYear = getUTCWeekYear(date, options);
    var weekYear = signedWeekYear > 0 ? signedWeekYear : 1 - signedWeekYear;
    if (token === "YY") {
      var twoDigitYear = weekYear % 100;
      return addLeadingZeros(twoDigitYear, 2);
    }
    if (token === "Yo") {
      return localize2.ordinalNumber(weekYear, {
        unit: "year"
      });
    }
    return addLeadingZeros(weekYear, token.length);
  },
  // ISO week-numbering year
  R: function R(date, token) {
    var isoWeekYear = getUTCISOWeekYear(date);
    return addLeadingZeros(isoWeekYear, token.length);
  },
  // Extended year. This is a single number designating the year of this calendar system.
  // The main difference between `y` and `u` localizers are B.C. years:
  // | Year | `y` | `u` |
  // |------|-----|-----|
  // | AC 1 |   1 |   1 |
  // | BC 1 |   1 |   0 |
  // | BC 2 |   2 |  -1 |
  // Also `yy` always returns the last two digits of a year,
  // while `uu` pads single digit years to 2 characters and returns other years unchanged.
  u: function u(date, token) {
    var year = date.getUTCFullYear();
    return addLeadingZeros(year, token.length);
  },
  // Quarter
  Q: function Q(date, token, localize2) {
    var quarter = Math.ceil((date.getUTCMonth() + 1) / 3);
    switch (token) {
      case "Q":
        return String(quarter);
      case "QQ":
        return addLeadingZeros(quarter, 2);
      case "Qo":
        return localize2.ordinalNumber(quarter, {
          unit: "quarter"
        });
      case "QQQ":
        return localize2.quarter(quarter, {
          width: "abbreviated",
          context: "formatting"
        });
      case "QQQQQ":
        return localize2.quarter(quarter, {
          width: "narrow",
          context: "formatting"
        });
      case "QQQQ":
      default:
        return localize2.quarter(quarter, {
          width: "wide",
          context: "formatting"
        });
    }
  },
  // Stand-alone quarter
  q: function q(date, token, localize2) {
    var quarter = Math.ceil((date.getUTCMonth() + 1) / 3);
    switch (token) {
      case "q":
        return String(quarter);
      case "qq":
        return addLeadingZeros(quarter, 2);
      case "qo":
        return localize2.ordinalNumber(quarter, {
          unit: "quarter"
        });
      case "qqq":
        return localize2.quarter(quarter, {
          width: "abbreviated",
          context: "standalone"
        });
      case "qqqqq":
        return localize2.quarter(quarter, {
          width: "narrow",
          context: "standalone"
        });
      case "qqqq":
      default:
        return localize2.quarter(quarter, {
          width: "wide",
          context: "standalone"
        });
    }
  },
  // Month
  M: function M2(date, token, localize2) {
    var month = date.getUTCMonth();
    switch (token) {
      case "M":
      case "MM":
        return lightFormatters_default.M(date, token);
      case "Mo":
        return localize2.ordinalNumber(month + 1, {
          unit: "month"
        });
      case "MMM":
        return localize2.month(month, {
          width: "abbreviated",
          context: "formatting"
        });
      case "MMMMM":
        return localize2.month(month, {
          width: "narrow",
          context: "formatting"
        });
      case "MMMM":
      default:
        return localize2.month(month, {
          width: "wide",
          context: "formatting"
        });
    }
  },
  // Stand-alone month
  L: function L(date, token, localize2) {
    var month = date.getUTCMonth();
    switch (token) {
      case "L":
        return String(month + 1);
      case "LL":
        return addLeadingZeros(month + 1, 2);
      case "Lo":
        return localize2.ordinalNumber(month + 1, {
          unit: "month"
        });
      case "LLL":
        return localize2.month(month, {
          width: "abbreviated",
          context: "standalone"
        });
      case "LLLLL":
        return localize2.month(month, {
          width: "narrow",
          context: "standalone"
        });
      case "LLLL":
      default:
        return localize2.month(month, {
          width: "wide",
          context: "standalone"
        });
    }
  },
  // Local week of year
  w: function w(date, token, localize2, options) {
    var week = getUTCWeek(date, options);
    if (token === "wo") {
      return localize2.ordinalNumber(week, {
        unit: "week"
      });
    }
    return addLeadingZeros(week, token.length);
  },
  // ISO week of year
  I: function I(date, token, localize2) {
    var isoWeek = getUTCISOWeek(date);
    if (token === "Io") {
      return localize2.ordinalNumber(isoWeek, {
        unit: "week"
      });
    }
    return addLeadingZeros(isoWeek, token.length);
  },
  // Day of the month
  d: function d2(date, token, localize2) {
    if (token === "do") {
      return localize2.ordinalNumber(date.getUTCDate(), {
        unit: "date"
      });
    }
    return lightFormatters_default.d(date, token);
  },
  // Day of year
  D: function D(date, token, localize2) {
    var dayOfYear = getUTCDayOfYear(date);
    if (token === "Do") {
      return localize2.ordinalNumber(dayOfYear, {
        unit: "dayOfYear"
      });
    }
    return addLeadingZeros(dayOfYear, token.length);
  },
  // Day of week
  E: function E(date, token, localize2) {
    var dayOfWeek = date.getUTCDay();
    switch (token) {
      case "E":
      case "EE":
      case "EEE":
        return localize2.day(dayOfWeek, {
          width: "abbreviated",
          context: "formatting"
        });
      case "EEEEE":
        return localize2.day(dayOfWeek, {
          width: "narrow",
          context: "formatting"
        });
      case "EEEEEE":
        return localize2.day(dayOfWeek, {
          width: "short",
          context: "formatting"
        });
      case "EEEE":
      default:
        return localize2.day(dayOfWeek, {
          width: "wide",
          context: "formatting"
        });
    }
  },
  // Local day of week
  e: function e(date, token, localize2, options) {
    var dayOfWeek = date.getUTCDay();
    var localDayOfWeek = (dayOfWeek - options.weekStartsOn + 8) % 7 || 7;
    switch (token) {
      case "e":
        return String(localDayOfWeek);
      case "ee":
        return addLeadingZeros(localDayOfWeek, 2);
      case "eo":
        return localize2.ordinalNumber(localDayOfWeek, {
          unit: "day"
        });
      case "eee":
        return localize2.day(dayOfWeek, {
          width: "abbreviated",
          context: "formatting"
        });
      case "eeeee":
        return localize2.day(dayOfWeek, {
          width: "narrow",
          context: "formatting"
        });
      case "eeeeee":
        return localize2.day(dayOfWeek, {
          width: "short",
          context: "formatting"
        });
      case "eeee":
      default:
        return localize2.day(dayOfWeek, {
          width: "wide",
          context: "formatting"
        });
    }
  },
  // Stand-alone local day of week
  c: function c(date, token, localize2, options) {
    var dayOfWeek = date.getUTCDay();
    var localDayOfWeek = (dayOfWeek - options.weekStartsOn + 8) % 7 || 7;
    switch (token) {
      case "c":
        return String(localDayOfWeek);
      case "cc":
        return addLeadingZeros(localDayOfWeek, token.length);
      case "co":
        return localize2.ordinalNumber(localDayOfWeek, {
          unit: "day"
        });
      case "ccc":
        return localize2.day(dayOfWeek, {
          width: "abbreviated",
          context: "standalone"
        });
      case "ccccc":
        return localize2.day(dayOfWeek, {
          width: "narrow",
          context: "standalone"
        });
      case "cccccc":
        return localize2.day(dayOfWeek, {
          width: "short",
          context: "standalone"
        });
      case "cccc":
      default:
        return localize2.day(dayOfWeek, {
          width: "wide",
          context: "standalone"
        });
    }
  },
  // ISO day of week
  i: function i(date, token, localize2) {
    var dayOfWeek = date.getUTCDay();
    var isoDayOfWeek = dayOfWeek === 0 ? 7 : dayOfWeek;
    switch (token) {
      case "i":
        return String(isoDayOfWeek);
      case "ii":
        return addLeadingZeros(isoDayOfWeek, token.length);
      case "io":
        return localize2.ordinalNumber(isoDayOfWeek, {
          unit: "day"
        });
      case "iii":
        return localize2.day(dayOfWeek, {
          width: "abbreviated",
          context: "formatting"
        });
      case "iiiii":
        return localize2.day(dayOfWeek, {
          width: "narrow",
          context: "formatting"
        });
      case "iiiiii":
        return localize2.day(dayOfWeek, {
          width: "short",
          context: "formatting"
        });
      case "iiii":
      default:
        return localize2.day(dayOfWeek, {
          width: "wide",
          context: "formatting"
        });
    }
  },
  // AM or PM
  a: function a2(date, token, localize2) {
    var hours = date.getUTCHours();
    var dayPeriodEnumValue = hours / 12 >= 1 ? "pm" : "am";
    switch (token) {
      case "a":
      case "aa":
        return localize2.dayPeriod(dayPeriodEnumValue, {
          width: "abbreviated",
          context: "formatting"
        });
      case "aaa":
        return localize2.dayPeriod(dayPeriodEnumValue, {
          width: "abbreviated",
          context: "formatting"
        }).toLowerCase();
      case "aaaaa":
        return localize2.dayPeriod(dayPeriodEnumValue, {
          width: "narrow",
          context: "formatting"
        });
      case "aaaa":
      default:
        return localize2.dayPeriod(dayPeriodEnumValue, {
          width: "wide",
          context: "formatting"
        });
    }
  },
  // AM, PM, midnight, noon
  b: function b(date, token, localize2) {
    var hours = date.getUTCHours();
    var dayPeriodEnumValue;
    if (hours === 12) {
      dayPeriodEnumValue = dayPeriodEnum.noon;
    } else if (hours === 0) {
      dayPeriodEnumValue = dayPeriodEnum.midnight;
    } else {
      dayPeriodEnumValue = hours / 12 >= 1 ? "pm" : "am";
    }
    switch (token) {
      case "b":
      case "bb":
        return localize2.dayPeriod(dayPeriodEnumValue, {
          width: "abbreviated",
          context: "formatting"
        });
      case "bbb":
        return localize2.dayPeriod(dayPeriodEnumValue, {
          width: "abbreviated",
          context: "formatting"
        }).toLowerCase();
      case "bbbbb":
        return localize2.dayPeriod(dayPeriodEnumValue, {
          width: "narrow",
          context: "formatting"
        });
      case "bbbb":
      default:
        return localize2.dayPeriod(dayPeriodEnumValue, {
          width: "wide",
          context: "formatting"
        });
    }
  },
  // in the morning, in the afternoon, in the evening, at night
  B: function B(date, token, localize2) {
    var hours = date.getUTCHours();
    var dayPeriodEnumValue;
    if (hours >= 17) {
      dayPeriodEnumValue = dayPeriodEnum.evening;
    } else if (hours >= 12) {
      dayPeriodEnumValue = dayPeriodEnum.afternoon;
    } else if (hours >= 4) {
      dayPeriodEnumValue = dayPeriodEnum.morning;
    } else {
      dayPeriodEnumValue = dayPeriodEnum.night;
    }
    switch (token) {
      case "B":
      case "BB":
      case "BBB":
        return localize2.dayPeriod(dayPeriodEnumValue, {
          width: "abbreviated",
          context: "formatting"
        });
      case "BBBBB":
        return localize2.dayPeriod(dayPeriodEnumValue, {
          width: "narrow",
          context: "formatting"
        });
      case "BBBB":
      default:
        return localize2.dayPeriod(dayPeriodEnumValue, {
          width: "wide",
          context: "formatting"
        });
    }
  },
  // Hour [1-12]
  h: function h2(date, token, localize2) {
    if (token === "ho") {
      var hours = date.getUTCHours() % 12;
      if (hours === 0)
        hours = 12;
      return localize2.ordinalNumber(hours, {
        unit: "hour"
      });
    }
    return lightFormatters_default.h(date, token);
  },
  // Hour [0-23]
  H: function H2(date, token, localize2) {
    if (token === "Ho") {
      return localize2.ordinalNumber(date.getUTCHours(), {
        unit: "hour"
      });
    }
    return lightFormatters_default.H(date, token);
  },
  // Hour [0-11]
  K: function K(date, token, localize2) {
    var hours = date.getUTCHours() % 12;
    if (token === "Ko") {
      return localize2.ordinalNumber(hours, {
        unit: "hour"
      });
    }
    return addLeadingZeros(hours, token.length);
  },
  // Hour [1-24]
  k: function k(date, token, localize2) {
    var hours = date.getUTCHours();
    if (hours === 0)
      hours = 24;
    if (token === "ko") {
      return localize2.ordinalNumber(hours, {
        unit: "hour"
      });
    }
    return addLeadingZeros(hours, token.length);
  },
  // Minute
  m: function m2(date, token, localize2) {
    if (token === "mo") {
      return localize2.ordinalNumber(date.getUTCMinutes(), {
        unit: "minute"
      });
    }
    return lightFormatters_default.m(date, token);
  },
  // Second
  s: function s2(date, token, localize2) {
    if (token === "so") {
      return localize2.ordinalNumber(date.getUTCSeconds(), {
        unit: "second"
      });
    }
    return lightFormatters_default.s(date, token);
  },
  // Fraction of second
  S: function S2(date, token) {
    return lightFormatters_default.S(date, token);
  },
  // Timezone (ISO-8601. If offset is 0, output is always `'Z'`)
  X: function X(date, token, _localize, options) {
    var originalDate = options._originalDate || date;
    var timezoneOffset = originalDate.getTimezoneOffset();
    if (timezoneOffset === 0) {
      return "Z";
    }
    switch (token) {
      case "X":
        return formatTimezoneWithOptionalMinutes(timezoneOffset);
      case "XXXX":
      case "XX":
        return formatTimezone(timezoneOffset);
      case "XXXXX":
      case "XXX":
      default:
        return formatTimezone(timezoneOffset, ":");
    }
  },
  // Timezone (ISO-8601. If offset is 0, output is `'+00:00'` or equivalent)
  x: function x(date, token, _localize, options) {
    var originalDate = options._originalDate || date;
    var timezoneOffset = originalDate.getTimezoneOffset();
    switch (token) {
      case "x":
        return formatTimezoneWithOptionalMinutes(timezoneOffset);
      case "xxxx":
      case "xx":
        return formatTimezone(timezoneOffset);
      case "xxxxx":
      case "xxx":
      default:
        return formatTimezone(timezoneOffset, ":");
    }
  },
  // Timezone (GMT)
  O: function O(date, token, _localize, options) {
    var originalDate = options._originalDate || date;
    var timezoneOffset = originalDate.getTimezoneOffset();
    switch (token) {
      case "O":
      case "OO":
      case "OOO":
        return "GMT" + formatTimezoneShort(timezoneOffset, ":");
      case "OOOO":
      default:
        return "GMT" + formatTimezone(timezoneOffset, ":");
    }
  },
  // Timezone (specific non-location)
  z: function z(date, token, _localize, options) {
    var originalDate = options._originalDate || date;
    var timezoneOffset = originalDate.getTimezoneOffset();
    switch (token) {
      case "z":
      case "zz":
      case "zzz":
        return "GMT" + formatTimezoneShort(timezoneOffset, ":");
      case "zzzz":
      default:
        return "GMT" + formatTimezone(timezoneOffset, ":");
    }
  },
  // Seconds timestamp
  t: function t(date, token, _localize, options) {
    var originalDate = options._originalDate || date;
    var timestamp = Math.floor(originalDate.getTime() / 1e3);
    return addLeadingZeros(timestamp, token.length);
  },
  // Milliseconds timestamp
  T: function T(date, token, _localize, options) {
    var originalDate = options._originalDate || date;
    var timestamp = originalDate.getTime();
    return addLeadingZeros(timestamp, token.length);
  }
};
function formatTimezoneShort(offset, dirtyDelimiter) {
  var sign = offset > 0 ? "-" : "+";
  var absOffset = Math.abs(offset);
  var hours = Math.floor(absOffset / 60);
  var minutes = absOffset % 60;
  if (minutes === 0) {
    return sign + String(hours);
  }
  var delimiter = dirtyDelimiter || "";
  return sign + String(hours) + delimiter + addLeadingZeros(minutes, 2);
}
function formatTimezoneWithOptionalMinutes(offset, dirtyDelimiter) {
  if (offset % 60 === 0) {
    var sign = offset > 0 ? "-" : "+";
    return sign + addLeadingZeros(Math.abs(offset) / 60, 2);
  }
  return formatTimezone(offset, dirtyDelimiter);
}
function formatTimezone(offset, dirtyDelimiter) {
  var delimiter = dirtyDelimiter || "";
  var sign = offset > 0 ? "-" : "+";
  var absOffset = Math.abs(offset);
  var hours = addLeadingZeros(Math.floor(absOffset / 60), 2);
  var minutes = addLeadingZeros(absOffset % 60, 2);
  return sign + hours + delimiter + minutes;
}
var formatters_default = formatters2;

// node_modules/date-fns/esm/_lib/format/longFormatters/index.js
var dateLongFormatter = function dateLongFormatter2(pattern, formatLong2) {
  switch (pattern) {
    case "P":
      return formatLong2.date({
        width: "short"
      });
    case "PP":
      return formatLong2.date({
        width: "medium"
      });
    case "PPP":
      return formatLong2.date({
        width: "long"
      });
    case "PPPP":
    default:
      return formatLong2.date({
        width: "full"
      });
  }
};
var timeLongFormatter = function timeLongFormatter2(pattern, formatLong2) {
  switch (pattern) {
    case "p":
      return formatLong2.time({
        width: "short"
      });
    case "pp":
      return formatLong2.time({
        width: "medium"
      });
    case "ppp":
      return formatLong2.time({
        width: "long"
      });
    case "pppp":
    default:
      return formatLong2.time({
        width: "full"
      });
  }
};
var dateTimeLongFormatter = function dateTimeLongFormatter2(pattern, formatLong2) {
  var matchResult = pattern.match(/(P+)(p+)?/) || [];
  var datePattern = matchResult[1];
  var timePattern = matchResult[2];
  if (!timePattern) {
    return dateLongFormatter(pattern, formatLong2);
  }
  var dateTimeFormat;
  switch (datePattern) {
    case "P":
      dateTimeFormat = formatLong2.dateTime({
        width: "short"
      });
      break;
    case "PP":
      dateTimeFormat = formatLong2.dateTime({
        width: "medium"
      });
      break;
    case "PPP":
      dateTimeFormat = formatLong2.dateTime({
        width: "long"
      });
      break;
    case "PPPP":
    default:
      dateTimeFormat = formatLong2.dateTime({
        width: "full"
      });
      break;
  }
  return dateTimeFormat.replace("{{date}}", dateLongFormatter(datePattern, formatLong2)).replace("{{time}}", timeLongFormatter(timePattern, formatLong2));
};
var longFormatters = {
  p: timeLongFormatter,
  P: dateTimeLongFormatter
};
var longFormatters_default = longFormatters;

// node_modules/date-fns/esm/_lib/protectedTokens/index.js
var protectedDayOfYearTokens = ["D", "DD"];
var protectedWeekYearTokens = ["YY", "YYYY"];
function isProtectedDayOfYearToken(token) {
  return protectedDayOfYearTokens.indexOf(token) !== -1;
}
function isProtectedWeekYearToken(token) {
  return protectedWeekYearTokens.indexOf(token) !== -1;
}
function throwProtectedError(token, format2, input) {
  if (token === "YYYY") {
    throw new RangeError("Use `yyyy` instead of `YYYY` (in `".concat(format2, "`) for formatting years to the input `").concat(input, "`; see: https://github.com/date-fns/date-fns/blob/master/docs/unicodeTokens.md"));
  } else if (token === "YY") {
    throw new RangeError("Use `yy` instead of `YY` (in `".concat(format2, "`) for formatting years to the input `").concat(input, "`; see: https://github.com/date-fns/date-fns/blob/master/docs/unicodeTokens.md"));
  } else if (token === "D") {
    throw new RangeError("Use `d` instead of `D` (in `".concat(format2, "`) for formatting days of the month to the input `").concat(input, "`; see: https://github.com/date-fns/date-fns/blob/master/docs/unicodeTokens.md"));
  } else if (token === "DD") {
    throw new RangeError("Use `dd` instead of `DD` (in `".concat(format2, "`) for formatting days of the month to the input `").concat(input, "`; see: https://github.com/date-fns/date-fns/blob/master/docs/unicodeTokens.md"));
  }
}

// node_modules/date-fns/esm/locale/en-US/_lib/formatDistance/index.js
var formatDistanceLocale = {
  lessThanXSeconds: {
    one: "less than a second",
    other: "less than {{count}} seconds"
  },
  xSeconds: {
    one: "1 second",
    other: "{{count}} seconds"
  },
  halfAMinute: "half a minute",
  lessThanXMinutes: {
    one: "less than a minute",
    other: "less than {{count}} minutes"
  },
  xMinutes: {
    one: "1 minute",
    other: "{{count}} minutes"
  },
  aboutXHours: {
    one: "about 1 hour",
    other: "about {{count}} hours"
  },
  xHours: {
    one: "1 hour",
    other: "{{count}} hours"
  },
  xDays: {
    one: "1 day",
    other: "{{count}} days"
  },
  aboutXWeeks: {
    one: "about 1 week",
    other: "about {{count}} weeks"
  },
  xWeeks: {
    one: "1 week",
    other: "{{count}} weeks"
  },
  aboutXMonths: {
    one: "about 1 month",
    other: "about {{count}} months"
  },
  xMonths: {
    one: "1 month",
    other: "{{count}} months"
  },
  aboutXYears: {
    one: "about 1 year",
    other: "about {{count}} years"
  },
  xYears: {
    one: "1 year",
    other: "{{count}} years"
  },
  overXYears: {
    one: "over 1 year",
    other: "over {{count}} years"
  },
  almostXYears: {
    one: "almost 1 year",
    other: "almost {{count}} years"
  }
};
var formatDistance = function formatDistance2(token, count, options) {
  var result;
  var tokenValue = formatDistanceLocale[token];
  if (typeof tokenValue === "string") {
    result = tokenValue;
  } else if (count === 1) {
    result = tokenValue.one;
  } else {
    result = tokenValue.other.replace("{{count}}", count.toString());
  }
  if (options !== null && options !== void 0 && options.addSuffix) {
    if (options.comparison && options.comparison > 0) {
      return "in " + result;
    } else {
      return result + " ago";
    }
  }
  return result;
};
var formatDistance_default = formatDistance;

// node_modules/date-fns/esm/locale/_lib/buildFormatLongFn/index.js
function buildFormatLongFn(args) {
  return function() {
    var options = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : {};
    var width = options.width ? String(options.width) : args.defaultWidth;
    var format2 = args.formats[width] || args.formats[args.defaultWidth];
    return format2;
  };
}

// node_modules/date-fns/esm/locale/en-US/_lib/formatLong/index.js
var dateFormats = {
  full: "EEEE, MMMM do, y",
  long: "MMMM do, y",
  medium: "MMM d, y",
  short: "MM/dd/yyyy"
};
var timeFormats = {
  full: "h:mm:ss a zzzz",
  long: "h:mm:ss a z",
  medium: "h:mm:ss a",
  short: "h:mm a"
};
var dateTimeFormats = {
  full: "{{date}} 'at' {{time}}",
  long: "{{date}} 'at' {{time}}",
  medium: "{{date}}, {{time}}",
  short: "{{date}}, {{time}}"
};
var formatLong = {
  date: buildFormatLongFn({
    formats: dateFormats,
    defaultWidth: "full"
  }),
  time: buildFormatLongFn({
    formats: timeFormats,
    defaultWidth: "full"
  }),
  dateTime: buildFormatLongFn({
    formats: dateTimeFormats,
    defaultWidth: "full"
  })
};
var formatLong_default = formatLong;

// node_modules/date-fns/esm/locale/en-US/_lib/formatRelative/index.js
var formatRelativeLocale = {
  lastWeek: "'last' eeee 'at' p",
  yesterday: "'yesterday at' p",
  today: "'today at' p",
  tomorrow: "'tomorrow at' p",
  nextWeek: "eeee 'at' p",
  other: "P"
};
var formatRelative = function formatRelative2(token, _date, _baseDate, _options) {
  return formatRelativeLocale[token];
};
var formatRelative_default = formatRelative;

// node_modules/date-fns/esm/locale/_lib/buildLocalizeFn/index.js
function buildLocalizeFn(args) {
  return function(dirtyIndex, options) {
    var context = options !== null && options !== void 0 && options.context ? String(options.context) : "standalone";
    var valuesArray;
    if (context === "formatting" && args.formattingValues) {
      var defaultWidth = args.defaultFormattingWidth || args.defaultWidth;
      var width = options !== null && options !== void 0 && options.width ? String(options.width) : defaultWidth;
      valuesArray = args.formattingValues[width] || args.formattingValues[defaultWidth];
    } else {
      var _defaultWidth = args.defaultWidth;
      var _width = options !== null && options !== void 0 && options.width ? String(options.width) : args.defaultWidth;
      valuesArray = args.values[_width] || args.values[_defaultWidth];
    }
    var index = args.argumentCallback ? args.argumentCallback(dirtyIndex) : dirtyIndex;
    return valuesArray[index];
  };
}

// node_modules/date-fns/esm/locale/en-US/_lib/localize/index.js
var eraValues = {
  narrow: ["B", "A"],
  abbreviated: ["BC", "AD"],
  wide: ["Before Christ", "Anno Domini"]
};
var quarterValues = {
  narrow: ["1", "2", "3", "4"],
  abbreviated: ["Q1", "Q2", "Q3", "Q4"],
  wide: ["1st quarter", "2nd quarter", "3rd quarter", "4th quarter"]
};
var monthValues = {
  narrow: ["J", "F", "M", "A", "M", "J", "J", "A", "S", "O", "N", "D"],
  abbreviated: ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"],
  wide: ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"]
};
var dayValues = {
  narrow: ["S", "M", "T", "W", "T", "F", "S"],
  short: ["Su", "Mo", "Tu", "We", "Th", "Fr", "Sa"],
  abbreviated: ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"],
  wide: ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"]
};
var dayPeriodValues = {
  narrow: {
    am: "a",
    pm: "p",
    midnight: "mi",
    noon: "n",
    morning: "morning",
    afternoon: "afternoon",
    evening: "evening",
    night: "night"
  },
  abbreviated: {
    am: "AM",
    pm: "PM",
    midnight: "midnight",
    noon: "noon",
    morning: "morning",
    afternoon: "afternoon",
    evening: "evening",
    night: "night"
  },
  wide: {
    am: "a.m.",
    pm: "p.m.",
    midnight: "midnight",
    noon: "noon",
    morning: "morning",
    afternoon: "afternoon",
    evening: "evening",
    night: "night"
  }
};
var formattingDayPeriodValues = {
  narrow: {
    am: "a",
    pm: "p",
    midnight: "mi",
    noon: "n",
    morning: "in the morning",
    afternoon: "in the afternoon",
    evening: "in the evening",
    night: "at night"
  },
  abbreviated: {
    am: "AM",
    pm: "PM",
    midnight: "midnight",
    noon: "noon",
    morning: "in the morning",
    afternoon: "in the afternoon",
    evening: "in the evening",
    night: "at night"
  },
  wide: {
    am: "a.m.",
    pm: "p.m.",
    midnight: "midnight",
    noon: "noon",
    morning: "in the morning",
    afternoon: "in the afternoon",
    evening: "in the evening",
    night: "at night"
  }
};
var ordinalNumber = function ordinalNumber2(dirtyNumber, _options) {
  var number = Number(dirtyNumber);
  var rem100 = number % 100;
  if (rem100 > 20 || rem100 < 10) {
    switch (rem100 % 10) {
      case 1:
        return number + "st";
      case 2:
        return number + "nd";
      case 3:
        return number + "rd";
    }
  }
  return number + "th";
};
var localize = {
  ordinalNumber,
  era: buildLocalizeFn({
    values: eraValues,
    defaultWidth: "wide"
  }),
  quarter: buildLocalizeFn({
    values: quarterValues,
    defaultWidth: "wide",
    argumentCallback: function argumentCallback(quarter) {
      return quarter - 1;
    }
  }),
  month: buildLocalizeFn({
    values: monthValues,
    defaultWidth: "wide"
  }),
  day: buildLocalizeFn({
    values: dayValues,
    defaultWidth: "wide"
  }),
  dayPeriod: buildLocalizeFn({
    values: dayPeriodValues,
    defaultWidth: "wide",
    formattingValues: formattingDayPeriodValues,
    defaultFormattingWidth: "wide"
  })
};
var localize_default = localize;

// node_modules/date-fns/esm/locale/_lib/buildMatchFn/index.js
function buildMatchFn(args) {
  return function(string) {
    var options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    var width = options.width;
    var matchPattern = width && args.matchPatterns[width] || args.matchPatterns[args.defaultMatchWidth];
    var matchResult = string.match(matchPattern);
    if (!matchResult) {
      return null;
    }
    var matchedString = matchResult[0];
    var parsePatterns = width && args.parsePatterns[width] || args.parsePatterns[args.defaultParseWidth];
    var key = Array.isArray(parsePatterns) ? findIndex(parsePatterns, function(pattern) {
      return pattern.test(matchedString);
    }) : findKey(parsePatterns, function(pattern) {
      return pattern.test(matchedString);
    });
    var value;
    value = args.valueCallback ? args.valueCallback(key) : key;
    value = options.valueCallback ? options.valueCallback(value) : value;
    var rest = string.slice(matchedString.length);
    return {
      value,
      rest
    };
  };
}
function findKey(object, predicate) {
  for (var key in object) {
    if (object.hasOwnProperty(key) && predicate(object[key])) {
      return key;
    }
  }
  return void 0;
}
function findIndex(array, predicate) {
  for (var key = 0; key < array.length; key++) {
    if (predicate(array[key])) {
      return key;
    }
  }
  return void 0;
}

// node_modules/date-fns/esm/locale/_lib/buildMatchPatternFn/index.js
function buildMatchPatternFn(args) {
  return function(string) {
    var options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    var matchResult = string.match(args.matchPattern);
    if (!matchResult)
      return null;
    var matchedString = matchResult[0];
    var parseResult = string.match(args.parsePattern);
    if (!parseResult)
      return null;
    var value = args.valueCallback ? args.valueCallback(parseResult[0]) : parseResult[0];
    value = options.valueCallback ? options.valueCallback(value) : value;
    var rest = string.slice(matchedString.length);
    return {
      value,
      rest
    };
  };
}

// node_modules/date-fns/esm/locale/en-US/_lib/match/index.js
var matchOrdinalNumberPattern = /^(\d+)(th|st|nd|rd)?/i;
var parseOrdinalNumberPattern = /\d+/i;
var matchEraPatterns = {
  narrow: /^(b|a)/i,
  abbreviated: /^(b\.?\s?c\.?|b\.?\s?c\.?\s?e\.?|a\.?\s?d\.?|c\.?\s?e\.?)/i,
  wide: /^(before christ|before common era|anno domini|common era)/i
};
var parseEraPatterns = {
  any: [/^b/i, /^(a|c)/i]
};
var matchQuarterPatterns = {
  narrow: /^[1234]/i,
  abbreviated: /^q[1234]/i,
  wide: /^[1234](th|st|nd|rd)? quarter/i
};
var parseQuarterPatterns = {
  any: [/1/i, /2/i, /3/i, /4/i]
};
var matchMonthPatterns = {
  narrow: /^[jfmasond]/i,
  abbreviated: /^(jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec)/i,
  wide: /^(january|february|march|april|may|june|july|august|september|october|november|december)/i
};
var parseMonthPatterns = {
  narrow: [/^j/i, /^f/i, /^m/i, /^a/i, /^m/i, /^j/i, /^j/i, /^a/i, /^s/i, /^o/i, /^n/i, /^d/i],
  any: [/^ja/i, /^f/i, /^mar/i, /^ap/i, /^may/i, /^jun/i, /^jul/i, /^au/i, /^s/i, /^o/i, /^n/i, /^d/i]
};
var matchDayPatterns = {
  narrow: /^[smtwf]/i,
  short: /^(su|mo|tu|we|th|fr|sa)/i,
  abbreviated: /^(sun|mon|tue|wed|thu|fri|sat)/i,
  wide: /^(sunday|monday|tuesday|wednesday|thursday|friday|saturday)/i
};
var parseDayPatterns = {
  narrow: [/^s/i, /^m/i, /^t/i, /^w/i, /^t/i, /^f/i, /^s/i],
  any: [/^su/i, /^m/i, /^tu/i, /^w/i, /^th/i, /^f/i, /^sa/i]
};
var matchDayPeriodPatterns = {
  narrow: /^(a|p|mi|n|(in the|at) (morning|afternoon|evening|night))/i,
  any: /^([ap]\.?\s?m\.?|midnight|noon|(in the|at) (morning|afternoon|evening|night))/i
};
var parseDayPeriodPatterns = {
  any: {
    am: /^a/i,
    pm: /^p/i,
    midnight: /^mi/i,
    noon: /^no/i,
    morning: /morning/i,
    afternoon: /afternoon/i,
    evening: /evening/i,
    night: /night/i
  }
};
var match = {
  ordinalNumber: buildMatchPatternFn({
    matchPattern: matchOrdinalNumberPattern,
    parsePattern: parseOrdinalNumberPattern,
    valueCallback: function valueCallback(value) {
      return parseInt(value, 10);
    }
  }),
  era: buildMatchFn({
    matchPatterns: matchEraPatterns,
    defaultMatchWidth: "wide",
    parsePatterns: parseEraPatterns,
    defaultParseWidth: "any"
  }),
  quarter: buildMatchFn({
    matchPatterns: matchQuarterPatterns,
    defaultMatchWidth: "wide",
    parsePatterns: parseQuarterPatterns,
    defaultParseWidth: "any",
    valueCallback: function valueCallback2(index) {
      return index + 1;
    }
  }),
  month: buildMatchFn({
    matchPatterns: matchMonthPatterns,
    defaultMatchWidth: "wide",
    parsePatterns: parseMonthPatterns,
    defaultParseWidth: "any"
  }),
  day: buildMatchFn({
    matchPatterns: matchDayPatterns,
    defaultMatchWidth: "wide",
    parsePatterns: parseDayPatterns,
    defaultParseWidth: "any"
  }),
  dayPeriod: buildMatchFn({
    matchPatterns: matchDayPeriodPatterns,
    defaultMatchWidth: "any",
    parsePatterns: parseDayPeriodPatterns,
    defaultParseWidth: "any"
  })
};
var match_default = match;

// node_modules/date-fns/esm/locale/en-US/index.js
var locale = {
  code: "en-US",
  formatDistance: formatDistance_default,
  formatLong: formatLong_default,
  formatRelative: formatRelative_default,
  localize: localize_default,
  match: match_default,
  options: {
    weekStartsOn: 0,
    firstWeekContainsDate: 1
  }
};
var en_US_default = locale;

// node_modules/date-fns/esm/_lib/defaultLocale/index.js
var defaultLocale_default = en_US_default;

// node_modules/date-fns/esm/format/index.js
var formattingTokensRegExp = /[yYQqMLwIdDecihHKkms]o|(\w)\1*|''|'(''|[^'])+('|$)|./g;
var longFormattingTokensRegExp = /P+p+|P+|p+|''|'(''|[^'])+('|$)|./g;
var escapedStringRegExp = /^'([^]*?)'?$/;
var doubleQuoteRegExp = /''/g;
var unescapedLatinCharacterRegExp = /[a-zA-Z]/;
function format(dirtyDate, dirtyFormatStr, options) {
  var _ref, _options$locale, _ref2, _ref3, _ref4, _options$firstWeekCon, _options$locale2, _options$locale2$opti, _defaultOptions$local, _defaultOptions$local2, _ref5, _ref6, _ref7, _options$weekStartsOn, _options$locale3, _options$locale3$opti, _defaultOptions$local3, _defaultOptions$local4;
  requiredArgs(2, arguments);
  var formatStr = String(dirtyFormatStr);
  var defaultOptions2 = getDefaultOptions();
  var locale2 = (_ref = (_options$locale = options === null || options === void 0 ? void 0 : options.locale) !== null && _options$locale !== void 0 ? _options$locale : defaultOptions2.locale) !== null && _ref !== void 0 ? _ref : defaultLocale_default;
  var firstWeekContainsDate = toInteger((_ref2 = (_ref3 = (_ref4 = (_options$firstWeekCon = options === null || options === void 0 ? void 0 : options.firstWeekContainsDate) !== null && _options$firstWeekCon !== void 0 ? _options$firstWeekCon : options === null || options === void 0 ? void 0 : (_options$locale2 = options.locale) === null || _options$locale2 === void 0 ? void 0 : (_options$locale2$opti = _options$locale2.options) === null || _options$locale2$opti === void 0 ? void 0 : _options$locale2$opti.firstWeekContainsDate) !== null && _ref4 !== void 0 ? _ref4 : defaultOptions2.firstWeekContainsDate) !== null && _ref3 !== void 0 ? _ref3 : (_defaultOptions$local = defaultOptions2.locale) === null || _defaultOptions$local === void 0 ? void 0 : (_defaultOptions$local2 = _defaultOptions$local.options) === null || _defaultOptions$local2 === void 0 ? void 0 : _defaultOptions$local2.firstWeekContainsDate) !== null && _ref2 !== void 0 ? _ref2 : 1);
  if (!(firstWeekContainsDate >= 1 && firstWeekContainsDate <= 7)) {
    throw new RangeError("firstWeekContainsDate must be between 1 and 7 inclusively");
  }
  var weekStartsOn = toInteger((_ref5 = (_ref6 = (_ref7 = (_options$weekStartsOn = options === null || options === void 0 ? void 0 : options.weekStartsOn) !== null && _options$weekStartsOn !== void 0 ? _options$weekStartsOn : options === null || options === void 0 ? void 0 : (_options$locale3 = options.locale) === null || _options$locale3 === void 0 ? void 0 : (_options$locale3$opti = _options$locale3.options) === null || _options$locale3$opti === void 0 ? void 0 : _options$locale3$opti.weekStartsOn) !== null && _ref7 !== void 0 ? _ref7 : defaultOptions2.weekStartsOn) !== null && _ref6 !== void 0 ? _ref6 : (_defaultOptions$local3 = defaultOptions2.locale) === null || _defaultOptions$local3 === void 0 ? void 0 : (_defaultOptions$local4 = _defaultOptions$local3.options) === null || _defaultOptions$local4 === void 0 ? void 0 : _defaultOptions$local4.weekStartsOn) !== null && _ref5 !== void 0 ? _ref5 : 0);
  if (!(weekStartsOn >= 0 && weekStartsOn <= 6)) {
    throw new RangeError("weekStartsOn must be between 0 and 6 inclusively");
  }
  if (!locale2.localize) {
    throw new RangeError("locale must contain localize property");
  }
  if (!locale2.formatLong) {
    throw new RangeError("locale must contain formatLong property");
  }
  var originalDate = toDate(dirtyDate);
  if (!isValid(originalDate)) {
    throw new RangeError("Invalid time value");
  }
  var timezoneOffset = getTimezoneOffsetInMilliseconds(originalDate);
  var utcDate = subMilliseconds(originalDate, timezoneOffset);
  var formatterOptions = {
    firstWeekContainsDate,
    weekStartsOn,
    locale: locale2,
    _originalDate: originalDate
  };
  var result = formatStr.match(longFormattingTokensRegExp).map(function(substring) {
    var firstCharacter = substring[0];
    if (firstCharacter === "p" || firstCharacter === "P") {
      var longFormatter = longFormatters_default[firstCharacter];
      return longFormatter(substring, locale2.formatLong);
    }
    return substring;
  }).join("").match(formattingTokensRegExp).map(function(substring) {
    if (substring === "''") {
      return "'";
    }
    var firstCharacter = substring[0];
    if (firstCharacter === "'") {
      return cleanEscapedString(substring);
    }
    var formatter = formatters_default[firstCharacter];
    if (formatter) {
      if (!(options !== null && options !== void 0 && options.useAdditionalWeekYearTokens) && isProtectedWeekYearToken(substring)) {
        throwProtectedError(substring, dirtyFormatStr, String(dirtyDate));
      }
      if (!(options !== null && options !== void 0 && options.useAdditionalDayOfYearTokens) && isProtectedDayOfYearToken(substring)) {
        throwProtectedError(substring, dirtyFormatStr, String(dirtyDate));
      }
      return formatter(utcDate, substring, locale2.localize, formatterOptions);
    }
    if (firstCharacter.match(unescapedLatinCharacterRegExp)) {
      throw new RangeError("Format string contains an unescaped latin alphabet character `" + firstCharacter + "`");
    }
    return substring;
  }).join("");
  return result;
}
function cleanEscapedString(input) {
  var matched = input.match(escapedStringRegExp);
  if (!matched) {
    return input;
  }
  return matched[1].replace(doubleQuoteRegExp, "'");
}

// node_modules/date-fns/esm/_lib/assign/index.js
function assign(target, object) {
  if (target == null) {
    throw new TypeError("assign requires that input parameter not be null or undefined");
  }
  for (var property in object) {
    if (Object.prototype.hasOwnProperty.call(object, property)) {
      ;
      target[property] = object[property];
    }
  }
  return target;
}

// node_modules/date-fns/esm/formatDistanceStrict/index.js
var MILLISECONDS_IN_MINUTE = 1e3 * 60;
var MINUTES_IN_DAY = 60 * 24;
var MINUTES_IN_MONTH = MINUTES_IN_DAY * 30;
var MINUTES_IN_YEAR = MINUTES_IN_DAY * 365;

// node_modules/date-fns/esm/getDay/index.js
function getDay(dirtyDate) {
  requiredArgs(1, arguments);
  var date = toDate(dirtyDate);
  var day = date.getDay();
  return day;
}

// node_modules/date-fns/esm/getDaysInMonth/index.js
function getDaysInMonth(dirtyDate) {
  requiredArgs(1, arguments);
  var date = toDate(dirtyDate);
  var year = date.getFullYear();
  var monthIndex = date.getMonth();
  var lastDayOfMonth2 = /* @__PURE__ */ new Date(0);
  lastDayOfMonth2.setFullYear(year, monthIndex + 1, 0);
  lastDayOfMonth2.setHours(0, 0, 0, 0);
  return lastDayOfMonth2.getDate();
}

// node_modules/date-fns/esm/getHours/index.js
function getHours(dirtyDate) {
  requiredArgs(1, arguments);
  var date = toDate(dirtyDate);
  var hours = date.getHours();
  return hours;
}

// node_modules/date-fns/esm/getISOWeek/index.js
var MILLISECONDS_IN_WEEK3 = 6048e5;
function getISOWeek(dirtyDate) {
  requiredArgs(1, arguments);
  var date = toDate(dirtyDate);
  var diff = startOfISOWeek(date).getTime() - startOfISOWeekYear(date).getTime();
  return Math.round(diff / MILLISECONDS_IN_WEEK3) + 1;
}

// node_modules/date-fns/esm/getMinutes/index.js
function getMinutes(dirtyDate) {
  requiredArgs(1, arguments);
  var date = toDate(dirtyDate);
  var minutes = date.getMinutes();
  return minutes;
}

// node_modules/date-fns/esm/getMonth/index.js
function getMonth(dirtyDate) {
  requiredArgs(1, arguments);
  var date = toDate(dirtyDate);
  var month = date.getMonth();
  return month;
}

// node_modules/date-fns/esm/getOverlappingDaysInIntervals/index.js
var MILLISECONDS_IN_DAY3 = 24 * 60 * 60 * 1e3;

// node_modules/date-fns/esm/getSeconds/index.js
function getSeconds(dirtyDate) {
  requiredArgs(1, arguments);
  var date = toDate(dirtyDate);
  var seconds = date.getSeconds();
  return seconds;
}

// node_modules/date-fns/esm/getWeekYear/index.js
function getWeekYear(dirtyDate, options) {
  var _ref, _ref2, _ref3, _options$firstWeekCon, _options$locale, _options$locale$optio, _defaultOptions$local, _defaultOptions$local2;
  requiredArgs(1, arguments);
  var date = toDate(dirtyDate);
  var year = date.getFullYear();
  var defaultOptions2 = getDefaultOptions();
  var firstWeekContainsDate = toInteger((_ref = (_ref2 = (_ref3 = (_options$firstWeekCon = options === null || options === void 0 ? void 0 : options.firstWeekContainsDate) !== null && _options$firstWeekCon !== void 0 ? _options$firstWeekCon : options === null || options === void 0 ? void 0 : (_options$locale = options.locale) === null || _options$locale === void 0 ? void 0 : (_options$locale$optio = _options$locale.options) === null || _options$locale$optio === void 0 ? void 0 : _options$locale$optio.firstWeekContainsDate) !== null && _ref3 !== void 0 ? _ref3 : defaultOptions2.firstWeekContainsDate) !== null && _ref2 !== void 0 ? _ref2 : (_defaultOptions$local = defaultOptions2.locale) === null || _defaultOptions$local === void 0 ? void 0 : (_defaultOptions$local2 = _defaultOptions$local.options) === null || _defaultOptions$local2 === void 0 ? void 0 : _defaultOptions$local2.firstWeekContainsDate) !== null && _ref !== void 0 ? _ref : 1);
  if (!(firstWeekContainsDate >= 1 && firstWeekContainsDate <= 7)) {
    throw new RangeError("firstWeekContainsDate must be between 1 and 7 inclusively");
  }
  var firstWeekOfNextYear = /* @__PURE__ */ new Date(0);
  firstWeekOfNextYear.setFullYear(year + 1, 0, firstWeekContainsDate);
  firstWeekOfNextYear.setHours(0, 0, 0, 0);
  var startOfNextYear = startOfWeek(firstWeekOfNextYear, options);
  var firstWeekOfThisYear = /* @__PURE__ */ new Date(0);
  firstWeekOfThisYear.setFullYear(year, 0, firstWeekContainsDate);
  firstWeekOfThisYear.setHours(0, 0, 0, 0);
  var startOfThisYear = startOfWeek(firstWeekOfThisYear, options);
  if (date.getTime() >= startOfNextYear.getTime()) {
    return year + 1;
  } else if (date.getTime() >= startOfThisYear.getTime()) {
    return year;
  } else {
    return year - 1;
  }
}

// node_modules/date-fns/esm/startOfWeekYear/index.js
function startOfWeekYear(dirtyDate, options) {
  var _ref, _ref2, _ref3, _options$firstWeekCon, _options$locale, _options$locale$optio, _defaultOptions$local, _defaultOptions$local2;
  requiredArgs(1, arguments);
  var defaultOptions2 = getDefaultOptions();
  var firstWeekContainsDate = toInteger((_ref = (_ref2 = (_ref3 = (_options$firstWeekCon = options === null || options === void 0 ? void 0 : options.firstWeekContainsDate) !== null && _options$firstWeekCon !== void 0 ? _options$firstWeekCon : options === null || options === void 0 ? void 0 : (_options$locale = options.locale) === null || _options$locale === void 0 ? void 0 : (_options$locale$optio = _options$locale.options) === null || _options$locale$optio === void 0 ? void 0 : _options$locale$optio.firstWeekContainsDate) !== null && _ref3 !== void 0 ? _ref3 : defaultOptions2.firstWeekContainsDate) !== null && _ref2 !== void 0 ? _ref2 : (_defaultOptions$local = defaultOptions2.locale) === null || _defaultOptions$local === void 0 ? void 0 : (_defaultOptions$local2 = _defaultOptions$local.options) === null || _defaultOptions$local2 === void 0 ? void 0 : _defaultOptions$local2.firstWeekContainsDate) !== null && _ref !== void 0 ? _ref : 1);
  var year = getWeekYear(dirtyDate, options);
  var firstWeek = /* @__PURE__ */ new Date(0);
  firstWeek.setFullYear(year, 0, firstWeekContainsDate);
  firstWeek.setHours(0, 0, 0, 0);
  var date = startOfWeek(firstWeek, options);
  return date;
}

// node_modules/date-fns/esm/getWeek/index.js
var MILLISECONDS_IN_WEEK4 = 6048e5;
function getWeek(dirtyDate, options) {
  requiredArgs(1, arguments);
  var date = toDate(dirtyDate);
  var diff = startOfWeek(date, options).getTime() - startOfWeekYear(date, options).getTime();
  return Math.round(diff / MILLISECONDS_IN_WEEK4) + 1;
}

// node_modules/date-fns/esm/getYear/index.js
function getYear(dirtyDate) {
  requiredArgs(1, arguments);
  return toDate(dirtyDate).getFullYear();
}

// node_modules/date-fns/esm/isAfter/index.js
function isAfter(dirtyDate, dirtyDateToCompare) {
  requiredArgs(2, arguments);
  var date = toDate(dirtyDate);
  var dateToCompare = toDate(dirtyDateToCompare);
  return date.getTime() > dateToCompare.getTime();
}

// node_modules/date-fns/esm/isBefore/index.js
function isBefore(dirtyDate, dirtyDateToCompare) {
  requiredArgs(2, arguments);
  var date = toDate(dirtyDate);
  var dateToCompare = toDate(dirtyDateToCompare);
  return date.getTime() < dateToCompare.getTime();
}

// node_modules/date-fns/esm/isEqual/index.js
function isEqual(dirtyLeftDate, dirtyRightDate) {
  requiredArgs(2, arguments);
  var dateLeft = toDate(dirtyLeftDate);
  var dateRight = toDate(dirtyRightDate);
  return dateLeft.getTime() === dateRight.getTime();
}

// node_modules/@babel/runtime/helpers/esm/arrayLikeToArray.js
function _arrayLikeToArray(arr, len) {
  if (len == null || len > arr.length)
    len = arr.length;
  for (var i2 = 0, arr2 = new Array(len); i2 < len; i2++)
    arr2[i2] = arr[i2];
  return arr2;
}

// node_modules/@babel/runtime/helpers/esm/unsupportedIterableToArray.js
function _unsupportedIterableToArray(o, minLen) {
  if (!o)
    return;
  if (typeof o === "string")
    return _arrayLikeToArray(o, minLen);
  var n = Object.prototype.toString.call(o).slice(8, -1);
  if (n === "Object" && o.constructor)
    n = o.constructor.name;
  if (n === "Map" || n === "Set")
    return Array.from(o);
  if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))
    return _arrayLikeToArray(o, minLen);
}

// node_modules/@babel/runtime/helpers/esm/createForOfIteratorHelper.js
function _createForOfIteratorHelper(o, allowArrayLike) {
  var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"];
  if (!it) {
    if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") {
      if (it)
        o = it;
      var i2 = 0;
      var F = function F2() {
      };
      return {
        s: F,
        n: function n() {
          if (i2 >= o.length)
            return {
              done: true
            };
          return {
            done: false,
            value: o[i2++]
          };
        },
        e: function e2(_e2) {
          throw _e2;
        },
        f: F
      };
    }
    throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }
  var normalCompletion = true, didErr = false, err;
  return {
    s: function s3() {
      it = it.call(o);
    },
    n: function n() {
      var step = it.next();
      normalCompletion = step.done;
      return step;
    },
    e: function e2(_e2) {
      didErr = true;
      err = _e2;
    },
    f: function f() {
      try {
        if (!normalCompletion && it["return"] != null)
          it["return"]();
      } finally {
        if (didErr)
          throw err;
      }
    }
  };
}

// node_modules/@babel/runtime/helpers/esm/assertThisInitialized.js
function _assertThisInitialized(self) {
  if (self === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return self;
}

// node_modules/@babel/runtime/helpers/esm/setPrototypeOf.js
function _setPrototypeOf(o, p) {
  _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf2(o2, p2) {
    o2.__proto__ = p2;
    return o2;
  };
  return _setPrototypeOf(o, p);
}

// node_modules/@babel/runtime/helpers/esm/inherits.js
function _inherits(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, {
    constructor: {
      value: subClass,
      writable: true,
      configurable: true
    }
  });
  Object.defineProperty(subClass, "prototype", {
    writable: false
  });
  if (superClass)
    _setPrototypeOf(subClass, superClass);
}

// node_modules/@babel/runtime/helpers/esm/getPrototypeOf.js
function _getPrototypeOf(o) {
  _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf2(o2) {
    return o2.__proto__ || Object.getPrototypeOf(o2);
  };
  return _getPrototypeOf(o);
}

// node_modules/@babel/runtime/helpers/esm/isNativeReflectConstruct.js
function _isNativeReflectConstruct() {
  if (typeof Reflect === "undefined" || !Reflect.construct)
    return false;
  if (Reflect.construct.sham)
    return false;
  if (typeof Proxy === "function")
    return true;
  try {
    Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
    }));
    return true;
  } catch (e2) {
    return false;
  }
}

// node_modules/@babel/runtime/helpers/esm/possibleConstructorReturn.js
function _possibleConstructorReturn(self, call) {
  if (call && (_typeof(call) === "object" || typeof call === "function")) {
    return call;
  } else if (call !== void 0) {
    throw new TypeError("Derived constructors may only return object or undefined");
  }
  return _assertThisInitialized(self);
}

// node_modules/@babel/runtime/helpers/esm/createSuper.js
function _createSuper(Derived) {
  var hasNativeReflectConstruct = _isNativeReflectConstruct();
  return function _createSuperInternal() {
    var Super = _getPrototypeOf(Derived), result;
    if (hasNativeReflectConstruct) {
      var NewTarget = _getPrototypeOf(this).constructor;
      result = Reflect.construct(Super, arguments, NewTarget);
    } else {
      result = Super.apply(this, arguments);
    }
    return _possibleConstructorReturn(this, result);
  };
}

// node_modules/@babel/runtime/helpers/esm/classCallCheck.js
function _classCallCheck(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}

// node_modules/@babel/runtime/helpers/esm/toPrimitive.js
function _toPrimitive(input, hint) {
  if (_typeof(input) !== "object" || input === null)
    return input;
  var prim = input[Symbol.toPrimitive];
  if (prim !== void 0) {
    var res = prim.call(input, hint || "default");
    if (_typeof(res) !== "object")
      return res;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return (hint === "string" ? String : Number)(input);
}

// node_modules/@babel/runtime/helpers/esm/toPropertyKey.js
function _toPropertyKey(arg) {
  var key = _toPrimitive(arg, "string");
  return _typeof(key) === "symbol" ? key : String(key);
}

// node_modules/@babel/runtime/helpers/esm/createClass.js
function _defineProperties(target, props) {
  for (var i2 = 0; i2 < props.length; i2++) {
    var descriptor = props[i2];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor)
      descriptor.writable = true;
    Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor);
  }
}
function _createClass(Constructor, protoProps, staticProps) {
  if (protoProps)
    _defineProperties(Constructor.prototype, protoProps);
  if (staticProps)
    _defineProperties(Constructor, staticProps);
  Object.defineProperty(Constructor, "prototype", {
    writable: false
  });
  return Constructor;
}

// node_modules/@babel/runtime/helpers/esm/defineProperty.js
function _defineProperty(obj, key, value) {
  key = _toPropertyKey(key);
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }
  return obj;
}

// node_modules/date-fns/esm/parse/_lib/Setter.js
var TIMEZONE_UNIT_PRIORITY = 10;
var Setter = function() {
  function Setter2() {
    _classCallCheck(this, Setter2);
    _defineProperty(this, "priority", void 0);
    _defineProperty(this, "subPriority", 0);
  }
  _createClass(Setter2, [{
    key: "validate",
    value: function validate(_utcDate, _options) {
      return true;
    }
  }]);
  return Setter2;
}();
var ValueSetter = function(_Setter) {
  _inherits(ValueSetter2, _Setter);
  var _super = _createSuper(ValueSetter2);
  function ValueSetter2(value, validateValue, setValue, priority, subPriority) {
    var _this;
    _classCallCheck(this, ValueSetter2);
    _this = _super.call(this);
    _this.value = value;
    _this.validateValue = validateValue;
    _this.setValue = setValue;
    _this.priority = priority;
    if (subPriority) {
      _this.subPriority = subPriority;
    }
    return _this;
  }
  _createClass(ValueSetter2, [{
    key: "validate",
    value: function validate(utcDate, options) {
      return this.validateValue(utcDate, this.value, options);
    }
  }, {
    key: "set",
    value: function set2(utcDate, flags, options) {
      return this.setValue(utcDate, flags, this.value, options);
    }
  }]);
  return ValueSetter2;
}(Setter);
var DateToSystemTimezoneSetter = function(_Setter2) {
  _inherits(DateToSystemTimezoneSetter2, _Setter2);
  var _super2 = _createSuper(DateToSystemTimezoneSetter2);
  function DateToSystemTimezoneSetter2() {
    var _this2;
    _classCallCheck(this, DateToSystemTimezoneSetter2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this2 = _super2.call.apply(_super2, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this2), "priority", TIMEZONE_UNIT_PRIORITY);
    _defineProperty(_assertThisInitialized(_this2), "subPriority", -1);
    return _this2;
  }
  _createClass(DateToSystemTimezoneSetter2, [{
    key: "set",
    value: function set2(date, flags) {
      if (flags.timestampIsSet) {
        return date;
      }
      var convertedDate = /* @__PURE__ */ new Date(0);
      convertedDate.setFullYear(date.getUTCFullYear(), date.getUTCMonth(), date.getUTCDate());
      convertedDate.setHours(date.getUTCHours(), date.getUTCMinutes(), date.getUTCSeconds(), date.getUTCMilliseconds());
      return convertedDate;
    }
  }]);
  return DateToSystemTimezoneSetter2;
}(Setter);

// node_modules/date-fns/esm/parse/_lib/Parser.js
var Parser = function() {
  function Parser2() {
    _classCallCheck(this, Parser2);
    _defineProperty(this, "incompatibleTokens", void 0);
    _defineProperty(this, "priority", void 0);
    _defineProperty(this, "subPriority", void 0);
  }
  _createClass(Parser2, [{
    key: "run",
    value: function run(dateString, token, match2, options) {
      var result = this.parse(dateString, token, match2, options);
      if (!result) {
        return null;
      }
      return {
        setter: new ValueSetter(result.value, this.validate, this.set, this.priority, this.subPriority),
        rest: result.rest
      };
    }
  }, {
    key: "validate",
    value: function validate(_utcDate, _value, _options) {
      return true;
    }
  }]);
  return Parser2;
}();

// node_modules/date-fns/esm/parse/_lib/parsers/EraParser.js
var EraParser = function(_Parser) {
  _inherits(EraParser2, _Parser);
  var _super = _createSuper(EraParser2);
  function EraParser2() {
    var _this;
    _classCallCheck(this, EraParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "priority", 140);
    _defineProperty(_assertThisInitialized(_this), "incompatibleTokens", ["R", "u", "t", "T"]);
    return _this;
  }
  _createClass(EraParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match2) {
      switch (token) {
        case "G":
        case "GG":
        case "GGG":
          return match2.era(dateString, {
            width: "abbreviated"
          }) || match2.era(dateString, {
            width: "narrow"
          });
        case "GGGGG":
          return match2.era(dateString, {
            width: "narrow"
          });
        case "GGGG":
        default:
          return match2.era(dateString, {
            width: "wide"
          }) || match2.era(dateString, {
            width: "abbreviated"
          }) || match2.era(dateString, {
            width: "narrow"
          });
      }
    }
  }, {
    key: "set",
    value: function set2(date, flags, value) {
      flags.era = value;
      date.setUTCFullYear(value, 0, 1);
      date.setUTCHours(0, 0, 0, 0);
      return date;
    }
  }]);
  return EraParser2;
}(Parser);

// node_modules/date-fns/esm/parse/_lib/constants.js
var numericPatterns = {
  month: /^(1[0-2]|0?\d)/,
  // 0 to 12
  date: /^(3[0-1]|[0-2]?\d)/,
  // 0 to 31
  dayOfYear: /^(36[0-6]|3[0-5]\d|[0-2]?\d?\d)/,
  // 0 to 366
  week: /^(5[0-3]|[0-4]?\d)/,
  // 0 to 53
  hour23h: /^(2[0-3]|[0-1]?\d)/,
  // 0 to 23
  hour24h: /^(2[0-4]|[0-1]?\d)/,
  // 0 to 24
  hour11h: /^(1[0-1]|0?\d)/,
  // 0 to 11
  hour12h: /^(1[0-2]|0?\d)/,
  // 0 to 12
  minute: /^[0-5]?\d/,
  // 0 to 59
  second: /^[0-5]?\d/,
  // 0 to 59
  singleDigit: /^\d/,
  // 0 to 9
  twoDigits: /^\d{1,2}/,
  // 0 to 99
  threeDigits: /^\d{1,3}/,
  // 0 to 999
  fourDigits: /^\d{1,4}/,
  // 0 to 9999
  anyDigitsSigned: /^-?\d+/,
  singleDigitSigned: /^-?\d/,
  // 0 to 9, -0 to -9
  twoDigitsSigned: /^-?\d{1,2}/,
  // 0 to 99, -0 to -99
  threeDigitsSigned: /^-?\d{1,3}/,
  // 0 to 999, -0 to -999
  fourDigitsSigned: /^-?\d{1,4}/
  // 0 to 9999, -0 to -9999
};
var timezonePatterns = {
  basicOptionalMinutes: /^([+-])(\d{2})(\d{2})?|Z/,
  basic: /^([+-])(\d{2})(\d{2})|Z/,
  basicOptionalSeconds: /^([+-])(\d{2})(\d{2})((\d{2}))?|Z/,
  extended: /^([+-])(\d{2}):(\d{2})|Z/,
  extendedOptionalSeconds: /^([+-])(\d{2}):(\d{2})(:(\d{2}))?|Z/
};

// node_modules/date-fns/esm/parse/_lib/utils.js
function mapValue(parseFnResult, mapFn) {
  if (!parseFnResult) {
    return parseFnResult;
  }
  return {
    value: mapFn(parseFnResult.value),
    rest: parseFnResult.rest
  };
}
function parseNumericPattern(pattern, dateString) {
  var matchResult = dateString.match(pattern);
  if (!matchResult) {
    return null;
  }
  return {
    value: parseInt(matchResult[0], 10),
    rest: dateString.slice(matchResult[0].length)
  };
}
function parseTimezonePattern(pattern, dateString) {
  var matchResult = dateString.match(pattern);
  if (!matchResult) {
    return null;
  }
  if (matchResult[0] === "Z") {
    return {
      value: 0,
      rest: dateString.slice(1)
    };
  }
  var sign = matchResult[1] === "+" ? 1 : -1;
  var hours = matchResult[2] ? parseInt(matchResult[2], 10) : 0;
  var minutes = matchResult[3] ? parseInt(matchResult[3], 10) : 0;
  var seconds = matchResult[5] ? parseInt(matchResult[5], 10) : 0;
  return {
    value: sign * (hours * millisecondsInHour + minutes * millisecondsInMinute + seconds * millisecondsInSecond),
    rest: dateString.slice(matchResult[0].length)
  };
}
function parseAnyDigitsSigned(dateString) {
  return parseNumericPattern(numericPatterns.anyDigitsSigned, dateString);
}
function parseNDigits(n, dateString) {
  switch (n) {
    case 1:
      return parseNumericPattern(numericPatterns.singleDigit, dateString);
    case 2:
      return parseNumericPattern(numericPatterns.twoDigits, dateString);
    case 3:
      return parseNumericPattern(numericPatterns.threeDigits, dateString);
    case 4:
      return parseNumericPattern(numericPatterns.fourDigits, dateString);
    default:
      return parseNumericPattern(new RegExp("^\\d{1," + n + "}"), dateString);
  }
}
function parseNDigitsSigned(n, dateString) {
  switch (n) {
    case 1:
      return parseNumericPattern(numericPatterns.singleDigitSigned, dateString);
    case 2:
      return parseNumericPattern(numericPatterns.twoDigitsSigned, dateString);
    case 3:
      return parseNumericPattern(numericPatterns.threeDigitsSigned, dateString);
    case 4:
      return parseNumericPattern(numericPatterns.fourDigitsSigned, dateString);
    default:
      return parseNumericPattern(new RegExp("^-?\\d{1," + n + "}"), dateString);
  }
}
function dayPeriodEnumToHours(dayPeriod) {
  switch (dayPeriod) {
    case "morning":
      return 4;
    case "evening":
      return 17;
    case "pm":
    case "noon":
    case "afternoon":
      return 12;
    case "am":
    case "midnight":
    case "night":
    default:
      return 0;
  }
}
function normalizeTwoDigitYear(twoDigitYear, currentYear) {
  var isCommonEra = currentYear > 0;
  var absCurrentYear = isCommonEra ? currentYear : 1 - currentYear;
  var result;
  if (absCurrentYear <= 50) {
    result = twoDigitYear || 100;
  } else {
    var rangeEnd = absCurrentYear + 50;
    var rangeEndCentury = Math.floor(rangeEnd / 100) * 100;
    var isPreviousCentury = twoDigitYear >= rangeEnd % 100;
    result = twoDigitYear + rangeEndCentury - (isPreviousCentury ? 100 : 0);
  }
  return isCommonEra ? result : 1 - result;
}
function isLeapYearIndex(year) {
  return year % 400 === 0 || year % 4 === 0 && year % 100 !== 0;
}

// node_modules/date-fns/esm/parse/_lib/parsers/YearParser.js
var YearParser = function(_Parser) {
  _inherits(YearParser2, _Parser);
  var _super = _createSuper(YearParser2);
  function YearParser2() {
    var _this;
    _classCallCheck(this, YearParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "priority", 130);
    _defineProperty(_assertThisInitialized(_this), "incompatibleTokens", ["Y", "R", "u", "w", "I", "i", "e", "c", "t", "T"]);
    return _this;
  }
  _createClass(YearParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match2) {
      var valueCallback3 = function valueCallback4(year) {
        return {
          year,
          isTwoDigitYear: token === "yy"
        };
      };
      switch (token) {
        case "y":
          return mapValue(parseNDigits(4, dateString), valueCallback3);
        case "yo":
          return mapValue(match2.ordinalNumber(dateString, {
            unit: "year"
          }), valueCallback3);
        default:
          return mapValue(parseNDigits(token.length, dateString), valueCallback3);
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value.isTwoDigitYear || value.year > 0;
    }
  }, {
    key: "set",
    value: function set2(date, flags, value) {
      var currentYear = date.getUTCFullYear();
      if (value.isTwoDigitYear) {
        var normalizedTwoDigitYear = normalizeTwoDigitYear(value.year, currentYear);
        date.setUTCFullYear(normalizedTwoDigitYear, 0, 1);
        date.setUTCHours(0, 0, 0, 0);
        return date;
      }
      var year = !("era" in flags) || flags.era === 1 ? value.year : 1 - value.year;
      date.setUTCFullYear(year, 0, 1);
      date.setUTCHours(0, 0, 0, 0);
      return date;
    }
  }]);
  return YearParser2;
}(Parser);

// node_modules/date-fns/esm/parse/_lib/parsers/LocalWeekYearParser.js
var LocalWeekYearParser = function(_Parser) {
  _inherits(LocalWeekYearParser2, _Parser);
  var _super = _createSuper(LocalWeekYearParser2);
  function LocalWeekYearParser2() {
    var _this;
    _classCallCheck(this, LocalWeekYearParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "priority", 130);
    _defineProperty(_assertThisInitialized(_this), "incompatibleTokens", ["y", "R", "u", "Q", "q", "M", "L", "I", "d", "D", "i", "t", "T"]);
    return _this;
  }
  _createClass(LocalWeekYearParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match2) {
      var valueCallback3 = function valueCallback4(year) {
        return {
          year,
          isTwoDigitYear: token === "YY"
        };
      };
      switch (token) {
        case "Y":
          return mapValue(parseNDigits(4, dateString), valueCallback3);
        case "Yo":
          return mapValue(match2.ordinalNumber(dateString, {
            unit: "year"
          }), valueCallback3);
        default:
          return mapValue(parseNDigits(token.length, dateString), valueCallback3);
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value.isTwoDigitYear || value.year > 0;
    }
  }, {
    key: "set",
    value: function set2(date, flags, value, options) {
      var currentYear = getUTCWeekYear(date, options);
      if (value.isTwoDigitYear) {
        var normalizedTwoDigitYear = normalizeTwoDigitYear(value.year, currentYear);
        date.setUTCFullYear(normalizedTwoDigitYear, 0, options.firstWeekContainsDate);
        date.setUTCHours(0, 0, 0, 0);
        return startOfUTCWeek(date, options);
      }
      var year = !("era" in flags) || flags.era === 1 ? value.year : 1 - value.year;
      date.setUTCFullYear(year, 0, options.firstWeekContainsDate);
      date.setUTCHours(0, 0, 0, 0);
      return startOfUTCWeek(date, options);
    }
  }]);
  return LocalWeekYearParser2;
}(Parser);

// node_modules/date-fns/esm/parse/_lib/parsers/ISOWeekYearParser.js
var ISOWeekYearParser = function(_Parser) {
  _inherits(ISOWeekYearParser2, _Parser);
  var _super = _createSuper(ISOWeekYearParser2);
  function ISOWeekYearParser2() {
    var _this;
    _classCallCheck(this, ISOWeekYearParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "priority", 130);
    _defineProperty(_assertThisInitialized(_this), "incompatibleTokens", ["G", "y", "Y", "u", "Q", "q", "M", "L", "w", "d", "D", "e", "c", "t", "T"]);
    return _this;
  }
  _createClass(ISOWeekYearParser2, [{
    key: "parse",
    value: function parse2(dateString, token) {
      if (token === "R") {
        return parseNDigitsSigned(4, dateString);
      }
      return parseNDigitsSigned(token.length, dateString);
    }
  }, {
    key: "set",
    value: function set2(_date, _flags, value) {
      var firstWeekOfYear = /* @__PURE__ */ new Date(0);
      firstWeekOfYear.setUTCFullYear(value, 0, 4);
      firstWeekOfYear.setUTCHours(0, 0, 0, 0);
      return startOfUTCISOWeek(firstWeekOfYear);
    }
  }]);
  return ISOWeekYearParser2;
}(Parser);

// node_modules/date-fns/esm/parse/_lib/parsers/ExtendedYearParser.js
var ExtendedYearParser = function(_Parser) {
  _inherits(ExtendedYearParser2, _Parser);
  var _super = _createSuper(ExtendedYearParser2);
  function ExtendedYearParser2() {
    var _this;
    _classCallCheck(this, ExtendedYearParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "priority", 130);
    _defineProperty(_assertThisInitialized(_this), "incompatibleTokens", ["G", "y", "Y", "R", "w", "I", "i", "e", "c", "t", "T"]);
    return _this;
  }
  _createClass(ExtendedYearParser2, [{
    key: "parse",
    value: function parse2(dateString, token) {
      if (token === "u") {
        return parseNDigitsSigned(4, dateString);
      }
      return parseNDigitsSigned(token.length, dateString);
    }
  }, {
    key: "set",
    value: function set2(date, _flags, value) {
      date.setUTCFullYear(value, 0, 1);
      date.setUTCHours(0, 0, 0, 0);
      return date;
    }
  }]);
  return ExtendedYearParser2;
}(Parser);

// node_modules/date-fns/esm/parse/_lib/parsers/QuarterParser.js
var QuarterParser = function(_Parser) {
  _inherits(QuarterParser2, _Parser);
  var _super = _createSuper(QuarterParser2);
  function QuarterParser2() {
    var _this;
    _classCallCheck(this, QuarterParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "priority", 120);
    _defineProperty(_assertThisInitialized(_this), "incompatibleTokens", ["Y", "R", "q", "M", "L", "w", "I", "d", "D", "i", "e", "c", "t", "T"]);
    return _this;
  }
  _createClass(QuarterParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match2) {
      switch (token) {
        case "Q":
        case "QQ":
          return parseNDigits(token.length, dateString);
        case "Qo":
          return match2.ordinalNumber(dateString, {
            unit: "quarter"
          });
        case "QQQ":
          return match2.quarter(dateString, {
            width: "abbreviated",
            context: "formatting"
          }) || match2.quarter(dateString, {
            width: "narrow",
            context: "formatting"
          });
        case "QQQQQ":
          return match2.quarter(dateString, {
            width: "narrow",
            context: "formatting"
          });
        case "QQQQ":
        default:
          return match2.quarter(dateString, {
            width: "wide",
            context: "formatting"
          }) || match2.quarter(dateString, {
            width: "abbreviated",
            context: "formatting"
          }) || match2.quarter(dateString, {
            width: "narrow",
            context: "formatting"
          });
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 1 && value <= 4;
    }
  }, {
    key: "set",
    value: function set2(date, _flags, value) {
      date.setUTCMonth((value - 1) * 3, 1);
      date.setUTCHours(0, 0, 0, 0);
      return date;
    }
  }]);
  return QuarterParser2;
}(Parser);

// node_modules/date-fns/esm/parse/_lib/parsers/StandAloneQuarterParser.js
var StandAloneQuarterParser = function(_Parser) {
  _inherits(StandAloneQuarterParser2, _Parser);
  var _super = _createSuper(StandAloneQuarterParser2);
  function StandAloneQuarterParser2() {
    var _this;
    _classCallCheck(this, StandAloneQuarterParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "priority", 120);
    _defineProperty(_assertThisInitialized(_this), "incompatibleTokens", ["Y", "R", "Q", "M", "L", "w", "I", "d", "D", "i", "e", "c", "t", "T"]);
    return _this;
  }
  _createClass(StandAloneQuarterParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match2) {
      switch (token) {
        case "q":
        case "qq":
          return parseNDigits(token.length, dateString);
        case "qo":
          return match2.ordinalNumber(dateString, {
            unit: "quarter"
          });
        case "qqq":
          return match2.quarter(dateString, {
            width: "abbreviated",
            context: "standalone"
          }) || match2.quarter(dateString, {
            width: "narrow",
            context: "standalone"
          });
        case "qqqqq":
          return match2.quarter(dateString, {
            width: "narrow",
            context: "standalone"
          });
        case "qqqq":
        default:
          return match2.quarter(dateString, {
            width: "wide",
            context: "standalone"
          }) || match2.quarter(dateString, {
            width: "abbreviated",
            context: "standalone"
          }) || match2.quarter(dateString, {
            width: "narrow",
            context: "standalone"
          });
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 1 && value <= 4;
    }
  }, {
    key: "set",
    value: function set2(date, _flags, value) {
      date.setUTCMonth((value - 1) * 3, 1);
      date.setUTCHours(0, 0, 0, 0);
      return date;
    }
  }]);
  return StandAloneQuarterParser2;
}(Parser);

// node_modules/date-fns/esm/parse/_lib/parsers/MonthParser.js
var MonthParser = function(_Parser) {
  _inherits(MonthParser2, _Parser);
  var _super = _createSuper(MonthParser2);
  function MonthParser2() {
    var _this;
    _classCallCheck(this, MonthParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "incompatibleTokens", ["Y", "R", "q", "Q", "L", "w", "I", "D", "i", "e", "c", "t", "T"]);
    _defineProperty(_assertThisInitialized(_this), "priority", 110);
    return _this;
  }
  _createClass(MonthParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match2) {
      var valueCallback3 = function valueCallback4(value) {
        return value - 1;
      };
      switch (token) {
        case "M":
          return mapValue(parseNumericPattern(numericPatterns.month, dateString), valueCallback3);
        case "MM":
          return mapValue(parseNDigits(2, dateString), valueCallback3);
        case "Mo":
          return mapValue(match2.ordinalNumber(dateString, {
            unit: "month"
          }), valueCallback3);
        case "MMM":
          return match2.month(dateString, {
            width: "abbreviated",
            context: "formatting"
          }) || match2.month(dateString, {
            width: "narrow",
            context: "formatting"
          });
        case "MMMMM":
          return match2.month(dateString, {
            width: "narrow",
            context: "formatting"
          });
        case "MMMM":
        default:
          return match2.month(dateString, {
            width: "wide",
            context: "formatting"
          }) || match2.month(dateString, {
            width: "abbreviated",
            context: "formatting"
          }) || match2.month(dateString, {
            width: "narrow",
            context: "formatting"
          });
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 0 && value <= 11;
    }
  }, {
    key: "set",
    value: function set2(date, _flags, value) {
      date.setUTCMonth(value, 1);
      date.setUTCHours(0, 0, 0, 0);
      return date;
    }
  }]);
  return MonthParser2;
}(Parser);

// node_modules/date-fns/esm/parse/_lib/parsers/StandAloneMonthParser.js
var StandAloneMonthParser = function(_Parser) {
  _inherits(StandAloneMonthParser2, _Parser);
  var _super = _createSuper(StandAloneMonthParser2);
  function StandAloneMonthParser2() {
    var _this;
    _classCallCheck(this, StandAloneMonthParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "priority", 110);
    _defineProperty(_assertThisInitialized(_this), "incompatibleTokens", ["Y", "R", "q", "Q", "M", "w", "I", "D", "i", "e", "c", "t", "T"]);
    return _this;
  }
  _createClass(StandAloneMonthParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match2) {
      var valueCallback3 = function valueCallback4(value) {
        return value - 1;
      };
      switch (token) {
        case "L":
          return mapValue(parseNumericPattern(numericPatterns.month, dateString), valueCallback3);
        case "LL":
          return mapValue(parseNDigits(2, dateString), valueCallback3);
        case "Lo":
          return mapValue(match2.ordinalNumber(dateString, {
            unit: "month"
          }), valueCallback3);
        case "LLL":
          return match2.month(dateString, {
            width: "abbreviated",
            context: "standalone"
          }) || match2.month(dateString, {
            width: "narrow",
            context: "standalone"
          });
        case "LLLLL":
          return match2.month(dateString, {
            width: "narrow",
            context: "standalone"
          });
        case "LLLL":
        default:
          return match2.month(dateString, {
            width: "wide",
            context: "standalone"
          }) || match2.month(dateString, {
            width: "abbreviated",
            context: "standalone"
          }) || match2.month(dateString, {
            width: "narrow",
            context: "standalone"
          });
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 0 && value <= 11;
    }
  }, {
    key: "set",
    value: function set2(date, _flags, value) {
      date.setUTCMonth(value, 1);
      date.setUTCHours(0, 0, 0, 0);
      return date;
    }
  }]);
  return StandAloneMonthParser2;
}(Parser);

// node_modules/date-fns/esm/_lib/setUTCWeek/index.js
function setUTCWeek(dirtyDate, dirtyWeek, options) {
  requiredArgs(2, arguments);
  var date = toDate(dirtyDate);
  var week = toInteger(dirtyWeek);
  var diff = getUTCWeek(date, options) - week;
  date.setUTCDate(date.getUTCDate() - diff * 7);
  return date;
}

// node_modules/date-fns/esm/parse/_lib/parsers/LocalWeekParser.js
var LocalWeekParser = function(_Parser) {
  _inherits(LocalWeekParser2, _Parser);
  var _super = _createSuper(LocalWeekParser2);
  function LocalWeekParser2() {
    var _this;
    _classCallCheck(this, LocalWeekParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "priority", 100);
    _defineProperty(_assertThisInitialized(_this), "incompatibleTokens", ["y", "R", "u", "q", "Q", "M", "L", "I", "d", "D", "i", "t", "T"]);
    return _this;
  }
  _createClass(LocalWeekParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match2) {
      switch (token) {
        case "w":
          return parseNumericPattern(numericPatterns.week, dateString);
        case "wo":
          return match2.ordinalNumber(dateString, {
            unit: "week"
          });
        default:
          return parseNDigits(token.length, dateString);
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 1 && value <= 53;
    }
  }, {
    key: "set",
    value: function set2(date, _flags, value, options) {
      return startOfUTCWeek(setUTCWeek(date, value, options), options);
    }
  }]);
  return LocalWeekParser2;
}(Parser);

// node_modules/date-fns/esm/_lib/setUTCISOWeek/index.js
function setUTCISOWeek(dirtyDate, dirtyISOWeek) {
  requiredArgs(2, arguments);
  var date = toDate(dirtyDate);
  var isoWeek = toInteger(dirtyISOWeek);
  var diff = getUTCISOWeek(date) - isoWeek;
  date.setUTCDate(date.getUTCDate() - diff * 7);
  return date;
}

// node_modules/date-fns/esm/parse/_lib/parsers/ISOWeekParser.js
var ISOWeekParser = function(_Parser) {
  _inherits(ISOWeekParser2, _Parser);
  var _super = _createSuper(ISOWeekParser2);
  function ISOWeekParser2() {
    var _this;
    _classCallCheck(this, ISOWeekParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "priority", 100);
    _defineProperty(_assertThisInitialized(_this), "incompatibleTokens", ["y", "Y", "u", "q", "Q", "M", "L", "w", "d", "D", "e", "c", "t", "T"]);
    return _this;
  }
  _createClass(ISOWeekParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match2) {
      switch (token) {
        case "I":
          return parseNumericPattern(numericPatterns.week, dateString);
        case "Io":
          return match2.ordinalNumber(dateString, {
            unit: "week"
          });
        default:
          return parseNDigits(token.length, dateString);
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 1 && value <= 53;
    }
  }, {
    key: "set",
    value: function set2(date, _flags, value) {
      return startOfUTCISOWeek(setUTCISOWeek(date, value));
    }
  }]);
  return ISOWeekParser2;
}(Parser);

// node_modules/date-fns/esm/parse/_lib/parsers/DateParser.js
var DAYS_IN_MONTH = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
var DAYS_IN_MONTH_LEAP_YEAR = [31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
var DateParser = function(_Parser) {
  _inherits(DateParser2, _Parser);
  var _super = _createSuper(DateParser2);
  function DateParser2() {
    var _this;
    _classCallCheck(this, DateParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "priority", 90);
    _defineProperty(_assertThisInitialized(_this), "subPriority", 1);
    _defineProperty(_assertThisInitialized(_this), "incompatibleTokens", ["Y", "R", "q", "Q", "w", "I", "D", "i", "e", "c", "t", "T"]);
    return _this;
  }
  _createClass(DateParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match2) {
      switch (token) {
        case "d":
          return parseNumericPattern(numericPatterns.date, dateString);
        case "do":
          return match2.ordinalNumber(dateString, {
            unit: "date"
          });
        default:
          return parseNDigits(token.length, dateString);
      }
    }
  }, {
    key: "validate",
    value: function validate(date, value) {
      var year = date.getUTCFullYear();
      var isLeapYear2 = isLeapYearIndex(year);
      var month = date.getUTCMonth();
      if (isLeapYear2) {
        return value >= 1 && value <= DAYS_IN_MONTH_LEAP_YEAR[month];
      } else {
        return value >= 1 && value <= DAYS_IN_MONTH[month];
      }
    }
  }, {
    key: "set",
    value: function set2(date, _flags, value) {
      date.setUTCDate(value);
      date.setUTCHours(0, 0, 0, 0);
      return date;
    }
  }]);
  return DateParser2;
}(Parser);

// node_modules/date-fns/esm/parse/_lib/parsers/DayOfYearParser.js
var DayOfYearParser = function(_Parser) {
  _inherits(DayOfYearParser2, _Parser);
  var _super = _createSuper(DayOfYearParser2);
  function DayOfYearParser2() {
    var _this;
    _classCallCheck(this, DayOfYearParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "priority", 90);
    _defineProperty(_assertThisInitialized(_this), "subpriority", 1);
    _defineProperty(_assertThisInitialized(_this), "incompatibleTokens", ["Y", "R", "q", "Q", "M", "L", "w", "I", "d", "E", "i", "e", "c", "t", "T"]);
    return _this;
  }
  _createClass(DayOfYearParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match2) {
      switch (token) {
        case "D":
        case "DD":
          return parseNumericPattern(numericPatterns.dayOfYear, dateString);
        case "Do":
          return match2.ordinalNumber(dateString, {
            unit: "date"
          });
        default:
          return parseNDigits(token.length, dateString);
      }
    }
  }, {
    key: "validate",
    value: function validate(date, value) {
      var year = date.getUTCFullYear();
      var isLeapYear2 = isLeapYearIndex(year);
      if (isLeapYear2) {
        return value >= 1 && value <= 366;
      } else {
        return value >= 1 && value <= 365;
      }
    }
  }, {
    key: "set",
    value: function set2(date, _flags, value) {
      date.setUTCMonth(0, value);
      date.setUTCHours(0, 0, 0, 0);
      return date;
    }
  }]);
  return DayOfYearParser2;
}(Parser);

// node_modules/date-fns/esm/_lib/setUTCDay/index.js
function setUTCDay(dirtyDate, dirtyDay, options) {
  var _ref, _ref2, _ref3, _options$weekStartsOn, _options$locale, _options$locale$optio, _defaultOptions$local, _defaultOptions$local2;
  requiredArgs(2, arguments);
  var defaultOptions2 = getDefaultOptions();
  var weekStartsOn = toInteger((_ref = (_ref2 = (_ref3 = (_options$weekStartsOn = options === null || options === void 0 ? void 0 : options.weekStartsOn) !== null && _options$weekStartsOn !== void 0 ? _options$weekStartsOn : options === null || options === void 0 ? void 0 : (_options$locale = options.locale) === null || _options$locale === void 0 ? void 0 : (_options$locale$optio = _options$locale.options) === null || _options$locale$optio === void 0 ? void 0 : _options$locale$optio.weekStartsOn) !== null && _ref3 !== void 0 ? _ref3 : defaultOptions2.weekStartsOn) !== null && _ref2 !== void 0 ? _ref2 : (_defaultOptions$local = defaultOptions2.locale) === null || _defaultOptions$local === void 0 ? void 0 : (_defaultOptions$local2 = _defaultOptions$local.options) === null || _defaultOptions$local2 === void 0 ? void 0 : _defaultOptions$local2.weekStartsOn) !== null && _ref !== void 0 ? _ref : 0);
  if (!(weekStartsOn >= 0 && weekStartsOn <= 6)) {
    throw new RangeError("weekStartsOn must be between 0 and 6 inclusively");
  }
  var date = toDate(dirtyDate);
  var day = toInteger(dirtyDay);
  var currentDay = date.getUTCDay();
  var remainder = day % 7;
  var dayIndex = (remainder + 7) % 7;
  var diff = (dayIndex < weekStartsOn ? 7 : 0) + day - currentDay;
  date.setUTCDate(date.getUTCDate() + diff);
  return date;
}

// node_modules/date-fns/esm/parse/_lib/parsers/DayParser.js
var DayParser = function(_Parser) {
  _inherits(DayParser2, _Parser);
  var _super = _createSuper(DayParser2);
  function DayParser2() {
    var _this;
    _classCallCheck(this, DayParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "priority", 90);
    _defineProperty(_assertThisInitialized(_this), "incompatibleTokens", ["D", "i", "e", "c", "t", "T"]);
    return _this;
  }
  _createClass(DayParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match2) {
      switch (token) {
        case "E":
        case "EE":
        case "EEE":
          return match2.day(dateString, {
            width: "abbreviated",
            context: "formatting"
          }) || match2.day(dateString, {
            width: "short",
            context: "formatting"
          }) || match2.day(dateString, {
            width: "narrow",
            context: "formatting"
          });
        case "EEEEE":
          return match2.day(dateString, {
            width: "narrow",
            context: "formatting"
          });
        case "EEEEEE":
          return match2.day(dateString, {
            width: "short",
            context: "formatting"
          }) || match2.day(dateString, {
            width: "narrow",
            context: "formatting"
          });
        case "EEEE":
        default:
          return match2.day(dateString, {
            width: "wide",
            context: "formatting"
          }) || match2.day(dateString, {
            width: "abbreviated",
            context: "formatting"
          }) || match2.day(dateString, {
            width: "short",
            context: "formatting"
          }) || match2.day(dateString, {
            width: "narrow",
            context: "formatting"
          });
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 0 && value <= 6;
    }
  }, {
    key: "set",
    value: function set2(date, _flags, value, options) {
      date = setUTCDay(date, value, options);
      date.setUTCHours(0, 0, 0, 0);
      return date;
    }
  }]);
  return DayParser2;
}(Parser);

// node_modules/date-fns/esm/parse/_lib/parsers/LocalDayParser.js
var LocalDayParser = function(_Parser) {
  _inherits(LocalDayParser2, _Parser);
  var _super = _createSuper(LocalDayParser2);
  function LocalDayParser2() {
    var _this;
    _classCallCheck(this, LocalDayParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "priority", 90);
    _defineProperty(_assertThisInitialized(_this), "incompatibleTokens", ["y", "R", "u", "q", "Q", "M", "L", "I", "d", "D", "E", "i", "c", "t", "T"]);
    return _this;
  }
  _createClass(LocalDayParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match2, options) {
      var valueCallback3 = function valueCallback4(value) {
        var wholeWeekDays = Math.floor((value - 1) / 7) * 7;
        return (value + options.weekStartsOn + 6) % 7 + wholeWeekDays;
      };
      switch (token) {
        case "e":
        case "ee":
          return mapValue(parseNDigits(token.length, dateString), valueCallback3);
        case "eo":
          return mapValue(match2.ordinalNumber(dateString, {
            unit: "day"
          }), valueCallback3);
        case "eee":
          return match2.day(dateString, {
            width: "abbreviated",
            context: "formatting"
          }) || match2.day(dateString, {
            width: "short",
            context: "formatting"
          }) || match2.day(dateString, {
            width: "narrow",
            context: "formatting"
          });
        case "eeeee":
          return match2.day(dateString, {
            width: "narrow",
            context: "formatting"
          });
        case "eeeeee":
          return match2.day(dateString, {
            width: "short",
            context: "formatting"
          }) || match2.day(dateString, {
            width: "narrow",
            context: "formatting"
          });
        case "eeee":
        default:
          return match2.day(dateString, {
            width: "wide",
            context: "formatting"
          }) || match2.day(dateString, {
            width: "abbreviated",
            context: "formatting"
          }) || match2.day(dateString, {
            width: "short",
            context: "formatting"
          }) || match2.day(dateString, {
            width: "narrow",
            context: "formatting"
          });
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 0 && value <= 6;
    }
  }, {
    key: "set",
    value: function set2(date, _flags, value, options) {
      date = setUTCDay(date, value, options);
      date.setUTCHours(0, 0, 0, 0);
      return date;
    }
  }]);
  return LocalDayParser2;
}(Parser);

// node_modules/date-fns/esm/parse/_lib/parsers/StandAloneLocalDayParser.js
var StandAloneLocalDayParser = function(_Parser) {
  _inherits(StandAloneLocalDayParser2, _Parser);
  var _super = _createSuper(StandAloneLocalDayParser2);
  function StandAloneLocalDayParser2() {
    var _this;
    _classCallCheck(this, StandAloneLocalDayParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "priority", 90);
    _defineProperty(_assertThisInitialized(_this), "incompatibleTokens", ["y", "R", "u", "q", "Q", "M", "L", "I", "d", "D", "E", "i", "e", "t", "T"]);
    return _this;
  }
  _createClass(StandAloneLocalDayParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match2, options) {
      var valueCallback3 = function valueCallback4(value) {
        var wholeWeekDays = Math.floor((value - 1) / 7) * 7;
        return (value + options.weekStartsOn + 6) % 7 + wholeWeekDays;
      };
      switch (token) {
        case "c":
        case "cc":
          return mapValue(parseNDigits(token.length, dateString), valueCallback3);
        case "co":
          return mapValue(match2.ordinalNumber(dateString, {
            unit: "day"
          }), valueCallback3);
        case "ccc":
          return match2.day(dateString, {
            width: "abbreviated",
            context: "standalone"
          }) || match2.day(dateString, {
            width: "short",
            context: "standalone"
          }) || match2.day(dateString, {
            width: "narrow",
            context: "standalone"
          });
        case "ccccc":
          return match2.day(dateString, {
            width: "narrow",
            context: "standalone"
          });
        case "cccccc":
          return match2.day(dateString, {
            width: "short",
            context: "standalone"
          }) || match2.day(dateString, {
            width: "narrow",
            context: "standalone"
          });
        case "cccc":
        default:
          return match2.day(dateString, {
            width: "wide",
            context: "standalone"
          }) || match2.day(dateString, {
            width: "abbreviated",
            context: "standalone"
          }) || match2.day(dateString, {
            width: "short",
            context: "standalone"
          }) || match2.day(dateString, {
            width: "narrow",
            context: "standalone"
          });
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 0 && value <= 6;
    }
  }, {
    key: "set",
    value: function set2(date, _flags, value, options) {
      date = setUTCDay(date, value, options);
      date.setUTCHours(0, 0, 0, 0);
      return date;
    }
  }]);
  return StandAloneLocalDayParser2;
}(Parser);

// node_modules/date-fns/esm/_lib/setUTCISODay/index.js
function setUTCISODay(dirtyDate, dirtyDay) {
  requiredArgs(2, arguments);
  var day = toInteger(dirtyDay);
  if (day % 7 === 0) {
    day = day - 7;
  }
  var weekStartsOn = 1;
  var date = toDate(dirtyDate);
  var currentDay = date.getUTCDay();
  var remainder = day % 7;
  var dayIndex = (remainder + 7) % 7;
  var diff = (dayIndex < weekStartsOn ? 7 : 0) + day - currentDay;
  date.setUTCDate(date.getUTCDate() + diff);
  return date;
}

// node_modules/date-fns/esm/parse/_lib/parsers/ISODayParser.js
var ISODayParser = function(_Parser) {
  _inherits(ISODayParser2, _Parser);
  var _super = _createSuper(ISODayParser2);
  function ISODayParser2() {
    var _this;
    _classCallCheck(this, ISODayParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "priority", 90);
    _defineProperty(_assertThisInitialized(_this), "incompatibleTokens", ["y", "Y", "u", "q", "Q", "M", "L", "w", "d", "D", "E", "e", "c", "t", "T"]);
    return _this;
  }
  _createClass(ISODayParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match2) {
      var valueCallback3 = function valueCallback4(value) {
        if (value === 0) {
          return 7;
        }
        return value;
      };
      switch (token) {
        case "i":
        case "ii":
          return parseNDigits(token.length, dateString);
        case "io":
          return match2.ordinalNumber(dateString, {
            unit: "day"
          });
        case "iii":
          return mapValue(match2.day(dateString, {
            width: "abbreviated",
            context: "formatting"
          }) || match2.day(dateString, {
            width: "short",
            context: "formatting"
          }) || match2.day(dateString, {
            width: "narrow",
            context: "formatting"
          }), valueCallback3);
        case "iiiii":
          return mapValue(match2.day(dateString, {
            width: "narrow",
            context: "formatting"
          }), valueCallback3);
        case "iiiiii":
          return mapValue(match2.day(dateString, {
            width: "short",
            context: "formatting"
          }) || match2.day(dateString, {
            width: "narrow",
            context: "formatting"
          }), valueCallback3);
        case "iiii":
        default:
          return mapValue(match2.day(dateString, {
            width: "wide",
            context: "formatting"
          }) || match2.day(dateString, {
            width: "abbreviated",
            context: "formatting"
          }) || match2.day(dateString, {
            width: "short",
            context: "formatting"
          }) || match2.day(dateString, {
            width: "narrow",
            context: "formatting"
          }), valueCallback3);
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 1 && value <= 7;
    }
  }, {
    key: "set",
    value: function set2(date, _flags, value) {
      date = setUTCISODay(date, value);
      date.setUTCHours(0, 0, 0, 0);
      return date;
    }
  }]);
  return ISODayParser2;
}(Parser);

// node_modules/date-fns/esm/parse/_lib/parsers/AMPMParser.js
var AMPMParser = function(_Parser) {
  _inherits(AMPMParser2, _Parser);
  var _super = _createSuper(AMPMParser2);
  function AMPMParser2() {
    var _this;
    _classCallCheck(this, AMPMParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "priority", 80);
    _defineProperty(_assertThisInitialized(_this), "incompatibleTokens", ["b", "B", "H", "k", "t", "T"]);
    return _this;
  }
  _createClass(AMPMParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match2) {
      switch (token) {
        case "a":
        case "aa":
        case "aaa":
          return match2.dayPeriod(dateString, {
            width: "abbreviated",
            context: "formatting"
          }) || match2.dayPeriod(dateString, {
            width: "narrow",
            context: "formatting"
          });
        case "aaaaa":
          return match2.dayPeriod(dateString, {
            width: "narrow",
            context: "formatting"
          });
        case "aaaa":
        default:
          return match2.dayPeriod(dateString, {
            width: "wide",
            context: "formatting"
          }) || match2.dayPeriod(dateString, {
            width: "abbreviated",
            context: "formatting"
          }) || match2.dayPeriod(dateString, {
            width: "narrow",
            context: "formatting"
          });
      }
    }
  }, {
    key: "set",
    value: function set2(date, _flags, value) {
      date.setUTCHours(dayPeriodEnumToHours(value), 0, 0, 0);
      return date;
    }
  }]);
  return AMPMParser2;
}(Parser);

// node_modules/date-fns/esm/parse/_lib/parsers/AMPMMidnightParser.js
var AMPMMidnightParser = function(_Parser) {
  _inherits(AMPMMidnightParser2, _Parser);
  var _super = _createSuper(AMPMMidnightParser2);
  function AMPMMidnightParser2() {
    var _this;
    _classCallCheck(this, AMPMMidnightParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "priority", 80);
    _defineProperty(_assertThisInitialized(_this), "incompatibleTokens", ["a", "B", "H", "k", "t", "T"]);
    return _this;
  }
  _createClass(AMPMMidnightParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match2) {
      switch (token) {
        case "b":
        case "bb":
        case "bbb":
          return match2.dayPeriod(dateString, {
            width: "abbreviated",
            context: "formatting"
          }) || match2.dayPeriod(dateString, {
            width: "narrow",
            context: "formatting"
          });
        case "bbbbb":
          return match2.dayPeriod(dateString, {
            width: "narrow",
            context: "formatting"
          });
        case "bbbb":
        default:
          return match2.dayPeriod(dateString, {
            width: "wide",
            context: "formatting"
          }) || match2.dayPeriod(dateString, {
            width: "abbreviated",
            context: "formatting"
          }) || match2.dayPeriod(dateString, {
            width: "narrow",
            context: "formatting"
          });
      }
    }
  }, {
    key: "set",
    value: function set2(date, _flags, value) {
      date.setUTCHours(dayPeriodEnumToHours(value), 0, 0, 0);
      return date;
    }
  }]);
  return AMPMMidnightParser2;
}(Parser);

// node_modules/date-fns/esm/parse/_lib/parsers/DayPeriodParser.js
var DayPeriodParser = function(_Parser) {
  _inherits(DayPeriodParser2, _Parser);
  var _super = _createSuper(DayPeriodParser2);
  function DayPeriodParser2() {
    var _this;
    _classCallCheck(this, DayPeriodParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "priority", 80);
    _defineProperty(_assertThisInitialized(_this), "incompatibleTokens", ["a", "b", "t", "T"]);
    return _this;
  }
  _createClass(DayPeriodParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match2) {
      switch (token) {
        case "B":
        case "BB":
        case "BBB":
          return match2.dayPeriod(dateString, {
            width: "abbreviated",
            context: "formatting"
          }) || match2.dayPeriod(dateString, {
            width: "narrow",
            context: "formatting"
          });
        case "BBBBB":
          return match2.dayPeriod(dateString, {
            width: "narrow",
            context: "formatting"
          });
        case "BBBB":
        default:
          return match2.dayPeriod(dateString, {
            width: "wide",
            context: "formatting"
          }) || match2.dayPeriod(dateString, {
            width: "abbreviated",
            context: "formatting"
          }) || match2.dayPeriod(dateString, {
            width: "narrow",
            context: "formatting"
          });
      }
    }
  }, {
    key: "set",
    value: function set2(date, _flags, value) {
      date.setUTCHours(dayPeriodEnumToHours(value), 0, 0, 0);
      return date;
    }
  }]);
  return DayPeriodParser2;
}(Parser);

// node_modules/date-fns/esm/parse/_lib/parsers/Hour1to12Parser.js
var Hour1to12Parser = function(_Parser) {
  _inherits(Hour1to12Parser2, _Parser);
  var _super = _createSuper(Hour1to12Parser2);
  function Hour1to12Parser2() {
    var _this;
    _classCallCheck(this, Hour1to12Parser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "priority", 70);
    _defineProperty(_assertThisInitialized(_this), "incompatibleTokens", ["H", "K", "k", "t", "T"]);
    return _this;
  }
  _createClass(Hour1to12Parser2, [{
    key: "parse",
    value: function parse2(dateString, token, match2) {
      switch (token) {
        case "h":
          return parseNumericPattern(numericPatterns.hour12h, dateString);
        case "ho":
          return match2.ordinalNumber(dateString, {
            unit: "hour"
          });
        default:
          return parseNDigits(token.length, dateString);
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 1 && value <= 12;
    }
  }, {
    key: "set",
    value: function set2(date, _flags, value) {
      var isPM = date.getUTCHours() >= 12;
      if (isPM && value < 12) {
        date.setUTCHours(value + 12, 0, 0, 0);
      } else if (!isPM && value === 12) {
        date.setUTCHours(0, 0, 0, 0);
      } else {
        date.setUTCHours(value, 0, 0, 0);
      }
      return date;
    }
  }]);
  return Hour1to12Parser2;
}(Parser);

// node_modules/date-fns/esm/parse/_lib/parsers/Hour0to23Parser.js
var Hour0to23Parser = function(_Parser) {
  _inherits(Hour0to23Parser2, _Parser);
  var _super = _createSuper(Hour0to23Parser2);
  function Hour0to23Parser2() {
    var _this;
    _classCallCheck(this, Hour0to23Parser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "priority", 70);
    _defineProperty(_assertThisInitialized(_this), "incompatibleTokens", ["a", "b", "h", "K", "k", "t", "T"]);
    return _this;
  }
  _createClass(Hour0to23Parser2, [{
    key: "parse",
    value: function parse2(dateString, token, match2) {
      switch (token) {
        case "H":
          return parseNumericPattern(numericPatterns.hour23h, dateString);
        case "Ho":
          return match2.ordinalNumber(dateString, {
            unit: "hour"
          });
        default:
          return parseNDigits(token.length, dateString);
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 0 && value <= 23;
    }
  }, {
    key: "set",
    value: function set2(date, _flags, value) {
      date.setUTCHours(value, 0, 0, 0);
      return date;
    }
  }]);
  return Hour0to23Parser2;
}(Parser);

// node_modules/date-fns/esm/parse/_lib/parsers/Hour0To11Parser.js
var Hour0To11Parser = function(_Parser) {
  _inherits(Hour0To11Parser2, _Parser);
  var _super = _createSuper(Hour0To11Parser2);
  function Hour0To11Parser2() {
    var _this;
    _classCallCheck(this, Hour0To11Parser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "priority", 70);
    _defineProperty(_assertThisInitialized(_this), "incompatibleTokens", ["h", "H", "k", "t", "T"]);
    return _this;
  }
  _createClass(Hour0To11Parser2, [{
    key: "parse",
    value: function parse2(dateString, token, match2) {
      switch (token) {
        case "K":
          return parseNumericPattern(numericPatterns.hour11h, dateString);
        case "Ko":
          return match2.ordinalNumber(dateString, {
            unit: "hour"
          });
        default:
          return parseNDigits(token.length, dateString);
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 0 && value <= 11;
    }
  }, {
    key: "set",
    value: function set2(date, _flags, value) {
      var isPM = date.getUTCHours() >= 12;
      if (isPM && value < 12) {
        date.setUTCHours(value + 12, 0, 0, 0);
      } else {
        date.setUTCHours(value, 0, 0, 0);
      }
      return date;
    }
  }]);
  return Hour0To11Parser2;
}(Parser);

// node_modules/date-fns/esm/parse/_lib/parsers/Hour1To24Parser.js
var Hour1To24Parser = function(_Parser) {
  _inherits(Hour1To24Parser2, _Parser);
  var _super = _createSuper(Hour1To24Parser2);
  function Hour1To24Parser2() {
    var _this;
    _classCallCheck(this, Hour1To24Parser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "priority", 70);
    _defineProperty(_assertThisInitialized(_this), "incompatibleTokens", ["a", "b", "h", "H", "K", "t", "T"]);
    return _this;
  }
  _createClass(Hour1To24Parser2, [{
    key: "parse",
    value: function parse2(dateString, token, match2) {
      switch (token) {
        case "k":
          return parseNumericPattern(numericPatterns.hour24h, dateString);
        case "ko":
          return match2.ordinalNumber(dateString, {
            unit: "hour"
          });
        default:
          return parseNDigits(token.length, dateString);
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 1 && value <= 24;
    }
  }, {
    key: "set",
    value: function set2(date, _flags, value) {
      var hours = value <= 24 ? value % 24 : value;
      date.setUTCHours(hours, 0, 0, 0);
      return date;
    }
  }]);
  return Hour1To24Parser2;
}(Parser);

// node_modules/date-fns/esm/parse/_lib/parsers/MinuteParser.js
var MinuteParser = function(_Parser) {
  _inherits(MinuteParser2, _Parser);
  var _super = _createSuper(MinuteParser2);
  function MinuteParser2() {
    var _this;
    _classCallCheck(this, MinuteParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "priority", 60);
    _defineProperty(_assertThisInitialized(_this), "incompatibleTokens", ["t", "T"]);
    return _this;
  }
  _createClass(MinuteParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match2) {
      switch (token) {
        case "m":
          return parseNumericPattern(numericPatterns.minute, dateString);
        case "mo":
          return match2.ordinalNumber(dateString, {
            unit: "minute"
          });
        default:
          return parseNDigits(token.length, dateString);
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 0 && value <= 59;
    }
  }, {
    key: "set",
    value: function set2(date, _flags, value) {
      date.setUTCMinutes(value, 0, 0);
      return date;
    }
  }]);
  return MinuteParser2;
}(Parser);

// node_modules/date-fns/esm/parse/_lib/parsers/SecondParser.js
var SecondParser = function(_Parser) {
  _inherits(SecondParser2, _Parser);
  var _super = _createSuper(SecondParser2);
  function SecondParser2() {
    var _this;
    _classCallCheck(this, SecondParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "priority", 50);
    _defineProperty(_assertThisInitialized(_this), "incompatibleTokens", ["t", "T"]);
    return _this;
  }
  _createClass(SecondParser2, [{
    key: "parse",
    value: function parse2(dateString, token, match2) {
      switch (token) {
        case "s":
          return parseNumericPattern(numericPatterns.second, dateString);
        case "so":
          return match2.ordinalNumber(dateString, {
            unit: "second"
          });
        default:
          return parseNDigits(token.length, dateString);
      }
    }
  }, {
    key: "validate",
    value: function validate(_date, value) {
      return value >= 0 && value <= 59;
    }
  }, {
    key: "set",
    value: function set2(date, _flags, value) {
      date.setUTCSeconds(value, 0);
      return date;
    }
  }]);
  return SecondParser2;
}(Parser);

// node_modules/date-fns/esm/parse/_lib/parsers/FractionOfSecondParser.js
var FractionOfSecondParser = function(_Parser) {
  _inherits(FractionOfSecondParser2, _Parser);
  var _super = _createSuper(FractionOfSecondParser2);
  function FractionOfSecondParser2() {
    var _this;
    _classCallCheck(this, FractionOfSecondParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "priority", 30);
    _defineProperty(_assertThisInitialized(_this), "incompatibleTokens", ["t", "T"]);
    return _this;
  }
  _createClass(FractionOfSecondParser2, [{
    key: "parse",
    value: function parse2(dateString, token) {
      var valueCallback3 = function valueCallback4(value) {
        return Math.floor(value * Math.pow(10, -token.length + 3));
      };
      return mapValue(parseNDigits(token.length, dateString), valueCallback3);
    }
  }, {
    key: "set",
    value: function set2(date, _flags, value) {
      date.setUTCMilliseconds(value);
      return date;
    }
  }]);
  return FractionOfSecondParser2;
}(Parser);

// node_modules/date-fns/esm/parse/_lib/parsers/ISOTimezoneWithZParser.js
var ISOTimezoneWithZParser = function(_Parser) {
  _inherits(ISOTimezoneWithZParser2, _Parser);
  var _super = _createSuper(ISOTimezoneWithZParser2);
  function ISOTimezoneWithZParser2() {
    var _this;
    _classCallCheck(this, ISOTimezoneWithZParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "priority", 10);
    _defineProperty(_assertThisInitialized(_this), "incompatibleTokens", ["t", "T", "x"]);
    return _this;
  }
  _createClass(ISOTimezoneWithZParser2, [{
    key: "parse",
    value: function parse2(dateString, token) {
      switch (token) {
        case "X":
          return parseTimezonePattern(timezonePatterns.basicOptionalMinutes, dateString);
        case "XX":
          return parseTimezonePattern(timezonePatterns.basic, dateString);
        case "XXXX":
          return parseTimezonePattern(timezonePatterns.basicOptionalSeconds, dateString);
        case "XXXXX":
          return parseTimezonePattern(timezonePatterns.extendedOptionalSeconds, dateString);
        case "XXX":
        default:
          return parseTimezonePattern(timezonePatterns.extended, dateString);
      }
    }
  }, {
    key: "set",
    value: function set2(date, flags, value) {
      if (flags.timestampIsSet) {
        return date;
      }
      return new Date(date.getTime() - value);
    }
  }]);
  return ISOTimezoneWithZParser2;
}(Parser);

// node_modules/date-fns/esm/parse/_lib/parsers/ISOTimezoneParser.js
var ISOTimezoneParser = function(_Parser) {
  _inherits(ISOTimezoneParser2, _Parser);
  var _super = _createSuper(ISOTimezoneParser2);
  function ISOTimezoneParser2() {
    var _this;
    _classCallCheck(this, ISOTimezoneParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "priority", 10);
    _defineProperty(_assertThisInitialized(_this), "incompatibleTokens", ["t", "T", "X"]);
    return _this;
  }
  _createClass(ISOTimezoneParser2, [{
    key: "parse",
    value: function parse2(dateString, token) {
      switch (token) {
        case "x":
          return parseTimezonePattern(timezonePatterns.basicOptionalMinutes, dateString);
        case "xx":
          return parseTimezonePattern(timezonePatterns.basic, dateString);
        case "xxxx":
          return parseTimezonePattern(timezonePatterns.basicOptionalSeconds, dateString);
        case "xxxxx":
          return parseTimezonePattern(timezonePatterns.extendedOptionalSeconds, dateString);
        case "xxx":
        default:
          return parseTimezonePattern(timezonePatterns.extended, dateString);
      }
    }
  }, {
    key: "set",
    value: function set2(date, flags, value) {
      if (flags.timestampIsSet) {
        return date;
      }
      return new Date(date.getTime() - value);
    }
  }]);
  return ISOTimezoneParser2;
}(Parser);

// node_modules/date-fns/esm/parse/_lib/parsers/TimestampSecondsParser.js
var TimestampSecondsParser = function(_Parser) {
  _inherits(TimestampSecondsParser2, _Parser);
  var _super = _createSuper(TimestampSecondsParser2);
  function TimestampSecondsParser2() {
    var _this;
    _classCallCheck(this, TimestampSecondsParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "priority", 40);
    _defineProperty(_assertThisInitialized(_this), "incompatibleTokens", "*");
    return _this;
  }
  _createClass(TimestampSecondsParser2, [{
    key: "parse",
    value: function parse2(dateString) {
      return parseAnyDigitsSigned(dateString);
    }
  }, {
    key: "set",
    value: function set2(_date, _flags, value) {
      return [new Date(value * 1e3), {
        timestampIsSet: true
      }];
    }
  }]);
  return TimestampSecondsParser2;
}(Parser);

// node_modules/date-fns/esm/parse/_lib/parsers/TimestampMillisecondsParser.js
var TimestampMillisecondsParser = function(_Parser) {
  _inherits(TimestampMillisecondsParser2, _Parser);
  var _super = _createSuper(TimestampMillisecondsParser2);
  function TimestampMillisecondsParser2() {
    var _this;
    _classCallCheck(this, TimestampMillisecondsParser2);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "priority", 20);
    _defineProperty(_assertThisInitialized(_this), "incompatibleTokens", "*");
    return _this;
  }
  _createClass(TimestampMillisecondsParser2, [{
    key: "parse",
    value: function parse2(dateString) {
      return parseAnyDigitsSigned(dateString);
    }
  }, {
    key: "set",
    value: function set2(_date, _flags, value) {
      return [new Date(value), {
        timestampIsSet: true
      }];
    }
  }]);
  return TimestampMillisecondsParser2;
}(Parser);

// node_modules/date-fns/esm/parse/_lib/parsers/index.js
var parsers = {
  G: new EraParser(),
  y: new YearParser(),
  Y: new LocalWeekYearParser(),
  R: new ISOWeekYearParser(),
  u: new ExtendedYearParser(),
  Q: new QuarterParser(),
  q: new StandAloneQuarterParser(),
  M: new MonthParser(),
  L: new StandAloneMonthParser(),
  w: new LocalWeekParser(),
  I: new ISOWeekParser(),
  d: new DateParser(),
  D: new DayOfYearParser(),
  E: new DayParser(),
  e: new LocalDayParser(),
  c: new StandAloneLocalDayParser(),
  i: new ISODayParser(),
  a: new AMPMParser(),
  b: new AMPMMidnightParser(),
  B: new DayPeriodParser(),
  h: new Hour1to12Parser(),
  H: new Hour0to23Parser(),
  K: new Hour0To11Parser(),
  k: new Hour1To24Parser(),
  m: new MinuteParser(),
  s: new SecondParser(),
  S: new FractionOfSecondParser(),
  X: new ISOTimezoneWithZParser(),
  x: new ISOTimezoneParser(),
  t: new TimestampSecondsParser(),
  T: new TimestampMillisecondsParser()
};

// node_modules/date-fns/esm/parse/index.js
var formattingTokensRegExp2 = /[yYQqMLwIdDecihHKkms]o|(\w)\1*|''|'(''|[^'])+('|$)|./g;
var longFormattingTokensRegExp2 = /P+p+|P+|p+|''|'(''|[^'])+('|$)|./g;
var escapedStringRegExp2 = /^'([^]*?)'?$/;
var doubleQuoteRegExp2 = /''/g;
var notWhitespaceRegExp = /\S/;
var unescapedLatinCharacterRegExp2 = /[a-zA-Z]/;
function parse(dirtyDateString, dirtyFormatString, dirtyReferenceDate, options) {
  var _ref, _options$locale, _ref2, _ref3, _ref4, _options$firstWeekCon, _options$locale2, _options$locale2$opti, _defaultOptions$local, _defaultOptions$local2, _ref5, _ref6, _ref7, _options$weekStartsOn, _options$locale3, _options$locale3$opti, _defaultOptions$local3, _defaultOptions$local4;
  requiredArgs(3, arguments);
  var dateString = String(dirtyDateString);
  var formatString = String(dirtyFormatString);
  var defaultOptions2 = getDefaultOptions();
  var locale2 = (_ref = (_options$locale = options === null || options === void 0 ? void 0 : options.locale) !== null && _options$locale !== void 0 ? _options$locale : defaultOptions2.locale) !== null && _ref !== void 0 ? _ref : defaultLocale_default;
  if (!locale2.match) {
    throw new RangeError("locale must contain match property");
  }
  var firstWeekContainsDate = toInteger((_ref2 = (_ref3 = (_ref4 = (_options$firstWeekCon = options === null || options === void 0 ? void 0 : options.firstWeekContainsDate) !== null && _options$firstWeekCon !== void 0 ? _options$firstWeekCon : options === null || options === void 0 ? void 0 : (_options$locale2 = options.locale) === null || _options$locale2 === void 0 ? void 0 : (_options$locale2$opti = _options$locale2.options) === null || _options$locale2$opti === void 0 ? void 0 : _options$locale2$opti.firstWeekContainsDate) !== null && _ref4 !== void 0 ? _ref4 : defaultOptions2.firstWeekContainsDate) !== null && _ref3 !== void 0 ? _ref3 : (_defaultOptions$local = defaultOptions2.locale) === null || _defaultOptions$local === void 0 ? void 0 : (_defaultOptions$local2 = _defaultOptions$local.options) === null || _defaultOptions$local2 === void 0 ? void 0 : _defaultOptions$local2.firstWeekContainsDate) !== null && _ref2 !== void 0 ? _ref2 : 1);
  if (!(firstWeekContainsDate >= 1 && firstWeekContainsDate <= 7)) {
    throw new RangeError("firstWeekContainsDate must be between 1 and 7 inclusively");
  }
  var weekStartsOn = toInteger((_ref5 = (_ref6 = (_ref7 = (_options$weekStartsOn = options === null || options === void 0 ? void 0 : options.weekStartsOn) !== null && _options$weekStartsOn !== void 0 ? _options$weekStartsOn : options === null || options === void 0 ? void 0 : (_options$locale3 = options.locale) === null || _options$locale3 === void 0 ? void 0 : (_options$locale3$opti = _options$locale3.options) === null || _options$locale3$opti === void 0 ? void 0 : _options$locale3$opti.weekStartsOn) !== null && _ref7 !== void 0 ? _ref7 : defaultOptions2.weekStartsOn) !== null && _ref6 !== void 0 ? _ref6 : (_defaultOptions$local3 = defaultOptions2.locale) === null || _defaultOptions$local3 === void 0 ? void 0 : (_defaultOptions$local4 = _defaultOptions$local3.options) === null || _defaultOptions$local4 === void 0 ? void 0 : _defaultOptions$local4.weekStartsOn) !== null && _ref5 !== void 0 ? _ref5 : 0);
  if (!(weekStartsOn >= 0 && weekStartsOn <= 6)) {
    throw new RangeError("weekStartsOn must be between 0 and 6 inclusively");
  }
  if (formatString === "") {
    if (dateString === "") {
      return toDate(dirtyReferenceDate);
    } else {
      return /* @__PURE__ */ new Date(NaN);
    }
  }
  var subFnOptions = {
    firstWeekContainsDate,
    weekStartsOn,
    locale: locale2
  };
  var setters = [new DateToSystemTimezoneSetter()];
  var tokens = formatString.match(longFormattingTokensRegExp2).map(function(substring) {
    var firstCharacter = substring[0];
    if (firstCharacter in longFormatters_default) {
      var longFormatter = longFormatters_default[firstCharacter];
      return longFormatter(substring, locale2.formatLong);
    }
    return substring;
  }).join("").match(formattingTokensRegExp2);
  var usedTokens = [];
  var _iterator = _createForOfIteratorHelper(tokens), _step;
  try {
    var _loop = function _loop2() {
      var token = _step.value;
      if (!(options !== null && options !== void 0 && options.useAdditionalWeekYearTokens) && isProtectedWeekYearToken(token)) {
        throwProtectedError(token, formatString, dirtyDateString);
      }
      if (!(options !== null && options !== void 0 && options.useAdditionalDayOfYearTokens) && isProtectedDayOfYearToken(token)) {
        throwProtectedError(token, formatString, dirtyDateString);
      }
      var firstCharacter = token[0];
      var parser = parsers[firstCharacter];
      if (parser) {
        var incompatibleTokens = parser.incompatibleTokens;
        if (Array.isArray(incompatibleTokens)) {
          var incompatibleToken = usedTokens.find(function(usedToken) {
            return incompatibleTokens.includes(usedToken.token) || usedToken.token === firstCharacter;
          });
          if (incompatibleToken) {
            throw new RangeError("The format string mustn't contain `".concat(incompatibleToken.fullToken, "` and `").concat(token, "` at the same time"));
          }
        } else if (parser.incompatibleTokens === "*" && usedTokens.length > 0) {
          throw new RangeError("The format string mustn't contain `".concat(token, "` and any other token at the same time"));
        }
        usedTokens.push({
          token: firstCharacter,
          fullToken: token
        });
        var parseResult = parser.run(dateString, token, locale2.match, subFnOptions);
        if (!parseResult) {
          return {
            v: /* @__PURE__ */ new Date(NaN)
          };
        }
        setters.push(parseResult.setter);
        dateString = parseResult.rest;
      } else {
        if (firstCharacter.match(unescapedLatinCharacterRegExp2)) {
          throw new RangeError("Format string contains an unescaped latin alphabet character `" + firstCharacter + "`");
        }
        if (token === "''") {
          token = "'";
        } else if (firstCharacter === "'") {
          token = cleanEscapedString2(token);
        }
        if (dateString.indexOf(token) === 0) {
          dateString = dateString.slice(token.length);
        } else {
          return {
            v: /* @__PURE__ */ new Date(NaN)
          };
        }
      }
    };
    for (_iterator.s(); !(_step = _iterator.n()).done; ) {
      var _ret = _loop();
      if (_typeof(_ret) === "object")
        return _ret.v;
    }
  } catch (err) {
    _iterator.e(err);
  } finally {
    _iterator.f();
  }
  if (dateString.length > 0 && notWhitespaceRegExp.test(dateString)) {
    return /* @__PURE__ */ new Date(NaN);
  }
  var uniquePrioritySetters = setters.map(function(setter2) {
    return setter2.priority;
  }).sort(function(a3, b2) {
    return b2 - a3;
  }).filter(function(priority, index, array) {
    return array.indexOf(priority) === index;
  }).map(function(priority) {
    return setters.filter(function(setter2) {
      return setter2.priority === priority;
    }).sort(function(a3, b2) {
      return b2.subPriority - a3.subPriority;
    });
  }).map(function(setterArray) {
    return setterArray[0];
  });
  var date = toDate(dirtyReferenceDate);
  if (isNaN(date.getTime())) {
    return /* @__PURE__ */ new Date(NaN);
  }
  var utcDate = subMilliseconds(date, getTimezoneOffsetInMilliseconds(date));
  var flags = {};
  var _iterator2 = _createForOfIteratorHelper(uniquePrioritySetters), _step2;
  try {
    for (_iterator2.s(); !(_step2 = _iterator2.n()).done; ) {
      var setter = _step2.value;
      if (!setter.validate(utcDate, subFnOptions)) {
        return /* @__PURE__ */ new Date(NaN);
      }
      var result = setter.set(utcDate, flags, subFnOptions);
      if (Array.isArray(result)) {
        utcDate = result[0];
        assign(flags, result[1]);
      } else {
        utcDate = result;
      }
    }
  } catch (err) {
    _iterator2.e(err);
  } finally {
    _iterator2.f();
  }
  return utcDate;
}
function cleanEscapedString2(input) {
  return input.match(escapedStringRegExp2)[1].replace(doubleQuoteRegExp2, "'");
}

// node_modules/date-fns/esm/subDays/index.js
function subDays(dirtyDate, dirtyAmount) {
  requiredArgs(2, arguments);
  var amount = toInteger(dirtyAmount);
  return addDays(dirtyDate, -amount);
}

// node_modules/date-fns/esm/parseISO/index.js
function parseISO(argument, options) {
  var _options$additionalDi;
  requiredArgs(1, arguments);
  var additionalDigits = toInteger((_options$additionalDi = options === null || options === void 0 ? void 0 : options.additionalDigits) !== null && _options$additionalDi !== void 0 ? _options$additionalDi : 2);
  if (additionalDigits !== 2 && additionalDigits !== 1 && additionalDigits !== 0) {
    throw new RangeError("additionalDigits must be 0, 1 or 2");
  }
  if (!(typeof argument === "string" || Object.prototype.toString.call(argument) === "[object String]")) {
    return /* @__PURE__ */ new Date(NaN);
  }
  var dateStrings = splitDateString(argument);
  var date;
  if (dateStrings.date) {
    var parseYearResult = parseYear(dateStrings.date, additionalDigits);
    date = parseDate(parseYearResult.restDateString, parseYearResult.year);
  }
  if (!date || isNaN(date.getTime())) {
    return /* @__PURE__ */ new Date(NaN);
  }
  var timestamp = date.getTime();
  var time = 0;
  var offset;
  if (dateStrings.time) {
    time = parseTime(dateStrings.time);
    if (isNaN(time)) {
      return /* @__PURE__ */ new Date(NaN);
    }
  }
  if (dateStrings.timezone) {
    offset = parseTimezone(dateStrings.timezone);
    if (isNaN(offset)) {
      return /* @__PURE__ */ new Date(NaN);
    }
  } else {
    var dirtyDate = new Date(timestamp + time);
    var result = /* @__PURE__ */ new Date(0);
    result.setFullYear(dirtyDate.getUTCFullYear(), dirtyDate.getUTCMonth(), dirtyDate.getUTCDate());
    result.setHours(dirtyDate.getUTCHours(), dirtyDate.getUTCMinutes(), dirtyDate.getUTCSeconds(), dirtyDate.getUTCMilliseconds());
    return result;
  }
  return new Date(timestamp + time + offset);
}
var patterns = {
  dateTimeDelimiter: /[T ]/,
  timeZoneDelimiter: /[Z ]/i,
  timezone: /([Z+-].*)$/
};
var dateRegex = /^-?(?:(\d{3})|(\d{2})(?:-?(\d{2}))?|W(\d{2})(?:-?(\d{1}))?|)$/;
var timeRegex = /^(\d{2}(?:[.,]\d*)?)(?::?(\d{2}(?:[.,]\d*)?))?(?::?(\d{2}(?:[.,]\d*)?))?$/;
var timezoneRegex = /^([+-])(\d{2})(?::?(\d{2}))?$/;
function splitDateString(dateString) {
  var dateStrings = {};
  var array = dateString.split(patterns.dateTimeDelimiter);
  var timeString;
  if (array.length > 2) {
    return dateStrings;
  }
  if (/:/.test(array[0])) {
    timeString = array[0];
  } else {
    dateStrings.date = array[0];
    timeString = array[1];
    if (patterns.timeZoneDelimiter.test(dateStrings.date)) {
      dateStrings.date = dateString.split(patterns.timeZoneDelimiter)[0];
      timeString = dateString.substr(dateStrings.date.length, dateString.length);
    }
  }
  if (timeString) {
    var token = patterns.timezone.exec(timeString);
    if (token) {
      dateStrings.time = timeString.replace(token[1], "");
      dateStrings.timezone = token[1];
    } else {
      dateStrings.time = timeString;
    }
  }
  return dateStrings;
}
function parseYear(dateString, additionalDigits) {
  var regex = new RegExp("^(?:(\\d{4}|[+-]\\d{" + (4 + additionalDigits) + "})|(\\d{2}|[+-]\\d{" + (2 + additionalDigits) + "})$)");
  var captures = dateString.match(regex);
  if (!captures)
    return {
      year: NaN,
      restDateString: ""
    };
  var year = captures[1] ? parseInt(captures[1]) : null;
  var century = captures[2] ? parseInt(captures[2]) : null;
  return {
    year: century === null ? year : century * 100,
    restDateString: dateString.slice((captures[1] || captures[2]).length)
  };
}
function parseDate(dateString, year) {
  if (year === null)
    return /* @__PURE__ */ new Date(NaN);
  var captures = dateString.match(dateRegex);
  if (!captures)
    return /* @__PURE__ */ new Date(NaN);
  var isWeekDate = !!captures[4];
  var dayOfYear = parseDateUnit(captures[1]);
  var month = parseDateUnit(captures[2]) - 1;
  var day = parseDateUnit(captures[3]);
  var week = parseDateUnit(captures[4]);
  var dayOfWeek = parseDateUnit(captures[5]) - 1;
  if (isWeekDate) {
    if (!validateWeekDate(year, week, dayOfWeek)) {
      return /* @__PURE__ */ new Date(NaN);
    }
    return dayOfISOWeekYear(year, week, dayOfWeek);
  } else {
    var date = /* @__PURE__ */ new Date(0);
    if (!validateDate(year, month, day) || !validateDayOfYearDate(year, dayOfYear)) {
      return /* @__PURE__ */ new Date(NaN);
    }
    date.setUTCFullYear(year, month, Math.max(dayOfYear, day));
    return date;
  }
}
function parseDateUnit(value) {
  return value ? parseInt(value) : 1;
}
function parseTime(timeString) {
  var captures = timeString.match(timeRegex);
  if (!captures)
    return NaN;
  var hours = parseTimeUnit(captures[1]);
  var minutes = parseTimeUnit(captures[2]);
  var seconds = parseTimeUnit(captures[3]);
  if (!validateTime(hours, minutes, seconds)) {
    return NaN;
  }
  return hours * millisecondsInHour + minutes * millisecondsInMinute + seconds * 1e3;
}
function parseTimeUnit(value) {
  return value && parseFloat(value.replace(",", ".")) || 0;
}
function parseTimezone(timezoneString) {
  if (timezoneString === "Z")
    return 0;
  var captures = timezoneString.match(timezoneRegex);
  if (!captures)
    return 0;
  var sign = captures[1] === "+" ? -1 : 1;
  var hours = parseInt(captures[2]);
  var minutes = captures[3] && parseInt(captures[3]) || 0;
  if (!validateTimezone(hours, minutes)) {
    return NaN;
  }
  return sign * (hours * millisecondsInHour + minutes * millisecondsInMinute);
}
function dayOfISOWeekYear(isoWeekYear, week, day) {
  var date = /* @__PURE__ */ new Date(0);
  date.setUTCFullYear(isoWeekYear, 0, 4);
  var fourthOfJanuaryDay = date.getUTCDay() || 7;
  var diff = (week - 1) * 7 + day + 1 - fourthOfJanuaryDay;
  date.setUTCDate(date.getUTCDate() + diff);
  return date;
}
var daysInMonths = [31, null, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
function isLeapYearIndex2(year) {
  return year % 400 === 0 || year % 4 === 0 && year % 100 !== 0;
}
function validateDate(year, month, date) {
  return month >= 0 && month <= 11 && date >= 1 && date <= (daysInMonths[month] || (isLeapYearIndex2(year) ? 29 : 28));
}
function validateDayOfYearDate(year, dayOfYear) {
  return dayOfYear >= 1 && dayOfYear <= (isLeapYearIndex2(year) ? 366 : 365);
}
function validateWeekDate(_year, week, day) {
  return week >= 1 && week <= 53 && day >= 0 && day <= 6;
}
function validateTime(hours, minutes, seconds) {
  if (hours === 24) {
    return minutes === 0 && seconds === 0;
  }
  return seconds >= 0 && seconds < 60 && minutes >= 0 && minutes < 60 && hours >= 0 && hours < 25;
}
function validateTimezone(_hours, minutes) {
  return minutes >= 0 && minutes <= 59;
}

// node_modules/date-fns/esm/setMonth/index.js
function setMonth(dirtyDate, dirtyMonth) {
  requiredArgs(2, arguments);
  var date = toDate(dirtyDate);
  var month = toInteger(dirtyMonth);
  var year = date.getFullYear();
  var day = date.getDate();
  var dateWithDesiredMonth = /* @__PURE__ */ new Date(0);
  dateWithDesiredMonth.setFullYear(year, month, 15);
  dateWithDesiredMonth.setHours(0, 0, 0, 0);
  var daysInMonth = getDaysInMonth(dateWithDesiredMonth);
  date.setMonth(month, Math.min(day, daysInMonth));
  return date;
}

// node_modules/date-fns/esm/set/index.js
function set(dirtyDate, values) {
  requiredArgs(2, arguments);
  if (_typeof(values) !== "object" || values === null) {
    throw new RangeError("values parameter must be an object");
  }
  var date = toDate(dirtyDate);
  if (isNaN(date.getTime())) {
    return /* @__PURE__ */ new Date(NaN);
  }
  if (values.year != null) {
    date.setFullYear(values.year);
  }
  if (values.month != null) {
    date = setMonth(date, values.month);
  }
  if (values.date != null) {
    date.setDate(toInteger(values.date));
  }
  if (values.hours != null) {
    date.setHours(toInteger(values.hours));
  }
  if (values.minutes != null) {
    date.setMinutes(toInteger(values.minutes));
  }
  if (values.seconds != null) {
    date.setSeconds(toInteger(values.seconds));
  }
  if (values.milliseconds != null) {
    date.setMilliseconds(toInteger(values.milliseconds));
  }
  return date;
}

// node_modules/date-fns/esm/setHours/index.js
function setHours(dirtyDate, dirtyHours) {
  requiredArgs(2, arguments);
  var date = toDate(dirtyDate);
  var hours = toInteger(dirtyHours);
  date.setHours(hours);
  return date;
}

// node_modules/date-fns/esm/setMilliseconds/index.js
function setMilliseconds(dirtyDate, dirtyMilliseconds) {
  requiredArgs(2, arguments);
  var date = toDate(dirtyDate);
  var milliseconds2 = toInteger(dirtyMilliseconds);
  date.setMilliseconds(milliseconds2);
  return date;
}

// node_modules/date-fns/esm/setMinutes/index.js
function setMinutes(dirtyDate, dirtyMinutes) {
  requiredArgs(2, arguments);
  var date = toDate(dirtyDate);
  var minutes = toInteger(dirtyMinutes);
  date.setMinutes(minutes);
  return date;
}

// node_modules/date-fns/esm/setSeconds/index.js
function setSeconds(dirtyDate, dirtySeconds) {
  requiredArgs(2, arguments);
  var date = toDate(dirtyDate);
  var seconds = toInteger(dirtySeconds);
  date.setSeconds(seconds);
  return date;
}

// node_modules/date-fns/esm/setYear/index.js
function setYear(dirtyDate, dirtyYear) {
  requiredArgs(2, arguments);
  var date = toDate(dirtyDate);
  var year = toInteger(dirtyYear);
  if (isNaN(date.getTime())) {
    return /* @__PURE__ */ new Date(NaN);
  }
  date.setFullYear(year);
  return date;
}

// node_modules/date-fns/esm/subMonths/index.js
function subMonths(dirtyDate, dirtyAmount) {
  requiredArgs(2, arguments);
  var amount = toInteger(dirtyAmount);
  return addMonths(dirtyDate, -amount);
}

// node_modules/date-fns/esm/sub/index.js
function sub(date, duration) {
  requiredArgs(2, arguments);
  if (!duration || _typeof(duration) !== "object")
    return /* @__PURE__ */ new Date(NaN);
  var years = duration.years ? toInteger(duration.years) : 0;
  var months = duration.months ? toInteger(duration.months) : 0;
  var weeks = duration.weeks ? toInteger(duration.weeks) : 0;
  var days = duration.days ? toInteger(duration.days) : 0;
  var hours = duration.hours ? toInteger(duration.hours) : 0;
  var minutes = duration.minutes ? toInteger(duration.minutes) : 0;
  var seconds = duration.seconds ? toInteger(duration.seconds) : 0;
  var dateWithoutMonths = subMonths(date, months + years * 12);
  var dateWithoutDays = subDays(dateWithoutMonths, days + weeks * 7);
  var minutestoSub = minutes + hours * 60;
  var secondstoSub = seconds + minutestoSub * 60;
  var mstoSub = secondstoSub * 1e3;
  var finalDate = new Date(dateWithoutDays.getTime() - mstoSub);
  return finalDate;
}

// node_modules/date-fns/esm/subYears/index.js
function subYears(dirtyDate, dirtyAmount) {
  requiredArgs(2, arguments);
  var amount = toInteger(dirtyAmount);
  return addYears(dirtyDate, -amount);
}

// node_modules/@vuepic/vue-datepicker/dist/vue-datepicker.js
function Kt() {
  return openBlock(), createElementBlock(
    "svg",
    {
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: "0 0 32 32",
      fill: "currentColor",
      "aria-hidden": "true",
      class: "dp__icon"
    },
    [
      createBaseVNode("path", {
        d: "M29.333 8c0-2.208-1.792-4-4-4h-18.667c-2.208 0-4 1.792-4 4v18.667c0 2.208 1.792 4 4 4h18.667c2.208 0 4-1.792 4-4v-18.667zM26.667 8v18.667c0 0.736-0.597 1.333-1.333 1.333 0 0-18.667 0-18.667 0-0.736 0-1.333-0.597-1.333-1.333 0 0 0-18.667 0-18.667 0-0.736 0.597-1.333 1.333-1.333 0 0 18.667 0 18.667 0 0.736 0 1.333 0.597 1.333 1.333z"
      }),
      createBaseVNode("path", {
        d: "M20 2.667v5.333c0 0.736 0.597 1.333 1.333 1.333s1.333-0.597 1.333-1.333v-5.333c0-0.736-0.597-1.333-1.333-1.333s-1.333 0.597-1.333 1.333z"
      }),
      createBaseVNode("path", {
        d: "M9.333 2.667v5.333c0 0.736 0.597 1.333 1.333 1.333s1.333-0.597 1.333-1.333v-5.333c0-0.736-0.597-1.333-1.333-1.333s-1.333 0.597-1.333 1.333z"
      }),
      createBaseVNode("path", {
        d: "M4 14.667h24c0.736 0 1.333-0.597 1.333-1.333s-0.597-1.333-1.333-1.333h-24c-0.736 0-1.333 0.597-1.333 1.333s0.597 1.333 1.333 1.333z"
      })
    ]
  );
}
function Da() {
  return openBlock(), createElementBlock(
    "svg",
    {
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: "0 0 32 32",
      fill: "currentColor",
      "aria-hidden": "true",
      class: "dp__icon"
    },
    [
      createBaseVNode("path", {
        d: "M23.057 7.057l-16 16c-0.52 0.52-0.52 1.365 0 1.885s1.365 0.52 1.885 0l16-16c0.52-0.52 0.52-1.365 0-1.885s-1.365-0.52-1.885 0z"
      }),
      createBaseVNode("path", {
        d: "M7.057 8.943l16 16c0.52 0.52 1.365 0.52 1.885 0s0.52-1.365 0-1.885l-16-16c-0.52-0.52-1.365-0.52-1.885 0s-0.52 1.365 0 1.885z"
      })
    ]
  );
}
function Pn() {
  return openBlock(), createElementBlock(
    "svg",
    {
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: "0 0 32 32",
      fill: "currentColor",
      "aria-hidden": "true",
      class: "dp__icon"
    },
    [
      createBaseVNode("path", {
        d: "M20.943 23.057l-7.057-7.057c0 0 7.057-7.057 7.057-7.057 0.52-0.52 0.52-1.365 0-1.885s-1.365-0.52-1.885 0l-8 8c-0.521 0.521-0.521 1.365 0 1.885l8 8c0.52 0.52 1.365 0.52 1.885 0s0.52-1.365 0-1.885z"
      })
    ]
  );
}
function _n() {
  return openBlock(), createElementBlock(
    "svg",
    {
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: "0 0 32 32",
      fill: "currentColor",
      "aria-hidden": "true",
      class: "dp__icon"
    },
    [
      createBaseVNode("path", {
        d: "M12.943 24.943l8-8c0.521-0.521 0.521-1.365 0-1.885l-8-8c-0.52-0.52-1.365-0.52-1.885 0s-0.52 1.365 0 1.885l7.057 7.057c0 0-7.057 7.057-7.057 7.057-0.52 0.52-0.52 1.365 0 1.885s1.365 0.52 1.885 0z"
      })
    ]
  );
}
function Xn() {
  return openBlock(), createElementBlock(
    "svg",
    {
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: "0 0 32 32",
      fill: "currentColor",
      "aria-hidden": "true",
      class: "dp__icon"
    },
    [
      createBaseVNode("path", {
        d: "M16 1.333c-8.095 0-14.667 6.572-14.667 14.667s6.572 14.667 14.667 14.667c8.095 0 14.667-6.572 14.667-14.667s-6.572-14.667-14.667-14.667zM16 4c6.623 0 12 5.377 12 12s-5.377 12-12 12c-6.623 0-12-5.377-12-12s5.377-12 12-12z"
      }),
      createBaseVNode("path", {
        d: "M14.667 8v8c0 0.505 0.285 0.967 0.737 1.193l5.333 2.667c0.658 0.329 1.46 0.062 1.789-0.596s0.062-1.46-0.596-1.789l-4.596-2.298c0 0 0-7.176 0-7.176 0-0.736-0.597-1.333-1.333-1.333s-1.333 0.597-1.333 1.333z"
      })
    ]
  );
}
function Jn() {
  return openBlock(), createElementBlock(
    "svg",
    {
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: "0 0 32 32",
      fill: "currentColor",
      "aria-hidden": "true",
      class: "dp__icon"
    },
    [
      createBaseVNode("path", {
        d: "M24.943 19.057l-8-8c-0.521-0.521-1.365-0.521-1.885 0l-8 8c-0.52 0.52-0.52 1.365 0 1.885s1.365 0.52 1.885 0l7.057-7.057c0 0 7.057 7.057 7.057 7.057 0.52 0.52 1.365 0.52 1.885 0s0.52-1.365 0-1.885z"
      })
    ]
  );
}
function Qn() {
  return openBlock(), createElementBlock(
    "svg",
    {
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: "0 0 32 32",
      fill: "currentColor",
      "aria-hidden": "true",
      class: "dp__icon"
    },
    [
      createBaseVNode("path", {
        d: "M7.057 12.943l8 8c0.521 0.521 1.365 0.521 1.885 0l8-8c0.52-0.52 0.52-1.365 0-1.885s-1.365-0.52-1.885 0l-7.057 7.057c0 0-7.057-7.057-7.057-7.057-0.52-0.52-1.365-0.52-1.885 0s-0.52 1.365 0 1.885z"
      })
    ]
  );
}
var Cn = (e2, n, a3, t2, i2) => {
  const v = parse(e2, n.slice(0, e2.length), /* @__PURE__ */ new Date());
  return isValid(v) && isDate(v) ? t2 || i2 ? v : set(v, {
    hours: +a3.hours,
    minutes: +(a3 == null ? void 0 : a3.minutes),
    seconds: +(a3 == null ? void 0 : a3.seconds),
    milliseconds: 0
  }) : null;
};
var $a = (e2, n, a3, t2, i2) => {
  const v = Array.isArray(a3) ? a3[0] : a3;
  if (typeof n == "string")
    return Cn(e2, n, v, t2, i2);
  if (Array.isArray(n)) {
    let m3 = null;
    for (const T2 of n)
      if (m3 = Cn(e2, T2, v, t2, i2), m3)
        break;
    return m3;
  }
  return typeof n == "function" ? n(e2) : null;
};
var A = (e2) => e2 ? new Date(e2) : /* @__PURE__ */ new Date();
var Ma = (e2, n, a3) => {
  if (n) {
    const i2 = (e2.getMonth() + 1).toString().padStart(2, "0"), v = e2.getDate().toString().padStart(2, "0"), m3 = e2.getHours().toString().padStart(2, "0"), T2 = e2.getMinutes().toString().padStart(2, "0"), Y2 = a3 ? e2.getSeconds().toString().padStart(2, "0") : "00";
    return `${e2.getFullYear()}-${i2}-${v}T${m3}:${T2}:${Y2}.000Z`;
  }
  const t2 = Date.UTC(
    e2.getUTCFullYear(),
    e2.getUTCMonth(),
    e2.getUTCDate(),
    e2.getUTCHours(),
    e2.getUTCMinutes(),
    e2.getUTCSeconds()
  );
  return new Date(t2).toISOString();
};
var je = (e2) => {
  let n = A(JSON.parse(JSON.stringify(e2)));
  return n = setHours(n, 0), n = setMinutes(n, 0), n = setSeconds(n, 0), n = setMilliseconds(n, 0), n;
};
var Ke = (e2, n, a3, t2) => {
  let i2 = e2 ? A(e2) : A();
  return (n || n === 0) && (i2 = setHours(i2, +n)), (a3 || a3 === 0) && (i2 = setMinutes(i2, +a3)), (t2 || t2 === 0) && (i2 = setSeconds(i2, +t2)), setMilliseconds(i2, 0);
};
var Ve = (e2, n) => !e2 || !n ? false : isBefore(je(e2), je(n));
var ke = (e2, n) => !e2 || !n ? false : isEqual(je(e2), je(n));
var Fe = (e2, n) => !e2 || !n ? false : isAfter(je(e2), je(n));
var ea = (e2, n, a3) => e2 && e2[0] && e2[1] ? Fe(a3, e2[0]) && Ve(a3, e2[1]) : e2 && e2[0] && n ? Fe(a3, e2[0]) && Ve(a3, n) || Ve(a3, e2[0]) && Fe(a3, n) : false;
var Pt = (e2) => {
  const n = set(new Date(e2), { date: 1 });
  return je(n);
};
var Qt = (e2, n, a3) => n && (a3 || a3 === 0) ? Object.fromEntries(
  ["hours", "minutes", "seconds"].map((t2) => t2 === n ? [t2, a3] : [t2, isNaN(+e2[t2]) ? void 0 : +e2[t2]])
) : {
  hours: isNaN(+e2.hours) ? void 0 : +e2.hours,
  minutes: isNaN(+e2.minutes) ? void 0 : +e2.minutes,
  seconds: isNaN(+e2.seconds) ? void 0 : +e2.seconds
};
var Lt = (e2) => ({
  hours: getHours(e2),
  minutes: getMinutes(e2),
  seconds: getSeconds(e2)
});
var _t = reactive({
  menuFocused: false,
  shiftKeyInMenu: false
});
var ta = () => {
  const e2 = (t2) => {
    _t.menuFocused = t2;
  }, n = (t2) => {
    _t.shiftKeyInMenu !== t2 && (_t.shiftKeyInMenu = t2);
  };
  return {
    control: computed(() => ({ shiftKeyInMenu: _t.shiftKeyInMenu, menuFocused: _t.menuFocused })),
    setMenuFocused: e2,
    setShiftKey: n
  };
};
function bn(e2) {
  return e2 && e2.__esModule && Object.prototype.hasOwnProperty.call(e2, "default") ? e2.default : e2;
}
var na = { exports: {} };
(function(e2) {
  function n(a3) {
    return a3 && a3.__esModule ? a3 : {
      default: a3
    };
  }
  e2.exports = n, e2.exports.__esModule = true, e2.exports.default = e2.exports;
})(na);
var Aa = na.exports;
var fn = { exports: {} };
(function(e2, n) {
  Object.defineProperty(n, "__esModule", {
    value: true
  }), n.default = a3;
  function a3(t2) {
    if (t2 === null || t2 === true || t2 === false)
      return NaN;
    var i2 = Number(t2);
    return isNaN(i2) ? i2 : i2 < 0 ? Math.ceil(i2) : Math.floor(i2);
  }
  e2.exports = n.default;
})(fn, fn.exports);
var Ta = fn.exports;
var Sa = bn(Ta);
var vn = { exports: {} };
(function(e2, n) {
  Object.defineProperty(n, "__esModule", {
    value: true
  }), n.default = a3;
  function a3(t2) {
    var i2 = new Date(Date.UTC(t2.getFullYear(), t2.getMonth(), t2.getDate(), t2.getHours(), t2.getMinutes(), t2.getSeconds(), t2.getMilliseconds()));
    return i2.setUTCFullYear(t2.getFullYear()), t2.getTime() - i2.getTime();
  }
  e2.exports = n.default;
})(vn, vn.exports);
var Pa = vn.exports;
var Nn = bn(Pa);
function _a(e2, n) {
  var a3 = Ia(n);
  return a3.formatToParts ? Na(a3, e2) : Ra(a3, e2);
}
var Ca = {
  year: 0,
  month: 1,
  day: 2,
  hour: 3,
  minute: 4,
  second: 5
};
function Na(e2, n) {
  try {
    for (var a3 = e2.formatToParts(n), t2 = [], i2 = 0; i2 < a3.length; i2++) {
      var v = Ca[a3[i2].type];
      v >= 0 && (t2[v] = parseInt(a3[i2].value, 10));
    }
    return t2;
  } catch (m3) {
    if (m3 instanceof RangeError)
      return [NaN];
    throw m3;
  }
}
function Ra(e2, n) {
  var a3 = e2.format(n).replace(/\u200E/g, ""), t2 = /(\d+)\/(\d+)\/(\d+),? (\d+):(\d+):(\d+)/.exec(a3);
  return [t2[3], t2[1], t2[2], t2[4], t2[5], t2[6]];
}
var en = {};
function Ia(e2) {
  if (!en[e2]) {
    var n = new Intl.DateTimeFormat("en-US", {
      hour12: false,
      timeZone: "America/New_York",
      year: "numeric",
      month: "numeric",
      day: "2-digit",
      hour: "2-digit",
      minute: "2-digit",
      second: "2-digit"
    }).format(/* @__PURE__ */ new Date("2014-06-25T04:00:00.123Z")), a3 = n === "06/25/2014, 00:00:00" || n === "‎06‎/‎25‎/‎2014‎ ‎00‎:‎00‎:‎00";
    en[e2] = a3 ? new Intl.DateTimeFormat("en-US", {
      hour12: false,
      timeZone: e2,
      year: "numeric",
      month: "numeric",
      day: "2-digit",
      hour: "2-digit",
      minute: "2-digit",
      second: "2-digit"
    }) : new Intl.DateTimeFormat("en-US", {
      hourCycle: "h23",
      timeZone: e2,
      year: "numeric",
      month: "numeric",
      day: "2-digit",
      hour: "2-digit",
      minute: "2-digit",
      second: "2-digit"
    });
  }
  return en[e2];
}
function Dn(e2, n, a3, t2, i2, v, m3) {
  var T2 = /* @__PURE__ */ new Date(0);
  return T2.setUTCFullYear(e2, n, a3), T2.setUTCHours(t2, i2, v, m3), T2;
}
var Rn = 36e5;
var Oa = 6e4;
var tn = {
  timezone: /([Z+-].*)$/,
  timezoneZ: /^(Z)$/,
  timezoneHH: /^([+-]\d{2})$/,
  timezoneHHMM: /^([+-]\d{2}):?(\d{2})$/
};
function $n(e2, n, a3) {
  var t2, i2;
  if (!e2 || (t2 = tn.timezoneZ.exec(e2), t2))
    return 0;
  var v;
  if (t2 = tn.timezoneHH.exec(e2), t2)
    return v = parseInt(t2[1], 10), In(v) ? -(v * Rn) : NaN;
  if (t2 = tn.timezoneHHMM.exec(e2), t2) {
    v = parseInt(t2[1], 10);
    var m3 = parseInt(t2[2], 10);
    return In(v, m3) ? (i2 = Math.abs(v) * Rn + m3 * Oa, v > 0 ? -i2 : i2) : NaN;
  }
  if (Va(e2)) {
    n = new Date(n || Date.now());
    var T2 = a3 ? n : Ba(n), Y2 = mn(T2, e2), _ = a3 ? Y2 : Ya(n, Y2, e2);
    return -_;
  }
  return NaN;
}
function Ba(e2) {
  return Dn(
    e2.getFullYear(),
    e2.getMonth(),
    e2.getDate(),
    e2.getHours(),
    e2.getMinutes(),
    e2.getSeconds(),
    e2.getMilliseconds()
  );
}
function mn(e2, n) {
  var a3 = _a(e2, n), t2 = Dn(
    a3[0],
    a3[1] - 1,
    a3[2],
    a3[3] % 24,
    a3[4],
    a3[5],
    0
  ).getTime(), i2 = e2.getTime(), v = i2 % 1e3;
  return i2 -= v >= 0 ? v : 1e3 + v, t2 - i2;
}
function Ya(e2, n, a3) {
  var t2 = e2.getTime(), i2 = t2 - n, v = mn(new Date(i2), a3);
  if (n === v)
    return n;
  i2 -= v - n;
  var m3 = mn(new Date(i2), a3);
  return v === m3 ? v : Math.max(v, m3);
}
function In(e2, n) {
  return -23 <= e2 && e2 <= 23 && (n == null || 0 <= n && n <= 59);
}
var On = {};
function Va(e2) {
  if (On[e2])
    return true;
  try {
    return new Intl.DateTimeFormat(void 0, { timeZone: e2 }), On[e2] = true, true;
  } catch {
    return false;
  }
}
var Ea = /(Z|[+-]\d{2}(?::?\d{2})?| UTC| [a-zA-Z]+\/[a-zA-Z_]+(?:\/[a-zA-Z_]+)?)$/;
var aa = Ea;
var nn = 36e5;
var Bn = 6e4;
var La = 2;
var Le = {
  dateTimePattern: /^([0-9W+-]+)(T| )(.*)/,
  datePattern: /^([0-9W+-]+)(.*)/,
  plainTime: /:/,
  // year tokens
  YY: /^(\d{2})$/,
  YYY: [
    /^([+-]\d{2})$/,
    // 0 additional digits
    /^([+-]\d{3})$/,
    // 1 additional digit
    /^([+-]\d{4})$/
    // 2 additional digits
  ],
  YYYY: /^(\d{4})/,
  YYYYY: [
    /^([+-]\d{4})/,
    // 0 additional digits
    /^([+-]\d{5})/,
    // 1 additional digit
    /^([+-]\d{6})/
    // 2 additional digits
  ],
  // date tokens
  MM: /^-(\d{2})$/,
  DDD: /^-?(\d{3})$/,
  MMDD: /^-?(\d{2})-?(\d{2})$/,
  Www: /^-?W(\d{2})$/,
  WwwD: /^-?W(\d{2})-?(\d{1})$/,
  HH: /^(\d{2}([.,]\d*)?)$/,
  HHMM: /^(\d{2}):?(\d{2}([.,]\d*)?)$/,
  HHMMSS: /^(\d{2}):?(\d{2}):?(\d{2}([.,]\d*)?)$/,
  // time zone tokens (to identify the presence of a tz)
  timeZone: aa
};
function yn(e2, n) {
  if (arguments.length < 1)
    throw new TypeError("1 argument required, but only " + arguments.length + " present");
  if (e2 === null)
    return /* @__PURE__ */ new Date(NaN);
  var a3 = n || {}, t2 = a3.additionalDigits == null ? La : Sa(a3.additionalDigits);
  if (t2 !== 2 && t2 !== 1 && t2 !== 0)
    throw new RangeError("additionalDigits must be 0, 1 or 2");
  if (e2 instanceof Date || typeof e2 == "object" && Object.prototype.toString.call(e2) === "[object Date]")
    return new Date(e2.getTime());
  if (typeof e2 == "number" || Object.prototype.toString.call(e2) === "[object Number]")
    return new Date(e2);
  if (!(typeof e2 == "string" || Object.prototype.toString.call(e2) === "[object String]"))
    return /* @__PURE__ */ new Date(NaN);
  var i2 = Fa(e2), v = Ua(i2.date, t2), m3 = v.year, T2 = v.restDateString, Y2 = Wa(T2, m3);
  if (isNaN(Y2))
    return /* @__PURE__ */ new Date(NaN);
  if (Y2) {
    var _ = Y2.getTime(), W = 0, C;
    if (i2.time && (W = Ha(i2.time), isNaN(W)))
      return /* @__PURE__ */ new Date(NaN);
    if (i2.timeZone || a3.timeZone) {
      if (C = $n(i2.timeZone || a3.timeZone, new Date(_ + W)), isNaN(C))
        return /* @__PURE__ */ new Date(NaN);
    } else
      C = Nn(new Date(_ + W)), C = Nn(new Date(_ + W + C));
    return new Date(_ + W + C);
  } else
    return /* @__PURE__ */ new Date(NaN);
}
function Fa(e2) {
  var n = {}, a3 = Le.dateTimePattern.exec(e2), t2;
  if (a3 ? (n.date = a3[1], t2 = a3[3]) : (a3 = Le.datePattern.exec(e2), a3 ? (n.date = a3[1], t2 = a3[2]) : (n.date = null, t2 = e2)), t2) {
    var i2 = Le.timeZone.exec(t2);
    i2 ? (n.time = t2.replace(i2[1], ""), n.timeZone = i2[1].trim()) : n.time = t2;
  }
  return n;
}
function Ua(e2, n) {
  var a3 = Le.YYY[n], t2 = Le.YYYYY[n], i2;
  if (i2 = Le.YYYY.exec(e2) || t2.exec(e2), i2) {
    var v = i2[1];
    return {
      year: parseInt(v, 10),
      restDateString: e2.slice(v.length)
    };
  }
  if (i2 = Le.YY.exec(e2) || a3.exec(e2), i2) {
    var m3 = i2[1];
    return {
      year: parseInt(m3, 10) * 100,
      restDateString: e2.slice(m3.length)
    };
  }
  return {
    year: null
  };
}
function Wa(e2, n) {
  if (n === null)
    return null;
  var a3, t2, i2, v;
  if (e2.length === 0)
    return t2 = /* @__PURE__ */ new Date(0), t2.setUTCFullYear(n), t2;
  if (a3 = Le.MM.exec(e2), a3)
    return t2 = /* @__PURE__ */ new Date(0), i2 = parseInt(a3[1], 10) - 1, Vn(n, i2) ? (t2.setUTCFullYear(n, i2), t2) : /* @__PURE__ */ new Date(NaN);
  if (a3 = Le.DDD.exec(e2), a3) {
    t2 = /* @__PURE__ */ new Date(0);
    var m3 = parseInt(a3[1], 10);
    return Ka(n, m3) ? (t2.setUTCFullYear(n, 0, m3), t2) : /* @__PURE__ */ new Date(NaN);
  }
  if (a3 = Le.MMDD.exec(e2), a3) {
    t2 = /* @__PURE__ */ new Date(0), i2 = parseInt(a3[1], 10) - 1;
    var T2 = parseInt(a3[2], 10);
    return Vn(n, i2, T2) ? (t2.setUTCFullYear(n, i2, T2), t2) : /* @__PURE__ */ new Date(NaN);
  }
  if (a3 = Le.Www.exec(e2), a3)
    return v = parseInt(a3[1], 10) - 1, En(n, v) ? Yn(n, v) : /* @__PURE__ */ new Date(NaN);
  if (a3 = Le.WwwD.exec(e2), a3) {
    v = parseInt(a3[1], 10) - 1;
    var Y2 = parseInt(a3[2], 10) - 1;
    return En(n, v, Y2) ? Yn(n, v, Y2) : /* @__PURE__ */ new Date(NaN);
  }
  return null;
}
function Ha(e2) {
  var n, a3, t2;
  if (n = Le.HH.exec(e2), n)
    return a3 = parseFloat(n[1].replace(",", ".")), an(a3) ? a3 % 24 * nn : NaN;
  if (n = Le.HHMM.exec(e2), n)
    return a3 = parseInt(n[1], 10), t2 = parseFloat(n[2].replace(",", ".")), an(a3, t2) ? a3 % 24 * nn + t2 * Bn : NaN;
  if (n = Le.HHMMSS.exec(e2), n) {
    a3 = parseInt(n[1], 10), t2 = parseInt(n[2], 10);
    var i2 = parseFloat(n[3].replace(",", "."));
    return an(a3, t2, i2) ? a3 % 24 * nn + t2 * Bn + i2 * 1e3 : NaN;
  }
  return null;
}
function Yn(e2, n, a3) {
  n = n || 0, a3 = a3 || 0;
  var t2 = /* @__PURE__ */ new Date(0);
  t2.setUTCFullYear(e2, 0, 4);
  var i2 = t2.getUTCDay() || 7, v = n * 7 + a3 + 1 - i2;
  return t2.setUTCDate(t2.getUTCDate() + v), t2;
}
var xa = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
var za = [31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
function la(e2) {
  return e2 % 400 === 0 || e2 % 4 === 0 && e2 % 100 !== 0;
}
function Vn(e2, n, a3) {
  if (n < 0 || n > 11)
    return false;
  if (a3 != null) {
    if (a3 < 1)
      return false;
    var t2 = la(e2);
    if (t2 && a3 > za[n] || !t2 && a3 > xa[n])
      return false;
  }
  return true;
}
function Ka(e2, n) {
  if (n < 1)
    return false;
  var a3 = la(e2);
  return !(a3 && n > 366 || !a3 && n > 365);
}
function En(e2, n, a3) {
  return !(n < 0 || n > 52 || a3 != null && (a3 < 0 || a3 > 6));
}
function an(e2, n, a3) {
  return !(e2 != null && (e2 < 0 || e2 >= 25) || n != null && (n < 0 || n >= 60) || a3 != null && (a3 < 0 || a3 >= 60));
}
var gn = { exports: {} };
var hn = { exports: {} };
(function(e2, n) {
  Object.defineProperty(n, "__esModule", {
    value: true
  }), n.default = a3;
  function a3(t2, i2) {
    if (t2 == null)
      throw new TypeError("assign requires that input parameter not be null or undefined");
    for (var v in i2)
      Object.prototype.hasOwnProperty.call(i2, v) && (t2[v] = i2[v]);
    return t2;
  }
  e2.exports = n.default;
})(hn, hn.exports);
var ja = hn.exports;
(function(e2, n) {
  var a3 = Aa.default;
  Object.defineProperty(n, "__esModule", {
    value: true
  }), n.default = i2;
  var t2 = a3(ja);
  function i2(v) {
    return (0, t2.default)({}, v);
  }
  e2.exports = n.default;
})(gn, gn.exports);
var Ga = gn.exports;
var Za = bn(Ga);
function qa(e2, n, a3) {
  var t2 = yn(e2, a3), i2 = $n(n, t2, true), v = new Date(t2.getTime() - i2), m3 = /* @__PURE__ */ new Date(0);
  return m3.setFullYear(v.getUTCFullYear(), v.getUTCMonth(), v.getUTCDate()), m3.setHours(v.getUTCHours(), v.getUTCMinutes(), v.getUTCSeconds(), v.getUTCMilliseconds()), m3;
}
function Xa(e2, n, a3) {
  if (typeof e2 == "string" && !e2.match(aa)) {
    var t2 = Za(a3);
    return t2.timeZone = n, yn(e2, t2);
  }
  var i2 = yn(e2, a3), v = Dn(
    i2.getFullYear(),
    i2.getMonth(),
    i2.getDate(),
    i2.getHours(),
    i2.getMinutes(),
    i2.getSeconds(),
    i2.getMilliseconds()
  ).getTime(), m3 = $n(n, new Date(v));
  return new Date(v + m3);
}
var Ja = (e2, n = 3) => {
  const a3 = [];
  for (let t2 = 0; t2 < e2.length; t2 += n)
    a3.push([e2[t2], e2[t2 + 1], e2[t2 + 2]]);
  return a3;
};
function Ln(e2) {
  return (n) => new Intl.DateTimeFormat(e2, { weekday: "short", timeZone: "UTC" }).format(/* @__PURE__ */ new Date(`2017-01-0${n}T00:00:00+00:00`)).slice(0, 2);
}
function Qa(e2) {
  return (n) => format(/* @__PURE__ */ new Date(`2017-01-0${n}T00:00:00+00:00`), "EEEEEE", { locale: e2 });
}
var el = (e2, n, a3) => {
  const t2 = [1, 2, 3, 4, 5, 6, 7];
  let i2;
  if (e2 !== null)
    try {
      i2 = t2.map(Qa(e2));
    } catch {
      i2 = t2.map(Ln(n));
    }
  else
    i2 = t2.map(Ln(n));
  const v = i2.slice(0, a3), m3 = i2.slice(a3 + 1, i2.length);
  return [i2[a3]].concat(...m3).concat(...v);
};
var tl = (e2, n) => {
  const a3 = [];
  for (let t2 = +e2[0]; t2 <= +e2[1]; t2++)
    a3.push({ value: +t2, text: `${t2}` });
  return n ? a3.reverse() : a3;
};
var nl = (e2, n, a3) => {
  const t2 = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12].map((v) => {
    const m3 = v < 10 ? `0${v}` : v;
    return /* @__PURE__ */ new Date(`2017-${m3}-01T00:00:00+00:00`);
  });
  if (e2 !== null)
    try {
      const v = a3 === "long" ? "MMMM" : "MMM";
      return t2.map((m3, T2) => {
        const Y2 = format(m3, v, { locale: e2 });
        return {
          text: Y2.charAt(0).toUpperCase() + Y2.substring(1),
          value: T2
        };
      });
    } catch {
    }
  const i2 = new Intl.DateTimeFormat(n, { month: a3, timeZone: "UTC" });
  return t2.map((v, m3) => {
    const T2 = i2.format(v);
    return {
      text: T2.charAt(0).toUpperCase() + T2.substring(1),
      value: m3
    };
  });
};
var al = (e2) => [12, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11][e2];
var Ae = (e2) => {
  const n = unref(e2);
  return n != null && n.$el ? n == null ? void 0 : n.$el : n;
};
var ll = (e2) => Object.assign({ type: "dot" }, e2);
var ra = (e2) => Array.isArray(e2) ? !!e2[0] && !!e2[1] : false;
var zt = {
  prop: (e2) => `"${e2}" prop must be enabled!`,
  dateArr: (e2) => `You need to use array as "model-value" binding in order to support "${e2}"`
};
var _e = (e2) => e2;
var Fn = (e2) => e2 === 0 ? e2 : !e2 || isNaN(+e2) ? null : +e2;
var rl = (e2) => e2 === 0 ? true : !!e2;
var Un = (e2) => e2 === null;
var ol = (e2) => {
  if (e2)
    return [...e2.querySelectorAll("input, button, select, textarea, a[href]")][0];
};
var Wn = (e2) => Object.assign(
  {
    menuAppear: "",
    open: "dp-slide-down",
    close: "dp-slide-up",
    next: "calendar-next",
    previous: "calendar-prev",
    vNext: "dp-slide-up",
    vPrevious: "dp-slide-down"
  },
  e2
);
var sl = (e2) => Object.assign(
  {
    toggleOverlay: "Toggle overlay",
    menu: "Datepicker menu",
    input: "Datepicker input",
    calendarWrap: "Calendar wrapper",
    calendarDays: "Calendar days",
    openTimePicker: "Open time picker",
    closeTimePicker: "Close time Picker",
    incrementValue: (n) => `Increment ${n}`,
    decrementValue: (n) => `Decrement ${n}`,
    openTpOverlay: (n) => `Open ${n} overlay`,
    amPmButton: "Switch AM/PM mode",
    openYearsOverlay: "Open years overlay",
    openMonthsOverlay: "Open months overlay",
    nextMonth: "Next month",
    prevMonth: "Previous month",
    day: () => ""
  },
  e2
);
var il = (e2) => e2 === null ? 0 : typeof e2 == "boolean" ? e2 ? 2 : 0 : +e2 >= 2 ? +e2 : 2;
var ul = (e2, n, a3) => e2 || (typeof a3 == "string" ? a3 : n);
var dl = (e2) => typeof e2 == "boolean" ? e2 ? Wn({}) : false : Wn(e2);
var cl = () => ({
  enterSubmit: true,
  tabSubmit: true,
  openMenu: true,
  rangeSeparator: " - "
});
var fl = (e2) => Object.assign({ months: [], years: [], times: { hours: [], minutes: [], seconds: [] } }, e2);
var vl = (e2) => Object.assign({ showSelect: true, showCancel: true, showNow: false, showPreview: true }, e2);
var xe = (e2) => {
  const n = () => {
    if (e2.partialRange)
      return null;
    throw new Error(zt.prop("partial-range"));
  }, a3 = computed(() => ({
    ariaLabels: sl(e2.ariaLabels),
    textInputOptions: Object.assign(cl(), e2.textInputOptions),
    multiCalendars: il(e2.multiCalendars),
    previewFormat: ul(e2.previewFormat, e2.format, v()),
    filters: fl(e2.filters),
    transitions: dl(e2.transitions),
    startTime: g(),
    actionRow: vl(e2.actionRow)
  })), t2 = (r) => {
    if (e2.range)
      return r();
    throw new Error(zt.prop("range"));
  }, i2 = () => {
    const r = e2.enableSeconds ? ":ss" : "";
    return e2.is24 ? `HH:mm${r}` : `hh:mm${r} aa`;
  }, v = () => e2.format ? e2.format : e2.monthPicker ? "MM/yyyy" : e2.timePicker ? i2() : e2.weekPicker ? "MM/dd/yyyy" : e2.yearPicker ? "yyyy" : e2.enableTimePicker ? `MM/dd/yyyy, ${i2()}` : "MM/dd/yyyy", m3 = (r, o) => {
    if (typeof e2.format == "function")
      return e2.format(r);
    const l = o || v(), M3 = e2.formatLocale ? { locale: e2.formatLocale } : void 0;
    return Array.isArray(r) ? `${format(r[0], l, M3)}${e2.modelAuto && !r[1] ? "" : a3.value.textInputOptions.rangeSeparator || "-"}${r[1] ? format(r[1], l, M3) : ""}` : format(r, l, M3);
  }, T2 = (r) => e2.timezone ? qa(r, e2.timezone) : r, Y2 = (r) => e2.timezone ? Xa(r, e2.timezone) : r, _ = computed(() => (r) => {
    var o;
    return (o = e2.hideNavigation) == null ? void 0 : o.includes(r);
  }), W = (r) => {
    var o, l, M3, re;
    return Array.isArray(e2.allowedDates) && !((o = e2.allowedDates) != null && o.length) ? true : (l = e2.arrMapValues) != null && l.allowedDates ? !F(r, e2.arrMapValues.allowedDates) : (M3 = e2.allowedDates) != null && M3.length ? !((re = e2.allowedDates) != null && re.some(
      (se) => ke(T2(A(se)), T2(r))
    )) : false;
  }, C = (r) => {
    var Ie;
    const o = e2.maxDate ? Fe(T2(r), T2(A(e2.maxDate))) : false, l = e2.minDate ? Ve(T2(r), T2(A(e2.minDate))) : false, M3 = F(
      r,
      (Ie = e2.arrMapValues) != null && Ie.disabledDates ? e2.arrMapValues.disabledDates : e2.disabledDates
    ), se = a3.value.filters.months.map((Te) => +Te).includes(getMonth(r)), Pe = e2.disabledWeekDays.length ? e2.disabledWeekDays.some((Te) => +Te === getDay(r)) : false, Se = W(r), ee = getYear(r), Ue = ee < +e2.yearRange[0] || ee > +e2.yearRange[1];
    return !(o || l || M3 || se || Ue || Pe || Se);
  }, c2 = (r) => {
    const o = {
      hours: getHours(A()),
      minutes: getMinutes(A()),
      seconds: e2.enableSeconds ? getSeconds(A()) : 0
    };
    return Object.assign(o, r);
  }, g = () => e2.range ? e2.startTime && Array.isArray(e2.startTime) ? [c2(e2.startTime[0]), c2(e2.startTime[1])] : null : e2.startTime && !Array.isArray(e2.startTime) ? c2(e2.startTime) : null, Q2 = (r) => !C(r), U = (r) => Array.isArray(r) ? isValid(r[0]) && (r[1] ? isValid(r[1]) : true) : r ? isValid(r) : false, x2 = (r) => r instanceof Date ? r : parseISO(r), V = (r) => {
    const o = startOfWeek(T2(r), { weekStartsOn: +e2.weekStart }), l = endOfWeek(T2(r), { weekStartsOn: +e2.weekStart });
    return [o, l];
  }, F = (r, o) => r ? o instanceof Map ? !!o.get(u2(r)) : Array.isArray(o) ? o.some((l) => ke(T2(A(l)), T2(r))) : o(A(JSON.parse(JSON.stringify(r)))) : true, ae = (r, o, l) => {
    let M3 = r ? A(r) : A();
    return (o || o === 0) && (M3 = setMonth(M3, o)), l && (M3 = setYear(M3, l)), M3;
  }, oe = (r) => set(A(), Lt(r)), B2 = (r) => set(A(), {
    hours: +r.hours || 0,
    minutes: +r.minutes || 0,
    seconds: +r.seconds || 0
  }), G2 = (r, o, l, M3) => {
    if (!r)
      return true;
    if (M3) {
      const re = l === "max" ? isBefore(r, o) : isAfter(r, o), se = { seconds: 0, milliseconds: 0 };
      return re || isEqual(set(r, se), set(o, se));
    }
    return l === "max" ? r.getTime() <= o.getTime() : r.getTime() >= o.getTime();
  }, J = () => !e2.enableTimePicker || e2.monthPicker || e2.yearPicker || e2.ignoreTimeValidation, ne = (r) => Array.isArray(r) ? [r[0] ? oe(r[0]) : null, r[1] ? oe(r[1]) : null] : oe(r), ce = (r) => {
    const o = e2.maxTime ? B2(e2.maxTime) : A(e2.maxDate);
    return Array.isArray(r) ? G2(r[0], o, "max", !!e2.maxDate) && G2(r[1], o, "max", !!e2.maxDate) : G2(r, o, "max", !!e2.maxDate);
  }, ye = (r, o) => {
    const l = e2.minTime ? B2(e2.minTime) : A(e2.minDate);
    return Array.isArray(r) ? G2(r[0], l, "min", !!e2.minDate) && G2(r[1], l, "min", !!e2.minDate) && o : G2(r, l, "min", !!e2.minDate) && o;
  }, O2 = (r) => {
    let o = true;
    if (!r || J())
      return true;
    const l = !e2.minDate && !e2.maxDate ? ne(r) : r;
    if ((e2.maxTime || e2.maxDate) && (o = ce(_e(l))), (e2.minTime || e2.minDate) && (o = ye(_e(l), o)), e2.disabledTimes) {
      const M3 = Array.isArray(r) ? [Lt(r[0]), r[1] ? Lt(r[1]) : void 0] : Lt(r);
      o = !e2.disabledTimes(M3);
    }
    return o;
  }, w2 = (r, o) => {
    const l = A(JSON.parse(JSON.stringify(r))), M3 = [];
    for (let re = 0; re < 7; re++) {
      const se = addDays(l, re), Pe = getMonth(se) !== o;
      M3.push({
        text: e2.hideOffsetDates && Pe ? "" : se.getDate(),
        value: se,
        current: !Pe,
        classData: {}
      });
    }
    return M3;
  }, f = (r, o) => {
    switch (e2.sixWeeks === true ? "append" : e2.sixWeeks) {
      case "prepend":
        return [true, false];
      case "center":
        return [r == 0, true];
      case "fair":
        return [r == 0 || o > r, true];
      case "append":
        return [false, false];
      default:
        return [false, false];
    }
  }, N = (r, o) => {
    const l = [], M3 = A(T2(new Date(o, r))), re = A(T2(new Date(o, r + 1, 0))), se = e2.weekStart, Pe = startOfWeek(M3, { weekStartsOn: se }), Se = (ee) => {
      const Ue = w2(ee, r);
      if (l.push({ days: Ue }), !l[l.length - 1].days.some(
        (Ie) => ke(je(Ie.value), je(re))
      )) {
        const Ie = addDays(ee, 7);
        Se(Ie);
      }
    };
    if (Se(Pe), e2.sixWeeks && l.length < 6) {
      const ee = 6 - l.length, Ue = (M3.getDay() + 7 - se) % 7, Te = 6 - (re.getDay() + 7 - se) % 7, [Xe, ct] = f(Ue, Te);
      for (let et = 1; et <= ee; et++)
        if (ct ? !!(et % 2) == Xe : Xe) {
          const ze = l[0].days[0], j = w2(addDays(ze.value, -7), getMonth(M3));
          l.unshift({ days: j });
        } else {
          const ze = l[l.length - 1], j = ze.days[ze.days.length - 1], te = w2(addDays(j.value, 1), getMonth(M3));
          l.push({ days: te });
        }
    }
    return l;
  }, I2 = (r, o, l) => [set(A(r), { date: 1 }), set(A(), { month: o, year: l, date: 1 })], E2 = (r, o) => Ve(...I2(e2.minDate, r, o)) || ke(...I2(e2.minDate, r, o)), D2 = (r, o) => Fe(...I2(e2.maxDate, r, o)) || ke(...I2(e2.maxDate, r, o)), y3 = (r, o, l) => {
    let M3 = false;
    return e2.maxDate && l && D2(r, o) && (M3 = true), e2.minDate && !l && E2(r, o) && (M3 = true), M3;
  }, d3 = (r, o, l, M3) => {
    let re = false;
    return M3 ? e2.minDate && e2.maxDate ? re = y3(r, o, l) : (e2.minDate && E2(r, o) || e2.maxDate && D2(r, o)) && (re = true) : re = true, re;
  }, u2 = (r) => {
    const o = je(T2(A(r))).toISOString(), [l] = o.split("T");
    return l;
  }, S3 = (r) => new Map(r.map((o) => [u2(o), true])), b2 = (r) => Array.isArray(r) && r.length > 0;
  return {
    checkPartialRangeValue: n,
    checkRangeEnabled: t2,
    getZonedDate: T2,
    getZonedToUtc: Y2,
    formatDate: m3,
    getDefaultPattern: v,
    validateDate: C,
    getDefaultStartTime: g,
    isDisabled: Q2,
    isValidDate: U,
    sanitizeDate: x2,
    getWeekFromDate: V,
    matchDate: F,
    setDateMonthOrYear: ae,
    isValidTime: O2,
    getCalendarDays: N,
    validateMonthYearInRange: d3,
    validateMaxDate: D2,
    validateMinDate: E2,
    assignDefaultTime: c2,
    mapDatesArrToMap: (r) => {
      b2(e2.allowedDates) && (r.allowedDates = S3(e2.allowedDates)), b2(e2.highlight) && (r.highlightedDates = S3(e2.highlight)), b2(e2.disabledDates) && (r.disabledDates = S3(e2.disabledDates));
    },
    defaults: a3,
    hideNavigationButtons: _
  };
};
var be = reactive({
  monthYear: [],
  calendar: [],
  time: [],
  actionRow: [],
  selectionGrid: [],
  timePicker: {
    0: [],
    1: []
  },
  monthPicker: []
});
var ln = ref(null);
var Ft = ref(false);
var rn = ref(false);
var on = ref(false);
var sn = ref(false);
var Ee = ref(0);
var Oe = ref(0);
var ut = () => {
  const e2 = computed(() => Ft.value ? [...be.selectionGrid, be.actionRow].filter((V) => V.length) : rn.value ? [
    ...be.timePicker[0],
    ...be.timePicker[1],
    sn.value ? [] : [ln.value],
    be.actionRow
  ].filter((V) => V.length) : on.value ? [...be.monthPicker, be.actionRow] : [be.monthYear, ...be.calendar, be.time, be.actionRow].filter((V) => V.length)), n = (V) => {
    Ee.value = V ? Ee.value + 1 : Ee.value - 1;
    let F = null;
    e2.value[Oe.value] && (F = e2.value[Oe.value][Ee.value]), F || (Ee.value = V ? Ee.value - 1 : Ee.value + 1);
  }, a3 = (V) => {
    if (Oe.value === 0 && !V || Oe.value === e2.value.length && V)
      return;
    Oe.value = V ? Oe.value + 1 : Oe.value - 1, e2.value[Oe.value] ? e2.value[Oe.value] && !e2.value[Oe.value][Ee.value] && Ee.value !== 0 && (Ee.value = e2.value[Oe.value].length - 1) : Oe.value = V ? Oe.value - 1 : Oe.value + 1;
  }, t2 = (V) => {
    let F = null;
    e2.value[Oe.value] && (F = e2.value[Oe.value][Ee.value]), F ? F.focus({ preventScroll: !Ft.value }) : Ee.value = V ? Ee.value - 1 : Ee.value + 1;
  }, i2 = () => {
    n(true), t2(true);
  }, v = () => {
    n(false), t2(false);
  }, m3 = () => {
    a3(false), t2(true);
  }, T2 = () => {
    a3(true), t2(true);
  }, Y2 = (V, F) => {
    be[F] = V;
  }, _ = (V, F) => {
    be[F] = V;
  }, W = () => {
    Ee.value = 0, Oe.value = 0;
  };
  return {
    buildMatrix: Y2,
    buildMultiLevelMatrix: _,
    setTimePickerBackRef: (V) => {
      ln.value = V;
    },
    setSelectionGrid: (V) => {
      Ft.value = V, W(), V || (be.selectionGrid = []);
    },
    setTimePicker: (V, F = false) => {
      rn.value = V, sn.value = F, W(), V || (be.timePicker[0] = [], be.timePicker[1] = []);
    },
    setTimePickerElements: (V, F = 0) => {
      be.timePicker[F] = V;
    },
    arrowRight: i2,
    arrowLeft: v,
    arrowUp: m3,
    arrowDown: T2,
    clearArrowNav: () => {
      be.monthYear = [], be.calendar = [], be.time = [], be.actionRow = [], be.selectionGrid = [], be.timePicker[0] = [], be.timePicker[1] = [], Ft.value = false, rn.value = false, sn.value = false, on.value = false, W(), ln.value = null;
    },
    setMonthPicker: (V) => {
      on.value = V, W();
    },
    refSets: be
    // exposed for testing
  };
};
var Hn = (e2) => Array.isArray(e2);
var vt = (e2) => Array.isArray(e2);
var xn = (e2) => Array.isArray(e2) && e2.length === 2;
var ml = (e2, n, a3, t2, i2) => {
  const {
    getDefaultStartTime: v,
    isDisabled: m3,
    sanitizeDate: T2,
    getWeekFromDate: Y2,
    setDateMonthOrYear: _,
    validateMonthYearInRange: W,
    defaults: C
  } = xe(e2), c2 = computed({
    get: () => e2.internalModelValue,
    set: (s3) => {
      !e2.readonly && !e2.disabled && n("update:internal-model-value", s3);
    }
  }), g = ref([]);
  watch(c2, (s3, k2) => {
    e2.range ? J() : isEqual(s3, k2) || J();
  });
  const Q2 = toRef(e2, "multiCalendars");
  watch(Q2, () => {
    j(0);
  });
  const U = ref([{ month: getMonth(A()), year: getYear(A()) }]);
  watch(
    U,
    () => {
      U.value.forEach((s3, k2) => {
        n("update-month-year", { instance: k2, month: s3.month, year: s3.year });
      });
    },
    { deep: true }
  );
  const x2 = reactive({
    hours: e2.range ? [getHours(A()), getHours(A())] : getHours(A()),
    minutes: e2.range ? [getMinutes(A()), getMinutes(A())] : getMinutes(A()),
    seconds: e2.range ? [0, 0] : 0
  }), V = computed(
    () => (s3) => U.value[s3] ? U.value[s3].month : 0
  ), F = computed(
    () => (s3) => U.value[s3] ? U.value[s3].year : 0
  ), ae = computed(() => {
    var s3;
    return (s3 = e2.flow) != null && s3.length && !e2.partialFlow ? i2.value === e2.flow.length : true;
  }), oe = (s3, k2, X2) => {
    var ie, $e;
    U.value[s3] || (U.value[s3] = { month: 0, year: 0 }), U.value[s3].month = Un(k2) ? (ie = U.value[s3]) == null ? void 0 : ie.month : k2, U.value[s3].year = Un(X2) ? ($e = U.value[s3]) == null ? void 0 : $e.year : X2;
  }, B2 = (s3, k2) => {
    x2[s3] = k2;
  }, G2 = () => {
    e2.startDate && (oe(0, getMonth(A(e2.startDate)), getYear(A(e2.startDate))), C.value.multiCalendars && j(0));
  };
  onMounted(() => {
    c2.value || (G2(), C.value.startTime && D2()), J(true), e2.focusStartDate && e2.startDate && G2();
  });
  const J = (s3 = false) => {
    if (c2.value)
      return Array.isArray(c2.value) ? (g.value = c2.value, w2(s3)) : ce(c2.value, s3);
    if (e2.timePicker)
      return f();
    if (e2.monthPicker && !e2.range)
      return N();
    if (e2.yearPicker && !e2.range)
      return I2();
    if (C.value.multiCalendars && s3 && !e2.startDate)
      return ne(A(), s3);
  }, ne = (s3, k2 = false) => {
    if ((!C.value.multiCalendars || !e2.multiStatic || k2) && oe(0, getMonth(s3), getYear(s3)), C.value.multiCalendars)
      for (let X2 = 1; X2 < C.value.multiCalendars; X2++) {
        const ie = set(A(), { month: V.value(X2 - 1), year: F.value(X2 - 1) }), $e = add(ie, { months: 1 });
        U.value[X2] = { month: getMonth($e), year: getYear($e) };
      }
  }, ce = (s3, k2) => {
    ne(s3), B2("hours", getHours(s3)), B2("minutes", getMinutes(s3)), B2("seconds", getSeconds(s3)), C.value.multiCalendars && k2 && d3();
  }, ye = (s3, k2) => {
    s3[1] && e2.showLastInRange ? ne(s3[1], k2) : ne(s3[0], k2);
    const X2 = (ie, $e) => [
      ie(s3[0]),
      s3[1] ? ie(s3[1]) : x2[$e][1]
    ];
    B2("hours", X2(getHours, "hours")), B2("minutes", X2(getMinutes, "minutes")), B2("seconds", X2(getSeconds, "seconds"));
  }, O2 = (s3, k2) => {
    if ((e2.range || e2.weekPicker) && !e2.multiDates)
      return ye(s3, k2);
    if (e2.multiDates) {
      const X2 = s3[s3.length - 1];
      return ce(X2, k2);
    }
  }, w2 = (s3) => {
    const k2 = c2.value;
    O2(k2, s3), C.value.multiCalendars && e2.multiCalendarsSolo && d3();
  }, f = () => {
    if (D2(), !e2.range)
      c2.value = Ke(A(), x2.hours, x2.minutes, E2());
    else {
      const s3 = x2.hours, k2 = x2.minutes;
      c2.value = [
        Ke(A(), s3[0], k2[0], E2()),
        Ke(A(), s3[1], k2[1], E2(false))
      ];
    }
  }, N = () => {
    e2.multiDates ? c2.value = [_(A(), V.value(0), F.value(0))] : c2.value = _(A(), V.value(0), F.value(0));
  }, I2 = () => {
    c2.value = A();
  }, E2 = (s3 = true) => e2.enableSeconds ? Array.isArray(x2.seconds) ? s3 ? x2.seconds[0] : x2.seconds[1] : x2.seconds : 0, D2 = () => {
    const s3 = v();
    if (s3) {
      const k2 = Array.isArray(s3), X2 = k2 ? [+s3[0].hours, +s3[1].hours] : +s3.hours, ie = k2 ? [+s3[0].minutes, +s3[1].minutes] : +s3.minutes, $e = k2 ? [+s3[0].seconds, +s3[1].seconds] : +s3.seconds;
      B2("hours", X2), B2("minutes", ie), e2.enableSeconds && B2("seconds", $e);
    }
  }, y3 = () => Array.isArray(c2.value) && c2.value.length ? c2.value[c2.value.length - 1] : null, d3 = () => {
    if (Array.isArray(c2.value) && c2.value.length === 2) {
      const s3 = A(
        A(c2.value[1] ? c2.value[1] : addMonths(c2.value[0], 1))
      ), [k2, X2] = [getMonth(c2.value[0]), getYear(c2.value[0])], [ie, $e] = [getMonth(c2.value[1]), getYear(c2.value[1])];
      (k2 !== ie || k2 === ie && X2 !== $e) && e2.multiCalendarsSolo && oe(1, getMonth(s3), getYear(s3));
    } else
      c2.value && !Array.isArray(c2.value) && oe(0, getMonth(c2.value), getYear(c2.value));
  }, u2 = (s3) => {
    const k2 = addMonths(s3, 1);
    return { month: getMonth(k2), year: getYear(k2) };
  }, S3 = (s3) => {
    const k2 = getMonth(A(s3)), X2 = getYear(A(s3));
    if (oe(0, k2, X2), C.value.multiCalendars > 0)
      for (let ie = 1; ie < C.value.multiCalendars; ie++) {
        const $e = u2(
          set(A(s3), { year: V.value(ie - 1), month: F.value(ie - 1) })
        );
        oe(ie, $e.month, $e.year);
      }
  }, b2 = (s3) => {
    if (c2.value && Array.isArray(c2.value))
      if (c2.value.some((k2) => ke(s3, k2))) {
        const k2 = c2.value.filter((X2) => !ke(X2, s3));
        c2.value = k2.length ? k2 : null;
      } else
        (e2.multiDatesLimit && +e2.multiDatesLimit > c2.value.length || !e2.multiDatesLimit) && c2.value.push(s3);
    else
      c2.value = [s3];
  }, Z = (s3, k2) => {
    const X2 = Fe(s3, k2) ? k2 : s3, ie = Fe(k2, s3) ? k2 : s3;
    return eachDayOfInterval({ start: X2, end: ie });
  }, r = (s3, k2 = 0) => {
    if (Array.isArray(c2.value) && c2.value[k2]) {
      const X2 = differenceInCalendarDays(s3, c2.value[k2]), ie = Z(c2.value[k2], s3), $e = ie.length === 1 ? 0 : ie.filter((h3) => m3(h3)).length, tt = Math.abs(X2) - $e;
      if (e2.minRange && e2.maxRange)
        return tt >= +e2.minRange && tt <= +e2.maxRange;
      if (e2.minRange)
        return tt >= +e2.minRange;
      if (e2.maxRange)
        return tt <= +e2.maxRange;
    }
    return true;
  }, o = (s3) => Array.isArray(c2.value) && c2.value.length === 2 ? e2.fixedStart && (Fe(s3, c2.value[0]) || ke(s3, c2.value[0])) ? [c2.value[0], s3] : e2.fixedEnd && (Ve(s3, c2.value[1]) || ke(s3, c2.value[1])) ? [s3, c2.value[1]] : (n("invalid-fixed-range", s3), c2.value) : [], l = () => {
    e2.autoApply && ae.value && n("auto-apply", e2.partialFlow);
  }, M3 = () => {
    e2.autoApply && n("select-date");
  }, re = (s3) => !eachDayOfInterval({ start: s3[0], end: s3[1] }).some((X2) => m3(X2)), se = (s3) => (c2.value = Y2(A(s3.value)), l()), Pe = (s3) => {
    const k2 = Ke(A(s3.value), x2.hours, x2.minutes, E2());
    e2.multiDates ? b2(k2) : c2.value = k2, a3(), l();
  }, Se = () => {
    g.value = c2.value ? c2.value.slice() : [], g.value.length === 2 && !(e2.fixedStart || e2.fixedEnd) && (g.value = []);
  }, ee = (s3, k2) => {
    const X2 = [A(s3.value), addDays(A(s3.value), +e2.autoRange)];
    re(X2) && (k2 && S3(s3.value), g.value = X2);
  }, Ue = (s3) => {
    Ie(s3.value) || !r(s3.value, e2.fixedStart ? 0 : 1) || (g.value = o(A(s3.value)));
  }, Ie = (s3) => e2.noDisabledRange ? Z(g.value[0], s3).some((X2) => m3(X2)) : false, Te = (s3, k2) => {
    if (Se(), e2.autoRange)
      return ee(s3, k2);
    if (e2.fixedStart || e2.fixedEnd)
      return Ue(s3);
    g.value[0] ? r(A(s3.value)) && !Ie(s3.value) && (Ve(A(s3.value), A(g.value[0])) ? (g.value.unshift(A(s3.value)), n("range-end", g.value[0])) : (g.value[1] = A(s3.value), n("range-end", g.value[1]))) : (g.value[0] = A(s3.value), n("range-start", g.value[0]));
  }, Xe = (s3) => {
    g.value[s3] = Ke(
      g.value[s3],
      x2.hours[s3],
      x2.minutes[s3],
      E2(s3 !== 1)
    );
  }, ct = () => {
    var s3, k2;
    g.value[0] && g.value[1] && +((s3 = g.value) == null ? void 0 : s3[0]) > +((k2 = g.value) == null ? void 0 : k2[1]) && (g.value.reverse(), n("range-start", g.value[0]), n("range-end", g.value[1]));
  }, et = () => {
    g.value.length && (g.value[0] && !g.value[1] ? Xe(0) : (Xe(0), Xe(1), a3()), ct(), c2.value = g.value.slice(), g.value[0] && g.value[1] && e2.autoApply && n("auto-apply"), g.value[0] && !g.value[1] && e2.modelAuto && e2.autoApply && n("auto-apply"));
  }, wt = (s3, k2 = false) => {
    if (!(m3(s3.value) || !s3.current && e2.hideOffsetDates)) {
      if (e2.weekPicker)
        return se(s3);
      if (!e2.range)
        return Pe(s3);
      vt(x2.hours) && vt(x2.minutes) && !e2.multiDates && (Te(s3, k2), et());
    }
  }, ze = (s3) => {
    const k2 = s3[0];
    return e2.weekNumbers === "local" ? getWeek(k2.value, { weekStartsOn: +e2.weekStart }) : e2.weekNumbers === "iso" ? getISOWeek(k2.value) : typeof e2.weekNumbers == "function" ? e2.weekNumbers(k2.value) : "";
  }, j = (s3) => {
    for (let k2 = s3 - 1; k2 >= 0; k2--) {
      const X2 = subMonths(set(A(), { month: V.value(k2 + 1), year: F.value(k2 + 1) }), 1);
      oe(k2, getMonth(X2), getYear(X2));
    }
    for (let k2 = s3 + 1; k2 <= C.value.multiCalendars - 1; k2++) {
      const X2 = addMonths(set(A(), { month: V.value(k2 - 1), year: F.value(k2 - 1) }), 1);
      oe(k2, getMonth(X2), getYear(X2));
    }
  }, te = (s3) => _(A(), V.value(s3), F.value(s3)), ue = (s3) => Ke(s3, x2.hours, x2.minutes, E2()), Tt = (s3) => {
    b2(te(s3));
  }, ft = (s3, k2) => {
    const X2 = e2.monthPicker ? V.value(s3) !== k2.month || !k2.fromNav : F.value(s3) !== k2.year || !k2.fromNav;
    if (oe(s3, k2.month, k2.year), C.value.multiCalendars && !e2.multiCalendarsSolo && j(s3), e2.monthPicker || e2.yearPicker)
      if (e2.multiDates)
        X2 && Tt(s3);
      else if (e2.range) {
        if (X2 && r(te(s3))) {
          let ie = c2.value ? c2.value.slice() : [];
          ie.length === 2 && ie[1] !== null && (ie = []), ie.length ? Ve(te(s3), ie[0]) ? ie.unshift(te(s3)) : ie[1] = te(s3) : ie = [te(s3)], c2.value = ie;
        }
      } else
        (e2.autoApplyMonth || X2) && (c2.value = te(s3));
    t2(e2.multiCalendarsSolo ? s3 : void 0);
  }, Gt = async (s3 = false) => {
    if (e2.autoApply && (e2.monthPicker || e2.yearPicker)) {
      await nextTick();
      const k2 = e2.monthPicker ? s3 : false;
      e2.range ? n("auto-apply", k2 || !c2.value || c2.value.length === 1) : n("auto-apply", k2);
    }
    a3();
  }, Yt = (s3, k2) => {
    const X2 = set(A(), { month: V.value(k2), year: F.value(k2) }), ie = s3 < 0 ? addMonths(X2, 1) : subMonths(X2, 1);
    W(getMonth(ie), getYear(ie), s3 < 0, e2.preventMinMaxNavigation) && (oe(k2, getMonth(ie), getYear(ie)), C.value.multiCalendars && !e2.multiCalendarsSolo && j(k2), t2());
  }, St = (s3) => {
    Hn(s3) && Hn(c2.value) && vt(x2.hours) && vt(x2.minutes) ? (s3[0] && c2.value[0] && (c2.value[0] = Ke(s3[0], x2.hours[0], x2.minutes[0], E2())), s3[1] && c2.value[1] && (c2.value[1] = Ke(s3[1], x2.hours[1], x2.minutes[1], E2(false)))) : e2.multiDates && Array.isArray(c2.value) ? c2.value[c2.value.length - 1] = ue(s3) : !e2.range && !xn(s3) && (c2.value = ue(s3)), n("time-update");
  }, Zt = (s3, k2 = true, X2 = false) => {
    const ie = k2 ? s3 : x2.hours, $e = !k2 && !X2 ? s3 : x2.minutes, tt = X2 ? s3 : x2.seconds;
    if (e2.range && xn(c2.value) && vt(ie) && vt($e) && vt(tt) && !e2.disableTimeRangeValidation) {
      const h3 = (pe) => Ke(c2.value[pe], ie[pe], $e[pe], tt[pe]), z2 = (pe) => setMilliseconds(c2.value[pe], 0);
      if (ke(c2.value[0], c2.value[1]) && (isAfter(h3(0), z2(1)) || isBefore(h3(1), z2(0))))
        return;
    }
    if (B2("hours", ie), B2("minutes", $e), B2("seconds", tt), c2.value)
      if (e2.multiDates) {
        const h3 = y3();
        h3 && St(h3);
      } else
        St(c2.value);
    else
      e2.timePicker && St(e2.range ? [A(), A()] : A());
    a3();
  }, qt = (s3, k2) => {
    e2.monthChangeOnScroll && Yt(e2.monthChangeOnScroll !== "inverse" ? -s3.deltaY : s3.deltaY, k2);
  }, Xt = (s3, k2, X2 = false) => {
    e2.monthChangeOnArrows && e2.vertical === X2 && Vt(s3, k2);
  }, Vt = (s3, k2) => {
    Yt(s3 === "right" ? -1 : 1, k2);
  };
  return {
    time: x2,
    month: V,
    year: F,
    modelValue: c2,
    calendars: U,
    monthYearSelect: Gt,
    isDisabled: m3,
    updateTime: Zt,
    getWeekNum: ze,
    selectDate: wt,
    updateMonthYear: ft,
    handleScroll: qt,
    getMarker: (s3) => e2.markers.find((k2) => ke(T2(s3.value), T2(k2.date))),
    handleArrow: Xt,
    handleSwipe: Vt,
    selectCurrentDate: () => {
      e2.range ? c2.value && Array.isArray(c2.value) && c2.value[0] ? c2.value = Ve(A(), c2.value[0]) ? [A(), c2.value[0]] : [c2.value[0], A()] : c2.value = [A()] : c2.value = A(), M3();
    },
    presetDateRange: (s3, k2) => {
      k2 || s3.length && s3.length <= 2 && e2.range && (c2.value = s3.map((X2) => A(X2)), M3(), e2.multiCalendars && nextTick().then(() => J(true)));
    }
  };
};
var yl = (e2, n, a3) => {
  const t2 = ref(), {
    getZonedToUtc: i2,
    getZonedDate: v,
    formatDate: m3,
    getDefaultPattern: T2,
    checkRangeEnabled: Y2,
    checkPartialRangeValue: _,
    isValidDate: W,
    setDateMonthOrYear: C,
    defaults: c2
  } = xe(n), g = ref(""), Q2 = toRef(n, "format");
  watch(t2, () => {
    e2("internal-model-change", t2.value);
  }), watch(Q2, () => {
    y3();
  });
  const U = (l) => {
    const M3 = l || A();
    return n.modelType ? u2(M3) : {
      hours: getHours(M3),
      minutes: getMinutes(M3),
      seconds: n.enableSeconds ? getSeconds(M3) : 0
    };
  }, x2 = (l) => n.modelType ? u2(l) : { month: getMonth(l), year: getYear(l) }, V = (l) => Array.isArray(l) ? Y2(() => [
    setYear(A(), l[0]),
    l[1] ? setYear(A(), l[1]) : _()
  ]) : setYear(A(), +l), F = (l, M3) => (typeof l == "string" || typeof l == "number") && n.modelType ? d3(l) : M3, ae = (l) => Array.isArray(l) ? [
    F(
      l[0],
      Ke(null, +l[0].hours, +l[0].minutes, l[0].seconds)
    ),
    F(
      l[1],
      Ke(null, +l[1].hours, +l[1].minutes, l[1].seconds)
    )
  ] : F(l, Ke(null, l.hours, l.minutes, l.seconds)), oe = (l) => Array.isArray(l) ? n.multiDates ? l.map((M3) => F(M3, C(null, +M3.month, +M3.year))) : Y2(() => [
    F(l[0], C(null, +l[0].month, +l[0].year)),
    F(
      l[1],
      l[1] ? C(null, +l[1].month, +l[1].year) : _()
    )
  ]) : F(l, C(null, +l.month, +l.year)), B2 = (l) => {
    if (Array.isArray(l))
      return l.map((M3) => d3(M3));
    throw new Error(zt.dateArr("multi-dates"));
  }, G2 = (l) => {
    if (Array.isArray(l))
      return [A(l[0]), A(l[1])];
    throw new Error(zt.dateArr("week-picker"));
  }, J = (l) => n.modelAuto ? Array.isArray(l) ? [d3(l[0]), d3(l[1])] : n.autoApply ? [d3(l)] : [d3(l), null] : Array.isArray(l) ? Y2(() => [
    d3(l[0]),
    l[1] ? d3(l[1]) : _()
  ]) : d3(l), ne = () => {
    Array.isArray(t2.value) && n.range && t2.value.length === 1 && t2.value.push(_());
  }, ce = () => {
    const l = t2.value;
    return [
      u2(l[0]),
      l[1] ? u2(l[1]) : _()
    ];
  }, ye = () => t2.value[1] ? ce() : u2(_e(t2.value[0])), O2 = () => (t2.value || []).map((l) => u2(l)), w2 = () => (ne(), n.modelAuto ? ye() : n.multiDates ? O2() : Array.isArray(t2.value) ? Y2(() => ce()) : u2(_e(t2.value))), f = (l) => l ? n.timePicker ? ae(_e(l)) : n.monthPicker ? oe(_e(l)) : n.yearPicker ? V(_e(l)) : n.multiDates ? B2(_e(l)) : n.weekPicker ? G2(_e(l)) : J(_e(l)) : null, N = (l) => {
    const M3 = f(l);
    W(_e(M3)) ? (t2.value = _e(M3), y3()) : (t2.value = null, g.value = "");
  }, I2 = () => {
    var M3;
    const l = (re) => {
      var se;
      return format(re, (se = c2.value.textInputOptions) == null ? void 0 : se.format);
    };
    return `${l(t2.value[0])} ${(M3 = c2.value.textInputOptions) == null ? void 0 : M3.rangeSeparator} ${t2.value[1] ? l(t2.value[1]) : ""}`;
  }, E2 = () => {
    var l;
    return a3.value && t2.value ? Array.isArray(t2.value) ? I2() : format(t2.value, (l = c2.value.textInputOptions) == null ? void 0 : l.format) : m3(t2.value);
  }, D2 = () => {
    var l;
    return t2.value ? n.multiDates ? t2.value.map((M3) => m3(M3)).join("; ") : n.textInput && typeof ((l = c2.value.textInputOptions) == null ? void 0 : l.format) == "string" ? E2() : m3(t2.value) : "";
  }, y3 = () => {
    !n.format || typeof n.format == "string" || n.textInput && typeof n.textInputOptions.format == "string" ? g.value = D2() : g.value = n.format(t2.value);
  }, d3 = (l) => {
    if (n.utc) {
      const M3 = new Date(l);
      return n.utc === "preserve" ? new Date(M3.getTime() + M3.getTimezoneOffset() * 6e4) : M3;
    }
    return n.modelType ? n.modelType === "date" || n.modelType === "timestamp" ? v(new Date(l)) : n.modelType === "format" && (typeof n.format == "string" || !n.format) ? parse(l, T2(), /* @__PURE__ */ new Date()) : v(parse(l, n.modelType, /* @__PURE__ */ new Date())) : v(new Date(l));
  }, u2 = (l) => l ? n.utc ? Ma(l, n.utc === "preserve", n.enableSeconds) : n.modelType ? n.modelType === "timestamp" ? +i2(l) : n.modelType === "format" && (typeof n.format == "string" || !n.format) ? m3(i2(l)) : m3(i2(l), n.modelType) : i2(l) : "", S3 = (l) => {
    e2("update:model-value", l);
  }, b2 = (l) => Array.isArray(t2.value) ? n.multiDates ? t2.value.map((M3) => l(M3)) : [
    l(t2.value[0]),
    t2.value[1] ? l(t2.value[1]) : _()
  ] : l(_e(t2.value)), Z = (l) => S3(_e(b2(l)));
  return {
    inputValue: g,
    internalModelValue: t2,
    checkBeforeEmit: () => t2.value ? n.range ? n.partialRange ? t2.value.length >= 1 : t2.value.length === 2 : !!t2.value : false,
    parseExternalModelValue: N,
    formatInputValue: y3,
    emitModelValue: () => (y3(), n.monthPicker ? Z(x2) : n.timePicker ? Z(U) : n.yearPicker ? Z(getYear) : n.weekPicker ? S3(t2.value) : S3(w2()))
  };
};
var gl = (e2, n) => {
  const { validateMonthYearInRange: a3, validateMaxDate: t2, validateMinDate: i2, defaults: v } = xe(e2), m3 = (C, c2) => {
    let g = C;
    return v.value.filters.months.includes(getMonth(g)) ? (g = c2 ? addMonths(C, 1) : subMonths(C, 1), m3(g, c2)) : g;
  }, T2 = (C, c2) => {
    let g = C;
    return v.value.filters.years.includes(getYear(g)) ? (g = c2 ? addYears(C, 1) : subYears(C, 1), T2(g, c2)) : g;
  }, Y2 = (C) => {
    const c2 = set(/* @__PURE__ */ new Date(), { month: e2.month, year: e2.year });
    let g = C ? addMonths(c2, 1) : subMonths(c2, 1);
    e2.disableYearSelect && (g = setYear(g, e2.year));
    let Q2 = getMonth(g), U = getYear(g);
    v.value.filters.months.includes(Q2) && (g = m3(g, C), Q2 = getMonth(g), U = getYear(g)), v.value.filters.years.includes(U) && (g = T2(g, C), U = getYear(g)), a3(Q2, U, C, e2.preventMinMaxNavigation) && _(Q2, U);
  }, _ = (C, c2) => {
    n("update-month-year", { month: C, year: c2 });
  }, W = computed(() => (C) => {
    if (!e2.preventMinMaxNavigation || C && !e2.maxDate || !C && !e2.minDate)
      return false;
    const c2 = set(/* @__PURE__ */ new Date(), { month: e2.month, year: e2.year }), g = C ? addMonths(c2, 1) : subMonths(c2, 1), Q2 = [getMonth(g), getYear(g)];
    return C ? !t2(...Q2) : !i2(...Q2);
  });
  return { handleMonthYearChange: Y2, isDisabled: W, updateMonthYear: _ };
};
var xt = ((e2) => (e2.center = "center", e2.left = "left", e2.right = "right", e2))(xt || {});
var hl = (e2, n, a3, t2) => {
  const i2 = ref({
    top: "0",
    left: "0",
    transform: "none",
    opacity: "0"
  }), v = ref(false), m3 = toRef(t2, "teleportCenter"), T2 = computed(() => v.value ? "-100%" : "0"), Y2 = () => {
    _(), i2.value.opacity = "0";
  };
  watch(m3, () => {
    F();
  }), onMounted(() => {
    _();
  });
  const _ = () => {
    const w2 = Ae(n);
    if (w2) {
      const { top: f, left: N, width: I2, height: E2 } = Q2(w2);
      i2.value.top = `${f + E2 / 2}px`, g(N, I2, 50);
    }
  }, W = (w2) => {
    if (t2.teleport) {
      const f = w2.getBoundingClientRect();
      return {
        left: f.left + window.scrollX,
        top: f.top + window.scrollY
      };
    }
    return { top: 0, left: 0 };
  }, C = (w2, f) => {
    i2.value.left = `${w2 + f}px`, i2.value.transform = `translate(-100%, ${T2.value})`;
  }, c2 = (w2) => {
    i2.value.left = `${w2}px`, i2.value.transform = `translate(0, ${T2.value})`;
  }, g = (w2, f, N) => {
    t2.position === xt.left && c2(w2), t2.position === xt.right && C(w2, f), t2.position === xt.center && (i2.value.left = `${w2 + f / 2}px`, i2.value.transform = N ? `translate(-50%, -${N}%)` : `translate(-50%, ${T2.value})`);
  }, Q2 = (w2) => {
    const { width: f, height: N } = w2.getBoundingClientRect(), { top: I2, left: E2 } = t2.altPosition ? t2.altPosition(w2) : W(w2);
    return { top: +I2, left: +E2, width: f, height: N };
  }, U = () => {
    const w2 = Ae(n);
    if (w2) {
      const { top: f, left: N, width: I2, height: E2 } = Q2(w2), D2 = J();
      i2.value.top = `${f + E2 / 2}px`, g(N, I2, D2 === "top" ? 100 : 0);
    }
  }, x2 = () => {
    i2.value.left = "50%", i2.value.top = "50%", i2.value.transform = "translate(-50%, -50%)", i2.value.position = "fixed", delete i2.value.opacity;
  }, V = () => {
    const w2 = Ae(n), { top: f, left: N, transform: I2 } = t2.altPosition(w2);
    i2.value = { top: `${f}px`, left: `${N}px`, transform: I2 || "" };
  }, F = (w2 = true) => {
    if (!t2.inline)
      return m3.value ? x2() : t2.altPosition !== null ? V() : (w2 && a3("recalculate-position"), ce());
  }, ae = ({
    inputEl: w2,
    menuEl: f,
    left: N,
    width: I2
  }) => {
    window.screen.width > 768 && g(N, I2), G2(w2, f);
  }, oe = (w2, f) => {
    const { top: N, left: I2, height: E2, width: D2 } = Q2(w2);
    i2.value.top = `${E2 + N + +t2.offset}px`, v.value = false, ae({ inputEl: w2, menuEl: f, left: I2, width: D2 });
  }, B2 = (w2, f) => {
    const { top: N, left: I2, width: E2 } = Q2(w2);
    i2.value.top = `${N - +t2.offset}px`, v.value = true, ae({ inputEl: w2, menuEl: f, left: I2, width: E2 });
  }, G2 = (w2, f) => {
    if (t2.autoPosition) {
      const { left: N, width: I2 } = Q2(w2), { left: E2, right: D2 } = f.getBoundingClientRect();
      return E2 <= 0 ? c2(N) : D2 >= document.documentElement.clientWidth ? C(N, I2) : g(N, I2);
    }
  }, J = () => {
    const w2 = Ae(e2), f = Ae(n);
    if (w2 && f) {
      const { height: N } = w2.getBoundingClientRect(), { top: I2, height: E2 } = f.getBoundingClientRect(), y3 = window.innerHeight - I2 - E2, d3 = I2;
      return N <= y3 ? "bottom" : N > y3 && N <= d3 ? "top" : y3 >= d3 ? "bottom" : "top";
    }
    return "bottom";
  }, ne = (w2, f) => J() === "bottom" ? oe(w2, f) : B2(w2, f), ce = () => {
    const w2 = Ae(n), f = Ae(e2);
    if (w2 && f)
      return t2.autoPosition ? ne(w2, f) : oe(w2, f);
  }, ye = function(w2) {
    if (w2) {
      const f = w2.scrollHeight > w2.clientHeight, I2 = window.getComputedStyle(w2).overflowY.indexOf("hidden") !== -1;
      return f && !I2;
    }
    return true;
  }, O2 = function(w2) {
    return !w2 || w2 === document.body || w2.nodeType === Node.DOCUMENT_FRAGMENT_NODE ? window : ye(w2) ? w2 : O2(w2.parentNode);
  };
  return { openOnTop: v, menuStyle: i2, resetPosition: Y2, setMenuPosition: F, setInitialPosition: U, getScrollableParent: O2 };
};
var Dt = [
  { name: "clock-icon", use: ["time", "calendar"] },
  { name: "arrow-left", use: ["month-year", "calendar"] },
  { name: "arrow-right", use: ["month-year", "calendar"] },
  { name: "arrow-up", use: ["time", "calendar", "month-year"] },
  { name: "arrow-down", use: ["time", "calendar", "month-year"] },
  { name: "calendar-icon", use: ["month-year", "time", "calendar"] },
  { name: "day", use: ["calendar"] },
  { name: "month-overlay-value", use: ["calendar", "month-year"] },
  { name: "year-overlay-value", use: ["calendar", "month-year"] },
  { name: "year-overlay", use: ["month-year"] },
  { name: "month-overlay", use: ["month-year"] },
  { name: "month-overlay-header", use: ["month-year"] },
  { name: "year-overlay-header", use: ["month-year"] },
  { name: "hours-overlay-value", use: ["calendar", "time"] },
  { name: "minutes-overlay-value", use: ["calendar", "time"] },
  { name: "seconds-overlay-value", use: ["calendar", "time"] },
  { name: "hours", use: ["calendar", "time"] },
  { name: "minutes", use: ["calendar", "time"] },
  { name: "month", use: ["calendar", "month-year"] },
  { name: "year", use: ["calendar", "month-year"] },
  { name: "action-buttons", use: ["action"] },
  { name: "action-preview", use: ["action"] },
  { name: "calendar-header", use: ["calendar"] },
  { name: "marker-tooltip", use: ["calendar"] },
  { name: "action-extra", use: ["menu"] },
  { name: "time-picker-overlay", use: ["calendar", "time"] },
  { name: "am-pm-button", use: ["calendar", "time"] },
  { name: "left-sidebar", use: ["menu"] },
  { name: "right-sidebar", use: ["menu"] },
  { name: "month-year", use: ["month-year"] },
  { name: "time-picker", use: ["menu"] },
  { name: "action-row", use: ["action"] },
  { name: "marker", use: ["calendar"] }
];
var pl = [{ name: "trigger" }, { name: "input-icon" }, { name: "clear-icon" }, { name: "dp-input" }];
var kl = {
  all: () => Dt,
  monthYear: () => Dt.filter((e2) => e2.use.includes("month-year")),
  input: () => pl,
  timePicker: () => Dt.filter((e2) => e2.use.includes("time")),
  action: () => Dt.filter((e2) => e2.use.includes("action")),
  calendar: () => Dt.filter((e2) => e2.use.includes("calendar")),
  menu: () => Dt.filter((e2) => e2.use.includes("menu"))
};
var ht = (e2, n, a3) => {
  const t2 = [];
  return kl[n]().forEach((i2) => {
    e2[i2.name] && t2.push(i2.name);
  }), a3 && a3.length && a3.forEach((i2) => {
    i2.slot && t2.push(i2.slot);
  }), t2;
};
var jt = (e2) => ({ transitionName: computed(() => (a3) => e2 && typeof e2 != "boolean" ? a3 ? e2.open : e2.close : ""), showTransition: !!e2 });
var dt = {
  multiCalendars: { type: [Boolean, Number, String], default: null },
  modelValue: { type: [String, Date, Array, Object, Number], default: null },
  modelType: { type: String, default: null },
  position: { type: String, default: "center" },
  dark: { type: Boolean, default: false },
  format: {
    type: [String, Function],
    default: () => null
  },
  closeOnScroll: { type: Boolean, default: false },
  autoPosition: { type: Boolean, default: true },
  closeOnAutoApply: { type: Boolean, default: true },
  altPosition: { type: Function, default: null },
  transitions: { type: [Boolean, Object], default: true },
  formatLocale: { type: Object, default: null },
  utc: { type: [Boolean, String], default: false },
  ariaLabels: { type: Object, default: () => ({}) },
  offset: { type: [Number, String], default: 10 },
  hideNavigation: { type: Array, default: () => [] },
  timezone: { type: String, default: null },
  vertical: { type: Boolean, default: false },
  disableMonthYearSelect: { type: Boolean, default: false },
  disableYearSelect: { type: Boolean, default: false },
  menuClassName: { type: String, default: null },
  dayClass: { type: Function, default: null },
  yearRange: { type: Array, default: () => [1900, 2100] },
  multiCalendarsSolo: { type: Boolean, default: false },
  calendarCellClassName: { type: String, default: null },
  enableTimePicker: { type: Boolean, default: true },
  autoApply: { type: Boolean, default: false },
  disabledDates: { type: [Array, Function], default: () => [] },
  monthNameFormat: { type: String, default: "short" },
  startDate: { type: [Date, String], default: null },
  startTime: { type: [Object, Array], default: null },
  hideOffsetDates: { type: Boolean, default: false },
  autoRange: { type: [Number, String], default: null },
  noToday: { type: Boolean, default: false },
  disabledWeekDays: { type: Array, default: () => [] },
  allowedDates: { type: Array, default: null },
  showNowButton: { type: Boolean, default: false },
  nowButtonLabel: { type: String, default: "Now" },
  markers: { type: Array, default: () => [] },
  modeHeight: { type: [Number, String], default: 255 },
  escClose: { type: Boolean, default: true },
  spaceConfirm: { type: Boolean, default: true },
  monthChangeOnArrows: { type: Boolean, default: true },
  presetRanges: { type: Array, default: () => [] },
  flow: { type: Array, default: () => [] },
  partialFlow: { type: Boolean, default: false },
  preventMinMaxNavigation: { type: Boolean, default: false },
  minRange: { type: [Number, String], default: null },
  maxRange: { type: [Number, String], default: null },
  multiDatesLimit: { type: [Number, String], default: null },
  reverseYears: { type: Boolean, default: false },
  keepActionRow: { type: Boolean, default: false },
  weekPicker: { type: Boolean, default: false },
  filters: { type: Object, default: () => ({}) },
  arrowNavigation: { type: Boolean, default: false },
  multiStatic: { type: Boolean, default: true },
  disableTimeRangeValidation: { type: Boolean, default: false },
  highlight: {
    type: [Array, Function],
    default: null
  },
  highlightWeekDays: {
    type: Array,
    default: null
  },
  highlightDisabledDays: { type: Boolean, default: false },
  teleport: { type: [String, Boolean], default: null },
  teleportCenter: { type: Boolean, default: false },
  locale: { type: String, default: "en-Us" },
  weekNumName: { type: String, default: "W" },
  weekStart: { type: [Number, String], default: 1 },
  weekNumbers: {
    type: [String, Function],
    default: null
  },
  calendarClassName: { type: String, default: null },
  noSwipe: { type: Boolean, default: false },
  monthChangeOnScroll: { type: [Boolean, String], default: true },
  dayNames: {
    type: [Function, Array],
    default: null
  },
  monthPicker: { type: Boolean, default: false },
  customProps: { type: Object, default: null },
  yearPicker: { type: Boolean, default: false },
  modelAuto: { type: Boolean, default: false },
  selectText: { type: String, default: "Select" },
  cancelText: { type: String, default: "Cancel" },
  previewFormat: {
    type: [String, Function],
    default: () => ""
  },
  multiDates: { type: Boolean, default: false },
  partialRange: { type: Boolean, default: true },
  ignoreTimeValidation: { type: Boolean, default: false },
  minDate: { type: [Date, String], default: null },
  maxDate: { type: [Date, String], default: null },
  minTime: { type: Object, default: null },
  maxTime: { type: Object, default: null },
  name: { type: String, default: null },
  placeholder: { type: String, default: "" },
  hideInputIcon: { type: Boolean, default: false },
  clearable: { type: Boolean, default: true },
  state: { type: Boolean, default: null },
  required: { type: Boolean, default: false },
  autocomplete: { type: String, default: "off" },
  inputClassName: { type: String, default: null },
  inlineWithInput: { type: Boolean, default: false },
  textInputOptions: { type: Object, default: () => null },
  fixedStart: { type: Boolean, default: false },
  fixedEnd: { type: Boolean, default: false },
  timePicker: { type: Boolean, default: false },
  enableSeconds: { type: Boolean, default: false },
  is24: { type: Boolean, default: true },
  noHoursOverlay: { type: Boolean, default: false },
  noMinutesOverlay: { type: Boolean, default: false },
  noSecondsOverlay: { type: Boolean, default: false },
  hoursGridIncrement: { type: [String, Number], default: 1 },
  minutesGridIncrement: { type: [String, Number], default: 5 },
  secondsGridIncrement: { type: [String, Number], default: 5 },
  hoursIncrement: { type: [Number, String], default: 1 },
  minutesIncrement: { type: [Number, String], default: 1 },
  secondsIncrement: { type: [Number, String], default: 1 },
  range: { type: Boolean, default: false },
  uid: { type: String, default: null },
  disabled: { type: Boolean, default: false },
  readonly: { type: Boolean, default: false },
  inline: { type: Boolean, default: false },
  textInput: { type: Boolean, default: false },
  onClickOutside: { type: Function, default: null },
  noDisabledRange: { type: Boolean, default: false },
  sixWeeks: { type: [Boolean, String], default: false },
  actionRow: { type: Object, default: () => ({}) },
  allowPreventDefault: { type: Boolean, default: false },
  closeOnClearValue: { type: Boolean, default: true },
  focusStartDate: { type: Boolean, default: false },
  disabledTimes: { type: Function, default: void 0 },
  showLastInRange: { type: Boolean, default: true },
  timePickerInline: { type: Boolean, default: false },
  calendar: { type: Function, default: null },
  autoApplyMonth: { type: Boolean, default: true }
};
var wl = {
  key: 1,
  class: "dp__input_wrap"
};
var bl = ["id", "name", "inputmode", "placeholder", "disabled", "readonly", "required", "value", "autocomplete", "aria-label", "onKeydown"];
var Dl = {
  key: 2,
  class: "dp__clear_icon"
};
var $l = defineComponent({
  __name: "DatepickerInput",
  props: {
    isMenuOpen: { type: Boolean, default: false },
    inputValue: { type: String, default: "" },
    ...dt
  },
  emits: [
    "clear",
    "open",
    "update:input-value",
    "set-input-date",
    "close",
    "select-date",
    "set-empty-date",
    "toggle",
    "focus-prev",
    "focus",
    "blur",
    "real-blur"
  ],
  setup(e2, { expose: n, emit: a3 }) {
    const t2 = e2, { getDefaultPattern: i2, isValidDate: v, defaults: m3, getDefaultStartTime: T2, assignDefaultTime: Y2 } = xe(t2), _ = ref(), W = ref(null), C = ref(false), c2 = ref(false), g = computed(
      () => ({
        dp__pointer: !t2.disabled && !t2.readonly && !t2.textInput,
        dp__disabled: t2.disabled,
        dp__input_readonly: !t2.textInput,
        dp__input: true,
        dp__input_icon_pad: !t2.hideInputIcon,
        dp__input_valid: t2.state,
        dp__input_invalid: t2.state === false,
        dp__input_focus: C.value || t2.isMenuOpen,
        dp__input_reg: !t2.textInput,
        [t2.inputClassName]: !!t2.inputClassName
      })
    ), Q2 = () => {
      a3("set-input-date", null), t2.autoApply && (a3("set-empty-date"), _.value = null);
    }, U = (f) => {
      var I2;
      const N = T2();
      return $a(
        f,
        ((I2 = m3.value.textInputOptions) == null ? void 0 : I2.format) || i2(),
        N || Y2({}),
        t2.inputValue,
        c2.value
      );
    }, x2 = (f) => {
      const { rangeSeparator: N } = m3.value.textInputOptions, [I2, E2] = f.split(`${N}`);
      if (I2) {
        const D2 = U(I2.trim()), y3 = E2 ? U(E2.trim()) : null, d3 = D2 && y3 ? [D2, y3] : [D2];
        _.value = D2 ? d3 : null;
      }
    }, V = () => {
      c2.value = true;
    }, F = (f) => {
      if (t2.range)
        x2(f);
      else if (t2.multiDates) {
        const N = f.split(";");
        _.value = N.map((I2) => U(I2.trim())).filter((I2) => I2);
      } else
        _.value = U(f);
    }, ae = (f) => {
      var I2, E2;
      const N = typeof f == "string" ? f : (I2 = f.target) == null ? void 0 : I2.value;
      N !== "" ? ((E2 = m3.value.textInputOptions) != null && E2.openMenu && !t2.isMenuOpen && a3("open"), F(N), a3("set-input-date", _.value)) : Q2(), c2.value = false, a3("update:input-value", N);
    }, oe = (f) => {
      var N, I2;
      t2.textInput ? (F(f.target.value), (N = m3.value.textInputOptions) != null && N.enterSubmit && v(_.value) && t2.inputValue !== "" ? (a3("set-input-date", _.value, true), _.value = null) : (I2 = m3.value.textInputOptions) != null && I2.enterSubmit && t2.inputValue === "" && (_.value = null, a3("clear"))) : J(f);
    }, B2 = (f) => {
      var N, I2, E2;
      t2.textInput && ((N = m3.value.textInputOptions) != null && N.tabSubmit) && F(f.target.value), (I2 = m3.value.textInputOptions) != null && I2.tabSubmit && v(_.value) && t2.inputValue !== "" ? (a3("set-input-date", _.value, true), _.value = null) : (E2 = m3.value.textInputOptions) != null && E2.tabSubmit && t2.inputValue === "" && (_.value = null, a3("clear"));
    }, G2 = () => {
      C.value = true, a3("focus");
    }, J = (f) => {
      var N;
      f.preventDefault(), f.stopImmediatePropagation(), f.stopPropagation(), t2.textInput && ((N = m3.value.textInputOptions) != null && N.openMenu) && !t2.inlineWithInput ? (a3("toggle"), m3.value.textInputOptions.enterSubmit && a3("select-date")) : t2.textInput || a3("toggle");
    }, ne = () => {
      a3("real-blur"), C.value = false, (!t2.isMenuOpen || t2.inline && t2.inlineWithInput) && a3("blur"), t2.autoApply && t2.textInput && _.value && !t2.isMenuOpen && (a3("set-input-date", _.value), a3("select-date"), _.value = null);
    }, ce = () => {
      a3("clear");
    }, ye = (f) => {
      if (!t2.textInput) {
        if (f.code === "Tab")
          return;
        f.preventDefault();
      }
    };
    return n({
      focusInput: () => {
        var f;
        (f = W.value) == null || f.focus({ preventScroll: true });
      },
      setParsedDate: (f) => {
        _.value = f;
      }
    }), (f, N) => {
      var I2;
      return openBlock(), createElementBlock("div", { onClick: J }, [
        f.$slots.trigger && !f.$slots["dp-input"] && !f.inline ? renderSlot(f.$slots, "trigger", { key: 0 }) : createCommentVNode("", true),
        !f.$slots.trigger && (!f.inline || f.inlineWithInput) ? (openBlock(), createElementBlock("div", wl, [
          f.$slots["dp-input"] && !f.$slots.trigger && !f.inline ? renderSlot(f.$slots, "dp-input", {
            key: 0,
            value: e2.inputValue,
            isMenuOpen: e2.isMenuOpen,
            onInput: ae,
            onEnter: oe,
            onTab: B2,
            onClear: ce,
            onBlur: ne,
            onKeypress: ye,
            onPaste: V
          }) : createCommentVNode("", true),
          f.$slots["dp-input"] ? createCommentVNode("", true) : (openBlock(), createElementBlock("input", {
            key: 1,
            ref_key: "inputRef",
            ref: W,
            id: f.uid ? `dp-input-${f.uid}` : void 0,
            name: f.name,
            class: normalizeClass(g.value),
            inputmode: f.textInput ? "text" : "none",
            placeholder: f.placeholder,
            disabled: f.disabled,
            readonly: f.readonly,
            required: f.required,
            value: e2.inputValue,
            autocomplete: f.autocomplete,
            "aria-label": (I2 = unref(m3).ariaLabels) == null ? void 0 : I2.input,
            onInput: ae,
            onKeydown: [
              withKeys(oe, ["enter"]),
              withKeys(B2, ["tab"]),
              ye
            ],
            onBlur: ne,
            onFocus: G2,
            onKeypress: ye,
            onPaste: V
          }, null, 42, bl)),
          createBaseVNode("div", {
            onClick: N[2] || (N[2] = (E2) => a3("toggle"))
          }, [
            f.$slots["input-icon"] && !f.hideInputIcon ? (openBlock(), createElementBlock("span", {
              key: 0,
              class: "dp__input_icon",
              onClick: N[0] || (N[0] = (E2) => a3("toggle"))
            }, [
              renderSlot(f.$slots, "input-icon")
            ])) : createCommentVNode("", true),
            !f.$slots["input-icon"] && !f.hideInputIcon && !f.$slots["dp-input"] ? (openBlock(), createBlock(unref(Kt), {
              key: 1,
              onClick: N[1] || (N[1] = (E2) => a3("toggle")),
              class: "dp__input_icon dp__input_icons"
            })) : createCommentVNode("", true)
          ]),
          f.$slots["clear-icon"] && e2.inputValue && f.clearable && !f.disabled && !f.readonly ? (openBlock(), createElementBlock("span", Dl, [
            renderSlot(f.$slots, "clear-icon", { clear: ce })
          ])) : createCommentVNode("", true),
          f.clearable && !f.$slots["clear-icon"] && e2.inputValue && !f.disabled && !f.readonly ? (openBlock(), createBlock(unref(Da), {
            key: 3,
            class: "dp__clear_icon dp__input_icons",
            onClick: withModifiers(ce, ["stop", "prevent"])
          }, null, 8, ["onClick"])) : createCommentVNode("", true)
        ])) : createCommentVNode("", true)
      ]);
    };
  }
});
var Ml = ["title"];
var Al = { class: "dp__action_buttons" };
var Tl = ["onKeydown", "disabled"];
var Sl = defineComponent({
  __name: "ActionRow",
  props: {
    menuMount: { type: Boolean, default: false },
    internalModelValue: { type: [Date, Array], default: null },
    calendarWidth: { type: Number, default: 0 },
    ...dt
  },
  emits: ["close-picker", "select-date", "select-now", "invalid-select"],
  setup(e2, { emit: n }) {
    const a3 = e2, { formatDate: t2, isValidTime: i2, defaults: v } = xe(a3), { buildMatrix: m3 } = ut(), T2 = ref(null), Y2 = ref(null);
    onMounted(() => {
      a3.arrowNavigation && m3([Ae(T2), Ae(Y2)], "actionRow");
    });
    const _ = computed(() => a3.range && !a3.partialRange && a3.internalModelValue ? a3.internalModelValue.length === 2 : true), W = computed(() => !C.value || !c2.value || !_.value), C = computed(() => !a3.enableTimePicker || a3.ignoreTimeValidation ? true : i2(a3.internalModelValue)), c2 = computed(() => a3.monthPicker ? a3.range && Array.isArray(a3.internalModelValue) ? !a3.internalModelValue.filter((G2) => !ae(G2)).length : ae(a3.internalModelValue) : true), g = () => {
      const B2 = v.value.previewFormat;
      return a3.timePicker || a3.monthPicker, B2(_e(a3.internalModelValue));
    }, Q2 = () => {
      const B2 = a3.internalModelValue;
      return v.value.multiCalendars > 0 ? `${U(B2[0])} - ${U(B2[1])}` : [U(B2[0]), U(B2[1])];
    }, U = (B2) => t2(B2, v.value.previewFormat), x2 = computed(() => !a3.internalModelValue || !a3.menuMount ? "" : typeof v.value.previewFormat == "string" ? Array.isArray(a3.internalModelValue) ? a3.internalModelValue.length === 2 && a3.internalModelValue[1] ? Q2() : a3.multiDates ? a3.internalModelValue.map((B2) => `${U(B2)}`) : a3.modelAuto ? `${U(a3.internalModelValue[0])}` : `${U(a3.internalModelValue[0])} -` : U(a3.internalModelValue) : g()), V = () => a3.multiDates ? "; " : " - ", F = computed(
      () => Array.isArray(x2.value) ? x2.value.join(V()) : x2.value
    ), ae = (B2) => {
      if (!a3.monthPicker)
        return true;
      let G2 = true;
      const J = A(Pt(B2));
      if (a3.minDate && a3.maxDate) {
        const ne = A(Pt(a3.minDate)), ce = A(Pt(a3.maxDate));
        return Fe(J, ne) && Ve(J, ce) || ke(J, ne) || ke(J, ce);
      }
      if (a3.minDate) {
        const ne = A(Pt(a3.minDate));
        G2 = Fe(J, ne) || ke(J, ne);
      }
      if (a3.maxDate) {
        const ne = A(Pt(a3.maxDate));
        G2 = Ve(J, ne) || ke(J, ne);
      }
      return G2;
    }, oe = () => {
      C.value && c2.value && _.value ? n("select-date") : n("invalid-select");
    };
    return (B2, G2) => (openBlock(), createElementBlock("div", {
      class: "dp__action_row",
      style: normalizeStyle(e2.calendarWidth ? { width: `${e2.calendarWidth}px` } : {})
    }, [
      B2.$slots["action-row"] ? renderSlot(B2.$slots, "action-row", normalizeProps(mergeProps({ key: 0 }, {
        internalModelValue: e2.internalModelValue,
        disabled: W.value,
        selectDate: () => B2.$emit("select-date"),
        closePicker: () => B2.$emit("close-picker")
      }))) : (openBlock(), createElementBlock(Fragment, { key: 1 }, [
        unref(v).actionRow.showPreview ? (openBlock(), createElementBlock("div", {
          key: 0,
          class: "dp__selection_preview",
          title: F.value
        }, [
          B2.$slots["action-preview"] ? renderSlot(B2.$slots, "action-preview", {
            key: 0,
            value: e2.internalModelValue
          }) : createCommentVNode("", true),
          B2.$slots["action-preview"] ? createCommentVNode("", true) : (openBlock(), createElementBlock(Fragment, { key: 1 }, [
            createTextVNode(toDisplayString(F.value), 1)
          ], 64))
        ], 8, Ml)) : createCommentVNode("", true),
        createBaseVNode("div", Al, [
          B2.$slots["action-buttons"] ? renderSlot(B2.$slots, "action-buttons", {
            key: 0,
            value: e2.internalModelValue
          }) : createCommentVNode("", true),
          B2.$slots["action-buttons"] ? createCommentVNode("", true) : (openBlock(), createElementBlock(Fragment, { key: 1 }, [
            !B2.inline && unref(v).actionRow.showCancel ? (openBlock(), createElementBlock("button", {
              key: 0,
              type: "button",
              ref_key: "cancelButtonRef",
              ref: T2,
              class: "dp__action_button dp__action_cancel",
              onClick: G2[0] || (G2[0] = (J) => B2.$emit("close-picker")),
              onKeydown: [
                G2[1] || (G2[1] = withKeys((J) => B2.$emit("close-picker"), ["enter"])),
                G2[2] || (G2[2] = withKeys((J) => B2.$emit("close-picker"), ["space"]))
              ]
            }, toDisplayString(B2.cancelText), 545)) : createCommentVNode("", true),
            B2.showNowButton || unref(v).actionRow.showNow ? (openBlock(), createElementBlock("button", {
              key: 1,
              type: "button",
              ref_key: "cancelButtonRef",
              ref: T2,
              class: "dp__action_button dp__action_cancel",
              onClick: G2[3] || (G2[3] = (J) => B2.$emit("select-now")),
              onKeydown: [
                G2[4] || (G2[4] = withKeys((J) => B2.$emit("select-now"), ["enter"])),
                G2[5] || (G2[5] = withKeys((J) => B2.$emit("select-now"), ["space"]))
              ]
            }, toDisplayString(B2.nowButtonLabel), 545)) : createCommentVNode("", true),
            unref(v).actionRow.showSelect ? (openBlock(), createElementBlock("button", {
              key: 2,
              type: "button",
              class: "dp__action_button dp__action_select",
              onKeydown: [
                withKeys(oe, ["enter"]),
                withKeys(oe, ["space"])
              ],
              onClick: oe,
              disabled: W.value,
              ref_key: "selectButtonRef",
              ref: Y2
            }, toDisplayString(B2.selectText), 41, Tl)) : createCommentVNode("", true)
          ], 64))
        ])
      ], 64))
    ], 4));
  }
});
var Pl = ["aria-label"];
var _l = {
  class: "dp__calendar_header",
  role: "row"
};
var Cl = {
  key: 0,
  class: "dp__calendar_header_item",
  role: "gridcell"
};
var Nl = createBaseVNode("div", { class: "dp__calendar_header_separator" }, null, -1);
var Rl = ["aria-label"];
var Il = {
  key: 0,
  role: "gridcell",
  class: "dp__calendar_item dp__week_num"
};
var Ol = { class: "dp__cell_inner" };
var Bl = ["aria-selected", "aria-disabled", "aria-label", "onClick", "onKeydown", "onMouseenter", "onMouseleave"];
var Yl = defineComponent({
  __name: "Calendar",
  props: {
    mappedDates: { type: Array, default: () => [] },
    getWeekNum: {
      type: Function,
      default: () => ""
    },
    specificMode: { type: Boolean, default: false },
    instance: { type: Number, default: 0 },
    month: { type: Number, default: 0 },
    year: { type: Number, default: 0 },
    ...dt
  },
  emits: [
    "select-date",
    "set-hover-date",
    "handle-scroll",
    "mount",
    "handle-swipe",
    "handle-space",
    "tooltip-open",
    "tooltip-close"
  ],
  setup(e2, { expose: n, emit: a3 }) {
    const t2 = e2, { buildMultiLevelMatrix: i2 } = ut(), { setDateMonthOrYear: v, defaults: m3 } = xe(t2), T2 = ref(null), Y2 = ref({
      bottom: "",
      left: "",
      transform: ""
    }), _ = ref([]), W = ref(null), C = ref(true), c2 = ref(""), g = ref({ startX: 0, endX: 0, startY: 0, endY: 0 }), Q2 = ref([]), U = ref({ left: "50%" }), x2 = computed(() => t2.calendar ? t2.calendar(t2.mappedDates) : t2.mappedDates), V = computed(() => t2.dayNames ? Array.isArray(t2.dayNames) ? t2.dayNames : t2.dayNames(t2.locale, +t2.weekStart) : el(t2.formatLocale, t2.locale, +t2.weekStart));
    onMounted(() => {
      a3("mount", { cmp: "calendar", refs: _ }), t2.noSwipe || W.value && (W.value.addEventListener("touchstart", w2, { passive: false }), W.value.addEventListener("touchend", f, { passive: false }), W.value.addEventListener("touchmove", N, { passive: false })), t2.monthChangeOnScroll && W.value && W.value.addEventListener("wheel", D2, { passive: false });
    });
    const F = (y3) => y3 ? t2.vertical ? "vNext" : "next" : t2.vertical ? "vPrevious" : "previous", ae = (y3, d3) => {
      if (t2.transitions) {
        const u2 = je(v(A(), t2.month, t2.year));
        c2.value = Fe(je(v(A(), y3, d3)), u2) ? m3.value.transitions[F(true)] : m3.value.transitions[F(false)], C.value = false, nextTick(() => {
          C.value = true;
        });
      }
    }, oe = computed(
      () => ({
        [t2.calendarClassName]: !!t2.calendarClassName
      })
    ), B2 = computed(() => (y3) => {
      const d3 = ll(y3);
      return {
        dp__marker_dot: d3.type === "dot",
        dp__marker_line: d3.type === "line"
      };
    }), G2 = computed(() => (y3) => ke(y3, T2.value)), J = computed(() => ({
      dp__calendar: true,
      dp__calendar_next: m3.value.multiCalendars > 0 && t2.instance !== 0
    })), ne = computed(() => (y3) => t2.hideOffsetDates ? y3.current : true), ce = computed(() => t2.specificMode ? { height: `${t2.modeHeight}px` } : void 0), ye = async (y3, d3, u2) => {
      var S3, b2;
      if (a3("set-hover-date", y3), (b2 = (S3 = y3.marker) == null ? void 0 : S3.tooltip) != null && b2.length) {
        const Z = Ae(_.value[d3][u2]);
        if (Z) {
          const { width: r, height: o } = Z.getBoundingClientRect();
          T2.value = y3.value;
          let l = { left: `${r / 2}px` }, M3 = -50;
          if (await nextTick(), Q2.value[0]) {
            const { left: re, width: se } = Q2.value[0].getBoundingClientRect();
            re < 0 && (l = { left: "0" }, M3 = 0, U.value.left = `${r / 2}px`), window.innerWidth < re + se && (l = { right: "0" }, M3 = 0, U.value.left = `${se - r / 2}px`);
          }
          Y2.value = {
            bottom: `${o}px`,
            ...l,
            transform: `translateX(${M3}%)`
          }, a3("tooltip-open", y3.marker);
        }
      }
    }, O2 = (y3) => {
      T2.value && (T2.value = null, Y2.value = JSON.parse(JSON.stringify({ bottom: "", left: "", transform: "" })), a3("tooltip-close", y3.marker));
    }, w2 = (y3) => {
      g.value.startX = y3.changedTouches[0].screenX, g.value.startY = y3.changedTouches[0].screenY;
    }, f = (y3) => {
      g.value.endX = y3.changedTouches[0].screenX, g.value.endY = y3.changedTouches[0].screenY, I2();
    }, N = (y3) => {
      t2.vertical && !t2.inline && y3.preventDefault();
    }, I2 = () => {
      const y3 = t2.vertical ? "Y" : "X";
      Math.abs(g.value[`start${y3}`] - g.value[`end${y3}`]) > 10 && a3("handle-swipe", g.value[`start${y3}`] > g.value[`end${y3}`] ? "right" : "left");
    }, E2 = (y3, d3, u2) => {
      y3 && (Array.isArray(_.value[d3]) ? _.value[d3][u2] = y3 : _.value[d3] = [y3]), t2.arrowNavigation && i2(_.value, "calendar");
    }, D2 = (y3) => {
      t2.monthChangeOnScroll && (y3.preventDefault(), a3("handle-scroll", y3));
    };
    return n({ triggerTransition: ae }), (y3, d3) => {
      var u2;
      return openBlock(), createElementBlock("div", {
        class: normalizeClass(J.value)
      }, [
        createBaseVNode("div", {
          style: normalizeStyle(ce.value),
          ref_key: "calendarWrapRef",
          ref: W,
          role: "grid",
          class: normalizeClass(oe.value),
          "aria-label": (u2 = unref(m3).ariaLabels) == null ? void 0 : u2.calendarWrap
        }, [
          e2.specificMode ? createCommentVNode("", true) : (openBlock(), createElementBlock(Fragment, { key: 0 }, [
            createBaseVNode("div", _l, [
              y3.weekNumbers ? (openBlock(), createElementBlock("div", Cl, toDisplayString(y3.weekNumName), 1)) : createCommentVNode("", true),
              (openBlock(true), createElementBlock(Fragment, null, renderList(V.value, (S3, b2) => (openBlock(), createElementBlock("div", {
                class: "dp__calendar_header_item",
                role: "gridcell",
                key: b2
              }, [
                y3.$slots["calendar-header"] ? renderSlot(y3.$slots, "calendar-header", {
                  key: 0,
                  day: S3,
                  index: b2
                }) : createCommentVNode("", true),
                y3.$slots["calendar-header"] ? createCommentVNode("", true) : (openBlock(), createElementBlock(Fragment, { key: 1 }, [
                  createTextVNode(toDisplayString(S3), 1)
                ], 64))
              ]))), 128))
            ]),
            Nl,
            createVNode(Transition, {
              name: c2.value,
              css: !!y3.transitions
            }, {
              default: withCtx(() => {
                var S3;
                return [
                  C.value ? (openBlock(), createElementBlock("div", {
                    key: 0,
                    class: "dp__calendar",
                    role: "grid",
                    "aria-label": (S3 = unref(m3).ariaLabels) == null ? void 0 : S3.calendarDays
                  }, [
                    (openBlock(true), createElementBlock(Fragment, null, renderList(x2.value, (b2, Z) => (openBlock(), createElementBlock("div", {
                      class: "dp__calendar_row",
                      role: "row",
                      key: Z
                    }, [
                      y3.weekNumbers ? (openBlock(), createElementBlock("div", Il, [
                        createBaseVNode("div", Ol, toDisplayString(e2.getWeekNum(b2.days)), 1)
                      ])) : createCommentVNode("", true),
                      (openBlock(true), createElementBlock(Fragment, null, renderList(b2.days, (r, o) => {
                        var l, M3, re;
                        return openBlock(), createElementBlock("div", {
                          role: "gridcell",
                          class: "dp__calendar_item",
                          ref_for: true,
                          ref: (se) => E2(se, Z, o),
                          key: o + Z,
                          "aria-selected": r.classData.dp__active_date || r.classData.dp__range_start || r.classData.dp__range_start,
                          "aria-disabled": r.classData.dp__cell_disabled,
                          "aria-label": (M3 = (l = unref(m3).ariaLabels) == null ? void 0 : l.day) == null ? void 0 : M3.call(l, r),
                          tabindex: "0",
                          onClick: withModifiers((se) => y3.$emit("select-date", r), ["stop", "prevent"]),
                          onKeydown: [
                            withKeys((se) => y3.$emit("select-date", r), ["enter"]),
                            withKeys((se) => y3.$emit("handle-space", r), ["space"])
                          ],
                          onMouseenter: (se) => ye(r, Z, o),
                          onMouseleave: (se) => O2(r)
                        }, [
                          createBaseVNode("div", {
                            class: normalizeClass(["dp__cell_inner", r.classData])
                          }, [
                            y3.$slots.day && ne.value(r) ? renderSlot(y3.$slots, "day", {
                              key: 0,
                              day: +r.text,
                              date: r.value
                            }) : createCommentVNode("", true),
                            y3.$slots.day ? createCommentVNode("", true) : (openBlock(), createElementBlock(Fragment, { key: 1 }, [
                              createTextVNode(toDisplayString(r.text), 1)
                            ], 64)),
                            r.marker && ne.value(r) ? (openBlock(), createElementBlock(Fragment, { key: 2 }, [
                              y3.$slots.marker ? renderSlot(y3.$slots, "marker", {
                                key: 0,
                                marker: r.marker,
                                day: +r.text,
                                date: r.value
                              }) : (openBlock(), createElementBlock("div", {
                                key: 1,
                                class: normalizeClass(B2.value(r.marker)),
                                style: normalizeStyle(r.marker.color ? { backgroundColor: r.marker.color } : {})
                              }, null, 6))
                            ], 64)) : createCommentVNode("", true),
                            G2.value(r.value) ? (openBlock(), createElementBlock("div", {
                              key: 3,
                              class: "dp__marker_tooltip",
                              ref_for: true,
                              ref_key: "activeTooltip",
                              ref: Q2,
                              style: normalizeStyle(Y2.value)
                            }, [
                              (re = r.marker) != null && re.tooltip ? (openBlock(), createElementBlock("div", {
                                key: 0,
                                class: "dp__tooltip_content",
                                onClick: d3[0] || (d3[0] = withModifiers(() => {
                                }, ["stop"]))
                              }, [
                                (openBlock(true), createElementBlock(Fragment, null, renderList(r.marker.tooltip, (se, Pe) => (openBlock(), createElementBlock("div", {
                                  key: Pe,
                                  class: "dp__tooltip_text"
                                }, [
                                  y3.$slots["marker-tooltip"] ? renderSlot(y3.$slots, "marker-tooltip", {
                                    key: 0,
                                    tooltip: se,
                                    day: r.value
                                  }) : createCommentVNode("", true),
                                  y3.$slots["marker-tooltip"] ? createCommentVNode("", true) : (openBlock(), createElementBlock(Fragment, { key: 1 }, [
                                    createBaseVNode("div", {
                                      class: "dp__tooltip_mark",
                                      style: normalizeStyle(se.color ? { backgroundColor: se.color } : {})
                                    }, null, 4),
                                    createBaseVNode("div", null, toDisplayString(se.text), 1)
                                  ], 64))
                                ]))), 128)),
                                createBaseVNode("div", {
                                  class: "dp__arrow_bottom_tp",
                                  style: normalizeStyle(U.value)
                                }, null, 4)
                              ])) : createCommentVNode("", true)
                            ], 4)) : createCommentVNode("", true)
                          ], 2)
                        ], 40, Bl);
                      }), 128))
                    ]))), 128))
                  ], 8, Rl)) : createCommentVNode("", true)
                ];
              }),
              _: 3
            }, 8, ["name", "css"])
          ], 64))
        ], 14, Pl)
      ], 2);
    };
  }
});
var Vl = ["aria-label", "aria-disabled"];
var un = defineComponent({
  __name: "ActionIcon",
  props: {
    ariaLabel: {},
    disabled: { type: Boolean }
  },
  emits: ["activate", "set-ref"],
  setup(e2, { emit: n }) {
    const a3 = ref(null);
    return onMounted(() => n("set-ref", a3)), (t2, i2) => (openBlock(), createElementBlock("button", {
      type: "button",
      class: "dp__btn dp__month_year_col_nav",
      onClick: i2[0] || (i2[0] = (v) => t2.$emit("activate")),
      onKeydown: [
        i2[1] || (i2[1] = withKeys(withModifiers((v) => t2.$emit("activate"), ["prevent"]), ["enter"])),
        i2[2] || (i2[2] = withKeys(withModifiers((v) => t2.$emit("activate"), ["prevent"]), ["space"]))
      ],
      tabindex: "0",
      "aria-label": t2.ariaLabel,
      "aria-disabled": t2.disabled,
      ref_key: "elRef",
      ref: a3
    }, [
      createBaseVNode("span", {
        class: normalizeClass(["dp__inner_nav", { dp__inner_nav_disabled: t2.disabled }])
      }, [
        renderSlot(t2.$slots, "default")
      ], 2)
    ], 40, Vl));
  }
});
var El = ["onKeydown"];
var Ll = { class: "dp__selection_grid_header" };
var Fl = ["aria-selected", "aria-disabled", "onClick", "onKeydown", "onMouseover"];
var Ul = ["aria-label", "onKeydown"];
var Rt = defineComponent({
  __name: "SelectionGrid",
  props: {
    items: { type: Array, default: () => [] },
    modelValue: { type: [String, Number], default: null },
    multiModelValue: { type: Array, default: () => [] },
    disabledValues: { type: Array, default: () => [] },
    minValue: { type: [Number, String], default: null },
    maxValue: { type: [Number, String], default: null },
    year: { type: Number, default: 0 },
    skipActive: { type: Boolean, default: false },
    headerRefs: { type: Array, default: () => [] },
    skipButtonRef: { type: Boolean, default: false },
    monthPicker: { type: Boolean, default: false },
    yearPicker: { type: Boolean, default: false },
    escClose: { type: Boolean, default: true },
    type: { type: String, default: null },
    arrowNavigation: { type: Boolean, default: false },
    autoApply: { type: Boolean, default: false },
    textInput: { type: Boolean, default: false },
    ariaLabels: { type: Object, default: () => ({}) },
    hideNavigation: { type: Array, default: () => [] },
    internalModelValue: { type: [Date, Array], default: null },
    autoApplyMonth: { type: Boolean, default: false }
  },
  emits: ["update:model-value", "selected", "toggle", "reset-flow"],
  setup(e2, { expose: n, emit: a3 }) {
    const t2 = e2, { setSelectionGrid: i2, buildMultiLevelMatrix: v, setMonthPicker: m3 } = ut(), { hideNavigationButtons: T2 } = xe(t2), Y2 = ref(false), _ = ref(null), W = ref(null), C = ref([]), c2 = ref(), g = ref(null), Q2 = ref(0), U = ref(null);
    onBeforeUpdate(() => {
      _.value = null;
    }), onMounted(() => {
      var D2;
      nextTick().then(() => ce()), V(), x2(true), (D2 = _.value) == null || D2.focus({ preventScroll: true });
    }), onUnmounted(() => x2(false));
    const x2 = (D2) => {
      var y3;
      t2.arrowNavigation && ((y3 = t2.headerRefs) != null && y3.length ? m3(D2) : i2(D2));
    }, V = () => {
      const D2 = Ae(W);
      D2 && (t2.textInput || D2.focus({ preventScroll: true }), Y2.value = D2.clientHeight < D2.scrollHeight);
    }, F = computed(
      () => ({
        dp__overlay: true
      })
    ), ae = computed(() => ({
      dp__overlay_col: true
    })), oe = (D2) => t2.monthPicker && !t2.autoApplyMonth ? ke(
      t2.internalModelValue,
      setYear(setMonth(/* @__PURE__ */ new Date(), D2.value), t2.year)
    ) : t2.skipActive ? false : D2.value === t2.modelValue, B2 = computed(() => t2.items.map((D2) => D2.filter((y3) => y3).map((y3) => {
      var S3, b2, Z;
      const d3 = t2.disabledValues.some((r) => r === y3.value) || ne(y3.value), u2 = (S3 = t2.multiModelValue) != null && S3.length ? (b2 = t2.multiModelValue) == null ? void 0 : b2.some(
        (r) => ke(
          r,
          setYear(
            t2.monthPicker ? setMonth(/* @__PURE__ */ new Date(), y3.value) : /* @__PURE__ */ new Date(),
            t2.monthPicker ? t2.year : y3.value
          )
        )
      ) : oe(y3);
      return {
        ...y3,
        className: {
          dp__overlay_cell_active: u2,
          dp__overlay_cell: !u2,
          dp__overlay_cell_disabled: d3,
          dp__overlay_cell_active_disabled: d3 && u2,
          dp__overlay_cell_pad: true,
          dp__cell_in_between: (Z = t2.multiModelValue) != null && Z.length && t2.skipActive ? O2(y3.value) : false
        }
      };
    }))), G2 = computed(
      () => ({
        dp__button: true,
        dp__overlay_action: true,
        dp__over_action_scroll: Y2.value,
        dp__button_bottom: t2.autoApply
      })
    ), J = computed(() => {
      var D2, y3;
      return {
        dp__overlay_container: true,
        dp__container_flex: ((D2 = t2.items) == null ? void 0 : D2.length) <= 6,
        dp__container_block: ((y3 = t2.items) == null ? void 0 : y3.length) > 6
      };
    }), ne = (D2) => {
      const y3 = t2.maxValue || t2.maxValue === 0, d3 = t2.minValue || t2.minValue === 0;
      return !y3 && !d3 ? false : y3 && d3 ? +D2 > +t2.maxValue || +D2 < +t2.minValue : y3 ? +D2 > +t2.maxValue : d3 ? +D2 < +t2.minValue : false;
    }, ce = () => {
      const D2 = Ae(_), y3 = Ae(W), d3 = Ae(g), u2 = Ae(U), S3 = d3 ? d3.getBoundingClientRect().height : 0;
      y3 && (Q2.value = y3.getBoundingClientRect().height - S3), D2 && u2 && (u2.scrollTop = D2.offsetTop - u2.offsetTop - (Q2.value / 2 - D2.getBoundingClientRect().height) - S3);
    }, ye = (D2) => {
      !t2.disabledValues.some((y3) => y3 === D2) && !ne(D2) && (a3("update:model-value", D2), a3("selected"));
    }, O2 = (D2) => {
      const y3 = t2.monthPicker ? t2.year : D2;
      return ea(
        t2.multiModelValue,
        setYear(
          t2.monthPicker ? setMonth(/* @__PURE__ */ new Date(), c2.value || 0) : /* @__PURE__ */ new Date(),
          t2.monthPicker ? y3 : c2.value || y3
        ),
        setYear(t2.monthPicker ? setMonth(/* @__PURE__ */ new Date(), D2) : /* @__PURE__ */ new Date(), y3)
      );
    }, w2 = () => {
      a3("toggle"), a3("reset-flow");
    }, f = () => {
      t2.escClose && w2();
    }, N = (D2, y3, d3, u2) => {
      D2 && (y3.value === +t2.modelValue && !t2.disabledValues.includes(y3.value) && (_.value = D2), t2.arrowNavigation && (Array.isArray(C.value[d3]) ? C.value[d3][u2] = D2 : C.value[d3] = [D2], I2()));
    }, I2 = () => {
      var y3, d3;
      const D2 = (y3 = t2.headerRefs) != null && y3.length ? [t2.headerRefs].concat(C.value) : C.value.concat([t2.skipButtonRef ? [] : [g.value]]);
      v(_e(D2), (d3 = t2.headerRefs) != null && d3.length ? "monthPicker" : "selectionGrid");
    }, E2 = (D2) => {
      t2.arrowNavigation || D2.stopImmediatePropagation();
    };
    return n({ focusGrid: V }), (D2, y3) => {
      var d3;
      return openBlock(), createElementBlock("div", {
        ref_key: "gridWrapRef",
        ref: W,
        class: normalizeClass(F.value),
        role: "dialog",
        tabindex: "0",
        onKeydown: [
          withKeys(f, ["esc"]),
          y3[0] || (y3[0] = withKeys((u2) => E2(u2), ["left"])),
          y3[1] || (y3[1] = withKeys((u2) => E2(u2), ["up"])),
          y3[2] || (y3[2] = withKeys((u2) => E2(u2), ["down"])),
          y3[3] || (y3[3] = withKeys((u2) => E2(u2), ["right"]))
        ]
      }, [
        createBaseVNode("div", {
          class: normalizeClass(J.value),
          ref_key: "containerRef",
          ref: U,
          role: "grid",
          style: normalizeStyle({ height: `${Q2.value}px` })
        }, [
          createBaseVNode("div", Ll, [
            renderSlot(D2.$slots, "header")
          ]),
          D2.$slots.overlay ? renderSlot(D2.$slots, "overlay", { key: 0 }) : (openBlock(true), createElementBlock(Fragment, { key: 1 }, renderList(B2.value, (u2, S3) => (openBlock(), createElementBlock("div", {
            class: normalizeClass(["dp__overlay_row", { dp__flex_row: B2.value.length >= 3 }]),
            key: S3,
            role: "row"
          }, [
            (openBlock(true), createElementBlock(Fragment, null, renderList(u2, (b2, Z) => (openBlock(), createElementBlock("div", {
              role: "gridcell",
              class: normalizeClass(ae.value),
              key: b2.value,
              "aria-selected": b2.value === e2.modelValue && !e2.disabledValues.includes(b2.value),
              "aria-disabled": b2.className.dp__overlay_cell_disabled,
              ref_for: true,
              ref: (r) => N(r, b2, S3, Z),
              tabindex: "0",
              onClick: (r) => ye(b2.value),
              onKeydown: [
                withKeys((r) => ye(b2.value), ["enter"]),
                withKeys((r) => ye(b2.value), ["space"])
              ],
              onMouseover: (r) => c2.value = b2.value
            }, [
              createBaseVNode("div", {
                class: normalizeClass(b2.className)
              }, [
                D2.$slots.item ? renderSlot(D2.$slots, "item", {
                  key: 0,
                  item: b2
                }) : createCommentVNode("", true),
                D2.$slots.item ? createCommentVNode("", true) : (openBlock(), createElementBlock(Fragment, { key: 1 }, [
                  createTextVNode(toDisplayString(b2.text), 1)
                ], 64))
              ], 2)
            ], 42, Fl))), 128))
          ], 2))), 128))
        ], 6),
        D2.$slots["button-icon"] ? withDirectives((openBlock(), createElementBlock("div", {
          key: 0,
          role: "button",
          "aria-label": (d3 = e2.ariaLabels) == null ? void 0 : d3.toggleOverlay,
          class: normalizeClass(G2.value),
          tabindex: "0",
          ref_key: "toggleButton",
          ref: g,
          onClick: w2,
          onKeydown: [
            withKeys(w2, ["enter"]),
            withKeys(w2, ["tab"])
          ]
        }, [
          renderSlot(D2.$slots, "button-icon")
        ], 42, Ul)), [
          [vShow, !unref(T2)(e2.type)]
        ]) : createCommentVNode("", true)
      ], 42, El);
    };
  }
});
var Wl = ["aria-label"];
var zn = defineComponent({
  __name: "RegularPicker",
  props: {
    ariaLabel: { type: String, default: "" },
    showSelectionGrid: { type: Boolean, default: false },
    modelValue: { type: Number, default: null },
    items: { type: Array, default: () => [] },
    disabledValues: { type: Array, default: () => [] },
    minValue: { type: Number, default: null },
    maxValue: { type: Number, default: null },
    slotName: { type: String, default: "" },
    overlaySlot: { type: String, default: "" },
    headerRefs: { type: Array, default: () => [] },
    escClose: { type: Boolean, default: true },
    type: { type: String, default: null },
    transitions: { type: [Object, Boolean], default: false },
    arrowNavigation: { type: Boolean, default: false },
    autoApply: { type: Boolean, default: false },
    textInput: { type: Boolean, default: false },
    ariaLabels: { type: Object, default: () => ({}) },
    hideNavigation: { type: Array, default: () => [] }
  },
  emits: ["update:model-value", "toggle", "set-ref"],
  setup(e2, { emit: n }) {
    const a3 = e2, { transitionName: t2, showTransition: i2 } = jt(a3.transitions), v = ref(null);
    return onMounted(() => n("set-ref", v)), (m3, T2) => (openBlock(), createElementBlock(Fragment, null, [
      createBaseVNode("button", {
        type: "button",
        class: "dp__btn dp__month_year_select",
        onClick: T2[0] || (T2[0] = (Y2) => m3.$emit("toggle")),
        onKeydown: [
          T2[1] || (T2[1] = withKeys(withModifiers((Y2) => m3.$emit("toggle"), ["prevent"]), ["enter"])),
          T2[2] || (T2[2] = withKeys(withModifiers((Y2) => m3.$emit("toggle"), ["prevent"]), ["space"]))
        ],
        "aria-label": e2.ariaLabel,
        tabindex: "0",
        ref_key: "elRef",
        ref: v
      }, [
        renderSlot(m3.$slots, "default")
      ], 40, Wl),
      createVNode(Transition, {
        name: unref(t2)(e2.showSelectionGrid),
        css: unref(i2)
      }, {
        default: withCtx(() => [
          e2.showSelectionGrid ? (openBlock(), createBlock(Rt, mergeProps({ key: 0 }, {
            modelValue: e2.modelValue,
            items: e2.items,
            disabledValues: e2.disabledValues,
            minValue: e2.minValue,
            maxValue: e2.maxValue,
            escClose: e2.escClose,
            type: e2.type,
            arrowNavigation: e2.arrowNavigation,
            textInput: e2.textInput,
            autoApply: e2.autoApply,
            ariaLabels: e2.ariaLabels,
            hideNavigation: e2.hideNavigation
          }, {
            "header-refs": [],
            "onUpdate:modelValue": T2[3] || (T2[3] = (Y2) => m3.$emit("update:model-value", Y2)),
            onToggle: T2[4] || (T2[4] = (Y2) => m3.$emit("toggle"))
          }), createSlots({
            "button-icon": withCtx(() => [
              m3.$slots["calendar-icon"] ? renderSlot(m3.$slots, "calendar-icon", { key: 0 }) : createCommentVNode("", true),
              m3.$slots["calendar-icon"] ? createCommentVNode("", true) : (openBlock(), createBlock(unref(Kt), { key: 1 }))
            ]),
            _: 2
          }, [
            m3.$slots[e2.slotName] ? {
              name: "item",
              fn: withCtx(({ item: Y2 }) => [
                renderSlot(m3.$slots, e2.slotName, { item: Y2 })
              ]),
              key: "0"
            } : void 0,
            m3.$slots[e2.overlaySlot] ? {
              name: "overlay",
              fn: withCtx(() => [
                renderSlot(m3.$slots, e2.overlaySlot)
              ]),
              key: "1"
            } : void 0,
            m3.$slots[`${e2.overlaySlot}-header`] ? {
              name: "header",
              fn: withCtx(() => [
                renderSlot(m3.$slots, `${e2.overlaySlot}-header`)
              ]),
              key: "2"
            } : void 0
          ]), 1040)) : createCommentVNode("", true)
        ]),
        _: 3
      }, 8, ["name", "css"])
    ], 64));
  }
});
var Hl = { class: "dp__month_year_row" };
var xl = { class: "dp__month_picker_header" };
var zl = ["aria-label"];
var Kl = ["aria-label"];
var jl = ["aria-label"];
var Gl = defineComponent({
  __name: "MonthYearPicker",
  props: {
    month: { type: Number, default: 0 },
    year: { type: Number, default: 0 },
    instance: { type: Number, default: 0 },
    years: { type: Array, default: () => [] },
    months: { type: Array, default: () => [] },
    internalModelValue: { type: [Date, Array], default: null },
    ...dt
  },
  emits: ["update-month-year", "month-year-select", "mount", "reset-flow", "overlay-closed"],
  setup(e2, { expose: n, emit: a3 }) {
    const t2 = e2, { defaults: i2 } = xe(t2), { transitionName: v, showTransition: m3 } = jt(i2.value.transitions), { buildMatrix: T2 } = ut(), { handleMonthYearChange: Y2, isDisabled: _, updateMonthYear: W } = gl(t2, a3), C = ref(false), c2 = ref(false), g = ref([null, null, null, null]), Q2 = ref(null), U = ref(null), x2 = ref(null);
    onMounted(() => {
      a3("mount");
    });
    const V = (o) => ({
      get: () => t2[o],
      set: (l) => {
        const M3 = o === "month" ? "year" : "month";
        a3("update-month-year", { [o]: l, [M3]: t2[M3] }), a3("month-year-select", o === "year"), o === "month" ? u2(true) : S3(true);
      }
    }), F = computed(V("month")), ae = computed(V("year")), oe = (o) => {
      const l = getYear(A(o));
      return t2.year === l;
    }, B2 = computed(() => t2.monthPicker ? Array.isArray(t2.disabledDates) ? t2.disabledDates.map((o) => A(o)).filter((o) => oe(o)).map((o) => getMonth(o)) : [] : []), G2 = computed(() => (o) => {
      const l = o === "month";
      return {
        showSelectionGrid: (l ? C : c2).value,
        items: (l ? I2 : E2).value,
        disabledValues: i2.value.filters[l ? "months" : "years"].concat(B2.value),
        minValue: (l ? ye : ne).value,
        maxValue: (l ? O2 : ce).value,
        headerRefs: l && t2.monthPicker ? [Q2.value, U.value, x2.value] : [],
        escClose: t2.escClose,
        transitions: i2.value.transitions,
        ariaLabels: i2.value.ariaLabels,
        textInput: t2.textInput,
        autoApply: t2.autoApply,
        arrowNavigation: t2.arrowNavigation,
        hideNavigation: t2.hideNavigation
      };
    }), J = computed(() => (o) => ({
      month: t2.month,
      year: t2.year,
      items: o === "month" ? t2.months : t2.years,
      instance: t2.instance,
      updateMonthYear: W,
      toggle: o === "month" ? u2 : S3
    })), ne = computed(() => t2.minDate ? getYear(A(t2.minDate)) : null), ce = computed(() => t2.maxDate ? getYear(A(t2.maxDate)) : null), ye = computed(() => {
      if (t2.minDate && ne.value) {
        if (ne.value > t2.year)
          return 12;
        if (ne.value === t2.year)
          return getMonth(A(t2.minDate));
      }
      return null;
    }), O2 = computed(() => t2.maxDate && ce.value ? ce.value < t2.year ? -1 : ce.value === t2.year ? getMonth(A(t2.maxDate)) : null : null), w2 = computed(() => (t2.range || t2.multiDates) && t2.internalModelValue && (t2.monthPicker || t2.yearPicker) ? t2.internalModelValue : []), f = (o) => {
      const l = [], M3 = (re) => re;
      for (let re = 0; re < o.length; re += 3) {
        const se = [o[re], o[re + 1], o[re + 2]];
        l.push(M3(se));
      }
      return l;
    }, N = computed(() => {
      const o = t2.months.find((l) => l.value === t2.month);
      return o || { text: "", value: 0 };
    }), I2 = computed(() => f(t2.months)), E2 = computed(() => f(t2.years)), D2 = computed(() => i2.value.multiCalendars ? t2.multiCalendarsSolo ? true : t2.instance === 0 : true), y3 = computed(() => i2.value.multiCalendars ? t2.multiCalendarsSolo ? true : t2.instance === i2.value.multiCalendars - 1 : true), d3 = (o, l) => {
      l !== void 0 ? o.value = l : o.value = !o.value;
    }, u2 = (o = false, l) => {
      b2(o), d3(C, l), C.value || a3("overlay-closed");
    }, S3 = (o = false, l) => {
      b2(o), d3(c2, l), c2.value || a3("overlay-closed");
    }, b2 = (o) => {
      o || a3("reset-flow");
    }, Z = (o = false) => {
      _.value(o) || a3("update-month-year", {
        year: o ? t2.year + 1 : t2.year - 1,
        month: t2.month,
        fromNav: true
      });
    }, r = (o, l) => {
      t2.arrowNavigation && (g.value[l] = Ae(o), T2(g.value, "monthYear"));
    };
    return n({
      toggleMonthPicker: u2,
      toggleYearPicker: S3,
      handleMonthYearChange: Y2
    }), (o, l) => {
      var M3, re, se, Pe, Se;
      return openBlock(), createElementBlock("div", Hl, [
        o.$slots["month-year"] ? renderSlot(o.$slots, "month-year", normalizeProps(mergeProps({ key: 0 }, { month: e2.month, year: e2.year, months: e2.months, years: e2.years, updateMonthYear: unref(W), handleMonthYearChange: unref(Y2), instance: e2.instance }))) : (openBlock(), createElementBlock(Fragment, { key: 1 }, [
          !o.monthPicker && !o.yearPicker ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
            D2.value && !o.vertical ? (openBlock(), createBlock(un, {
              key: 0,
              "aria-label": (M3 = unref(i2).ariaLabels) == null ? void 0 : M3.prevMonth,
              disabled: unref(_)(false),
              onActivate: l[0] || (l[0] = (ee) => unref(Y2)(false)),
              onSetRef: l[1] || (l[1] = (ee) => r(ee, 0))
            }, {
              default: withCtx(() => [
                o.$slots["arrow-left"] ? renderSlot(o.$slots, "arrow-left", { key: 0 }) : createCommentVNode("", true),
                o.$slots["arrow-left"] ? createCommentVNode("", true) : (openBlock(), createBlock(unref(Pn), { key: 1 }))
              ]),
              _: 3
            }, 8, ["aria-label", "disabled"])) : createCommentVNode("", true),
            createBaseVNode("div", {
              class: normalizeClass(["dp__month_year_wrap", {
                dp__year_disable_select: t2.disableYearSelect
              }])
            }, [
              createVNode(zn, mergeProps({
                type: "month",
                "slot-name": "month-overlay-val",
                "overlay-slot": "overlay-month",
                "aria-label": (re = unref(i2).ariaLabels) == null ? void 0 : re.openMonthsOverlay,
                modelValue: F.value,
                "onUpdate:modelValue": l[2] || (l[2] = (ee) => F.value = ee)
              }, G2.value("month"), {
                onToggle: u2,
                onSetRef: l[3] || (l[3] = (ee) => r(ee, 1))
              }), createSlots({
                default: withCtx(() => [
                  o.$slots.month ? renderSlot(o.$slots, "month", normalizeProps(mergeProps({ key: 0 }, N.value))) : createCommentVNode("", true),
                  o.$slots.month ? createCommentVNode("", true) : (openBlock(), createElementBlock(Fragment, { key: 1 }, [
                    createTextVNode(toDisplayString(N.value.text), 1)
                  ], 64))
                ]),
                _: 2
              }, [
                o.$slots["calendar-icon"] ? {
                  name: "calendar-icon",
                  fn: withCtx(() => [
                    renderSlot(o.$slots, "calendar-icon")
                  ]),
                  key: "0"
                } : void 0,
                o.$slots["month-overlay-value"] ? {
                  name: "month-overlay-val",
                  fn: withCtx(({ item: ee }) => [
                    renderSlot(o.$slots, "month-overlay-value", {
                      text: ee.text,
                      value: ee.value
                    })
                  ]),
                  key: "1"
                } : void 0,
                o.$slots["month-overlay"] ? {
                  name: "overlay-month",
                  fn: withCtx(() => [
                    renderSlot(o.$slots, "month-overlay", normalizeProps(guardReactiveProps(J.value("month"))))
                  ]),
                  key: "2"
                } : void 0,
                o.$slots["month-overlay-header"] ? {
                  name: "overlay-month-header",
                  fn: withCtx(() => [
                    renderSlot(o.$slots, "month-overlay-header", { toggle: u2 })
                  ]),
                  key: "3"
                } : void 0
              ]), 1040, ["aria-label", "modelValue"]),
              t2.disableYearSelect ? createCommentVNode("", true) : (openBlock(), createBlock(zn, mergeProps({
                key: 0,
                type: "year",
                "slot-name": "year-overlay-val",
                "overlay-slot": "overlay-year",
                "aria-label": (se = unref(i2).ariaLabels) == null ? void 0 : se.openYearsOverlay,
                modelValue: ae.value,
                "onUpdate:modelValue": l[4] || (l[4] = (ee) => ae.value = ee)
              }, G2.value("year"), {
                onToggle: S3,
                onSetRef: l[5] || (l[5] = (ee) => r(ee, 2))
              }), createSlots({
                default: withCtx(() => [
                  o.$slots.year ? renderSlot(o.$slots, "year", {
                    key: 0,
                    year: e2.year
                  }) : createCommentVNode("", true),
                  o.$slots.year ? createCommentVNode("", true) : (openBlock(), createElementBlock(Fragment, { key: 1 }, [
                    createTextVNode(toDisplayString(e2.year), 1)
                  ], 64))
                ]),
                _: 2
              }, [
                o.$slots["calendar-icon"] ? {
                  name: "calendar-icon",
                  fn: withCtx(() => [
                    renderSlot(o.$slots, "calendar-icon")
                  ]),
                  key: "0"
                } : void 0,
                o.$slots["year-overlay-value"] ? {
                  name: "year-overlay-val",
                  fn: withCtx(({ item: ee }) => [
                    renderSlot(o.$slots, "year-overlay-value", {
                      text: ee.text,
                      value: ee.value
                    })
                  ]),
                  key: "1"
                } : void 0,
                o.$slots["year-overlay"] ? {
                  name: "overlay-year",
                  fn: withCtx(() => [
                    renderSlot(o.$slots, "year-overlay", normalizeProps(guardReactiveProps(J.value("year"))))
                  ]),
                  key: "2"
                } : void 0,
                o.$slots["year-overlay-header"] ? {
                  name: "overlay-year-header",
                  fn: withCtx(() => [
                    renderSlot(o.$slots, "year-overlay-header", { toggle: S3 })
                  ]),
                  key: "3"
                } : void 0
              ]), 1040, ["aria-label", "modelValue"]))
            ], 2),
            D2.value && o.vertical ? (openBlock(), createBlock(un, {
              key: 1,
              "aria-label": (Pe = unref(i2).ariaLabels) == null ? void 0 : Pe.prevMonth,
              disabled: unref(_)(false),
              onActivate: l[6] || (l[6] = (ee) => unref(Y2)(false))
            }, {
              default: withCtx(() => [
                o.$slots["arrow-up"] ? renderSlot(o.$slots, "arrow-up", { key: 0 }) : createCommentVNode("", true),
                o.$slots["arrow-up"] ? createCommentVNode("", true) : (openBlock(), createBlock(unref(Jn), { key: 1 }))
              ]),
              _: 3
            }, 8, ["aria-label", "disabled"])) : createCommentVNode("", true),
            y3.value ? (openBlock(), createBlock(un, {
              key: 2,
              ref: "rightIcon",
              disabled: unref(_)(true),
              "aria-label": (Se = unref(i2).ariaLabels) == null ? void 0 : Se.nextMonth,
              onActivate: l[7] || (l[7] = (ee) => unref(Y2)(true)),
              onSetRef: l[8] || (l[8] = (ee) => r(ee, 3))
            }, {
              default: withCtx(() => [
                o.$slots[o.vertical ? "arrow-down" : "arrow-right"] ? renderSlot(o.$slots, o.vertical ? "arrow-down" : "arrow-right", { key: 0 }) : createCommentVNode("", true),
                o.$slots[o.vertical ? "arrow-down" : "arrow-right"] ? createCommentVNode("", true) : (openBlock(), createBlock(resolveDynamicComponent(o.vertical ? unref(Qn) : unref(_n)), { key: 1 }))
              ]),
              _: 3
            }, 8, ["disabled", "aria-label"])) : createCommentVNode("", true)
          ], 64)) : createCommentVNode("", true),
          o.monthPicker ? (openBlock(), createBlock(Rt, mergeProps({ key: 1 }, G2.value("month"), {
            "skip-active": o.range,
            "internal-model-value": e2.internalModelValue,
            year: e2.year,
            "auto-apply-month": o.autoApplyMonth,
            "multi-model-value": w2.value,
            "month-picker": "",
            modelValue: F.value,
            "onUpdate:modelValue": l[17] || (l[17] = (ee) => F.value = ee),
            onToggle: u2,
            onSelected: l[18] || (l[18] = (ee) => o.$emit("overlay-closed"))
          }), createSlots({
            header: withCtx(() => {
              var ee, Ue, Ie;
              return [
                createBaseVNode("div", xl, [
                  createBaseVNode("div", {
                    class: "dp__month_year_col_nav",
                    tabindex: "0",
                    ref_key: "mpPrevIconRef",
                    ref: Q2,
                    onClick: l[9] || (l[9] = (Te) => Z(false)),
                    onKeydown: l[10] || (l[10] = withKeys((Te) => Z(false), ["enter"]))
                  }, [
                    createBaseVNode("div", {
                      class: normalizeClass(["dp__inner_nav", { dp__inner_nav_disabled: unref(_)(false) }]),
                      role: "button",
                      "aria-label": (ee = unref(i2).ariaLabels) == null ? void 0 : ee.prevMonth
                    }, [
                      o.$slots["arrow-left"] ? renderSlot(o.$slots, "arrow-left", { key: 0 }) : createCommentVNode("", true),
                      o.$slots["arrow-left"] ? createCommentVNode("", true) : (openBlock(), createBlock(unref(Pn), { key: 1 }))
                    ], 10, zl)
                  ], 544),
                  createBaseVNode("div", {
                    class: "dp__pointer",
                    role: "button",
                    ref_key: "mpYearButtonRef",
                    ref: U,
                    "aria-label": (Ue = unref(i2).ariaLabels) == null ? void 0 : Ue.openYearsOverlay,
                    tabindex: "0",
                    onClick: l[11] || (l[11] = () => S3(false)),
                    onKeydown: l[12] || (l[12] = withKeys(() => S3(false), ["enter"]))
                  }, [
                    o.$slots.year ? renderSlot(o.$slots, "year", {
                      key: 0,
                      year: e2.year
                    }) : createCommentVNode("", true),
                    o.$slots.year ? createCommentVNode("", true) : (openBlock(), createElementBlock(Fragment, { key: 1 }, [
                      createTextVNode(toDisplayString(e2.year), 1)
                    ], 64))
                  ], 40, Kl),
                  createBaseVNode("div", {
                    class: "dp__month_year_col_nav",
                    tabindex: "0",
                    ref_key: "mpNextIconRef",
                    ref: x2,
                    onClick: l[13] || (l[13] = (Te) => Z(true)),
                    onKeydown: l[14] || (l[14] = withKeys((Te) => Z(true), ["enter"]))
                  }, [
                    createBaseVNode("div", {
                      class: normalizeClass(["dp__inner_nav", { dp__inner_nav_disabled: unref(_)(true) }]),
                      role: "button",
                      "aria-label": (Ie = unref(i2).ariaLabels) == null ? void 0 : Ie.nextMonth
                    }, [
                      o.$slots["arrow-right"] ? renderSlot(o.$slots, "arrow-right", { key: 0 }) : createCommentVNode("", true),
                      o.$slots["arrow-right"] ? createCommentVNode("", true) : (openBlock(), createBlock(unref(_n), { key: 1 }))
                    ], 10, jl)
                  ], 544)
                ]),
                createVNode(Transition, {
                  name: unref(v)(c2.value),
                  css: unref(m3)
                }, {
                  default: withCtx(() => [
                    c2.value ? (openBlock(), createBlock(Rt, mergeProps({ key: 0 }, G2.value("year"), {
                      modelValue: ae.value,
                      "onUpdate:modelValue": l[15] || (l[15] = (Te) => ae.value = Te),
                      onToggle: S3,
                      onSelected: l[16] || (l[16] = (Te) => o.$emit("overlay-closed"))
                    }), createSlots({
                      "button-icon": withCtx(() => [
                        o.$slots["calendar-icon"] ? renderSlot(o.$slots, "calendar-icon", { key: 0 }) : createCommentVNode("", true),
                        o.$slots["calendar-icon"] ? createCommentVNode("", true) : (openBlock(), createBlock(unref(Kt), { key: 1 }))
                      ]),
                      _: 2
                    }, [
                      o.$slots["year-overlay-value"] ? {
                        name: "item",
                        fn: withCtx(({ item: Te }) => [
                          renderSlot(o.$slots, "year-overlay-value", {
                            text: Te.text,
                            value: Te.value
                          })
                        ]),
                        key: "0"
                      } : void 0
                    ]), 1040, ["modelValue"])) : createCommentVNode("", true)
                  ]),
                  _: 3
                }, 8, ["name", "css"])
              ];
            }),
            _: 2
          }, [
            o.$slots["month-overlay-value"] ? {
              name: "item",
              fn: withCtx(({ item: ee }) => [
                renderSlot(o.$slots, "month-overlay-value", {
                  text: ee.text,
                  value: ee.value
                })
              ]),
              key: "0"
            } : void 0
          ]), 1040, ["skip-active", "internal-model-value", "year", "auto-apply-month", "multi-model-value", "modelValue"])) : createCommentVNode("", true),
          o.yearPicker ? (openBlock(), createBlock(Rt, mergeProps({ key: 2 }, G2.value("year"), {
            modelValue: ae.value,
            "onUpdate:modelValue": l[19] || (l[19] = (ee) => ae.value = ee),
            "multi-model-value": w2.value,
            "skip-active": o.range,
            "skip-button-ref": "",
            "year-picker": "",
            onToggle: S3,
            onSelected: l[20] || (l[20] = (ee) => o.$emit("overlay-closed"))
          }), createSlots({ _: 2 }, [
            o.$slots["year-overlay-value"] ? {
              name: "item",
              fn: withCtx(({ item: ee }) => [
                renderSlot(o.$slots, "year-overlay-value", {
                  text: ee.text,
                  value: ee.value
                })
              ]),
              key: "0"
            } : void 0
          ]), 1040, ["modelValue", "multi-model-value", "skip-active"])) : createCommentVNode("", true)
        ], 64))
      ]);
    };
  }
});
var Zl = {
  key: 0,
  class: "dp__time_input"
};
var ql = ["aria-label", "onKeydown", "onClick"];
var Xl = createBaseVNode("span", { class: "dp__tp_inline_btn_bar dp__tp_btn_in_l" }, null, -1);
var Jl = createBaseVNode("span", { class: "dp__tp_inline_btn_bar dp__tp_btn_in_r" }, null, -1);
var Ql = ["aria-label", "onKeydown", "onClick"];
var er = ["aria-label", "onKeydown", "onClick"];
var tr = createBaseVNode("span", { class: "dp__tp_inline_btn_bar dp__tp_btn_in_l" }, null, -1);
var nr = createBaseVNode("span", { class: "dp__tp_inline_btn_bar dp__tp_btn_in_r" }, null, -1);
var ar = { key: 0 };
var lr = ["aria-label", "onKeydown"];
var rr = defineComponent({
  __name: "TimeInput",
  props: {
    hours: { type: Number, default: 0 },
    minutes: { type: Number, default: 0 },
    seconds: { type: Number, default: 0 },
    closeTimePickerBtn: { type: Object, default: null },
    order: { type: Number, default: 0 },
    ...dt
  },
  emits: [
    "set-hours",
    "set-minutes",
    "update:hours",
    "update:minutes",
    "update:seconds",
    "reset-flow",
    "mounted",
    "overlay-closed",
    "am-pm-change"
  ],
  setup(e2, { expose: n, emit: a3 }) {
    const t2 = e2, { setTimePickerElements: i2, setTimePickerBackRef: v } = ut(), { defaults: m3 } = xe(t2), { transitionName: T2, showTransition: Y2 } = jt(m3.value.transitions), _ = reactive({
      hours: false,
      minutes: false,
      seconds: false
    }), W = ref("AM"), C = ref(null), c2 = ref([]);
    onMounted(() => {
      a3("mounted");
    });
    const g = (d3) => set(/* @__PURE__ */ new Date(), {
      hours: d3.hours,
      minutes: d3.minutes,
      seconds: t2.enableSeconds ? d3.seconds : 0,
      milliseconds: 0
    }), Q2 = computed(() => ({ hours: t2.hours, minutes: t2.minutes, seconds: t2.seconds })), U = computed(() => (d3) => !ne(+t2[d3] + +t2[`${d3}Increment`], d3)), x2 = computed(() => (d3) => !ne(+t2[d3] - +t2[`${d3}Increment`], d3)), V = (d3, u2) => add(set(A(), d3), u2), F = (d3, u2) => sub(set(A(), d3), u2), ae = computed(
      () => ({
        dp__time_col: true,
        dp__time_col_block: !t2.timePickerInline,
        dp__time_col_reg_block: !t2.enableSeconds && t2.is24 && !t2.timePickerInline,
        dp__time_col_reg_inline: !t2.enableSeconds && t2.is24 && t2.timePickerInline,
        dp__time_col_reg_with_button: !t2.enableSeconds && !t2.is24,
        dp__time_col_sec: t2.enableSeconds && t2.is24,
        dp__time_col_sec_with_button: t2.enableSeconds && !t2.is24
      })
    ), oe = computed(() => {
      const d3 = [{ type: "hours" }, { type: "", separator: true }, { type: "minutes" }];
      return t2.enableSeconds ? d3.concat([{ type: "", separator: true }, { type: "seconds" }]) : d3;
    }), B2 = computed(() => oe.value.filter((d3) => !d3.separator)), G2 = computed(() => (d3) => {
      if (d3 === "hours") {
        const u2 = N(+t2.hours);
        return { text: u2 < 10 ? `0${u2}` : `${u2}`, value: u2 };
      }
      return { text: t2[d3] < 10 ? `0${t2[d3]}` : `${t2[d3]}`, value: t2[d3] };
    }), J = (d3) => {
      const u2 = t2.is24 ? 24 : 12, S3 = d3 === "hours" ? u2 : 60, b2 = +t2[`${d3}GridIncrement`], Z = d3 === "hours" && !t2.is24 ? b2 : 0, r = [];
      for (let o = Z; o < S3; o += b2)
        r.push({ value: o, text: o < 10 ? `0${o}` : `${o}` });
      return d3 === "hours" && !t2.is24 && r.push({ value: 0, text: "12" }), Ja(r);
    }, ne = (d3, u2) => {
      const S3 = t2.minTime ? g(Qt(t2.minTime)) : null, b2 = t2.maxTime ? g(Qt(t2.maxTime)) : null, Z = g(Qt(Q2.value, u2, d3));
      return S3 && b2 ? (isBefore(Z, b2) || isEqual(Z, b2)) && (isAfter(Z, S3) || isEqual(Z, S3)) : S3 ? isAfter(Z, S3) || isEqual(Z, S3) : b2 ? isBefore(Z, b2) || isEqual(Z, b2) : true;
    }, ce = computed(() => (d3) => J(d3).flat().filter((S3) => rl(S3.value)).map((S3) => S3.value).filter((S3) => !ne(S3, d3))), ye = (d3) => t2[`no${d3[0].toUpperCase() + d3.slice(1)}Overlay`], O2 = (d3) => {
      ye(d3) || (_[d3] = !_[d3], _[d3] || a3("overlay-closed"));
    }, w2 = (d3) => d3 === "hours" ? getHours : d3 === "minutes" ? getMinutes : getSeconds, f = (d3, u2 = true) => {
      const S3 = u2 ? V : F, b2 = u2 ? +t2[`${d3}Increment`] : -+t2[`${d3}Increment`];
      ne(+t2[d3] + b2, d3) && a3(
        `update:${d3}`,
        w2(d3)(S3({ [d3]: +t2[d3] }, { [d3]: +t2[`${d3}Increment`] }))
      );
    }, N = (d3) => t2.is24 ? d3 : (d3 >= 12 ? W.value = "PM" : W.value = "AM", al(d3)), I2 = () => {
      W.value === "PM" ? (W.value = "AM", a3("update:hours", t2.hours - 12)) : (W.value = "PM", a3("update:hours", t2.hours + 12)), a3("am-pm-change", W.value);
    }, E2 = (d3) => {
      _[d3] = true;
    }, D2 = (d3, u2, S3) => {
      if (d3 && t2.arrowNavigation) {
        Array.isArray(c2.value[u2]) ? c2.value[u2][S3] = d3 : c2.value[u2] = [d3];
        const b2 = c2.value.reduce(
          (Z, r) => r.map((o, l) => [...Z[l] || [], r[l]]),
          []
        );
        v(t2.closeTimePickerBtn), C.value && (b2[1] = b2[1].concat(C.value)), i2(b2, t2.order);
      }
    }, y3 = (d3, u2) => d3 === "hours" && !t2.is24 ? a3(`update:${d3}`, W.value === "PM" ? u2 + 12 : u2) : a3(`update:${d3}`, u2);
    return n({ openChildCmp: E2 }), (d3, u2) => {
      var S3;
      return d3.disabled ? createCommentVNode("", true) : (openBlock(), createElementBlock("div", Zl, [
        (openBlock(true), createElementBlock(Fragment, null, renderList(oe.value, (b2, Z) => {
          var r, o, l;
          return openBlock(), createElementBlock("div", {
            key: Z,
            class: normalizeClass(ae.value)
          }, [
            b2.separator ? (openBlock(), createElementBlock(Fragment, { key: 0 }, [
              createTextVNode(" : ")
            ], 64)) : (openBlock(), createElementBlock(Fragment, { key: 1 }, [
              createBaseVNode("button", {
                type: "button",
                class: normalizeClass({
                  dp__btn: true,
                  dp__inc_dec_button: !t2.timePickerInline,
                  dp__inc_dec_button_inline: t2.timePickerInline,
                  dp__tp_inline_btn_top: t2.timePickerInline,
                  dp__inc_dec_button_disabled: U.value(b2.type)
                }),
                "aria-label": (r = unref(m3).ariaLabels) == null ? void 0 : r.incrementValue(b2.type),
                tabindex: "0",
                onKeydown: [
                  withKeys((M3) => f(b2.type), ["enter"]),
                  withKeys((M3) => f(b2.type), ["space"])
                ],
                onClick: (M3) => f(b2.type),
                ref_for: true,
                ref: (M3) => D2(M3, Z, 0)
              }, [
                t2.timePickerInline ? (openBlock(), createElementBlock(Fragment, { key: 1 }, [
                  Xl,
                  Jl
                ], 64)) : (openBlock(), createElementBlock(Fragment, { key: 0 }, [
                  d3.$slots["arrow-up"] ? renderSlot(d3.$slots, "arrow-up", { key: 0 }) : createCommentVNode("", true),
                  d3.$slots["arrow-up"] ? createCommentVNode("", true) : (openBlock(), createBlock(unref(Jn), { key: 1 }))
                ], 64))
              ], 42, ql),
              createBaseVNode("button", {
                type: "button",
                "aria-label": (o = unref(m3).ariaLabels) == null ? void 0 : o.openTpOverlay(b2.type),
                class: normalizeClass([
                  "dp__btn",
                  ye(b2.type) ? void 0 : {
                    dp__time_display: true,
                    dp__time_display_block: !t2.timePickerInline,
                    dp__time_display_inline: t2.timePickerInline
                  }
                ]),
                tabindex: "0",
                onKeydown: [
                  withKeys((M3) => O2(b2.type), ["enter"]),
                  withKeys((M3) => O2(b2.type), ["space"])
                ],
                onClick: (M3) => O2(b2.type),
                ref_for: true,
                ref: (M3) => D2(M3, Z, 1)
              }, [
                d3.$slots[b2.type] ? renderSlot(d3.$slots, b2.type, {
                  key: 0,
                  text: G2.value(b2.type).text,
                  value: G2.value(b2.type).value
                }) : createCommentVNode("", true),
                d3.$slots[b2.type] ? createCommentVNode("", true) : (openBlock(), createElementBlock(Fragment, { key: 1 }, [
                  createTextVNode(toDisplayString(G2.value(b2.type).text), 1)
                ], 64))
              ], 42, Ql),
              createBaseVNode("button", {
                type: "button",
                class: normalizeClass({
                  dp__btn: true,
                  dp__inc_dec_button: !t2.timePickerInline,
                  dp__inc_dec_button_inline: t2.timePickerInline,
                  dp__tp_inline_btn_bottom: t2.timePickerInline,
                  dp__inc_dec_button_disabled: x2.value(b2.type)
                }),
                "aria-label": (l = unref(m3).ariaLabels) == null ? void 0 : l.decrementValue(b2.type),
                tabindex: "0",
                onKeydown: [
                  withKeys((M3) => f(b2.type, false), ["enter"]),
                  withKeys((M3) => f(b2.type, false), ["space"])
                ],
                onClick: (M3) => f(b2.type, false),
                ref_for: true,
                ref: (M3) => D2(M3, Z, 2)
              }, [
                t2.timePickerInline ? (openBlock(), createElementBlock(Fragment, { key: 1 }, [
                  tr,
                  nr
                ], 64)) : (openBlock(), createElementBlock(Fragment, { key: 0 }, [
                  d3.$slots["arrow-down"] ? renderSlot(d3.$slots, "arrow-down", { key: 0 }) : createCommentVNode("", true),
                  d3.$slots["arrow-down"] ? createCommentVNode("", true) : (openBlock(), createBlock(unref(Qn), { key: 1 }))
                ], 64))
              ], 42, er)
            ], 64))
          ], 2);
        }), 128)),
        d3.is24 ? createCommentVNode("", true) : (openBlock(), createElementBlock("div", ar, [
          d3.$slots["am-pm-button"] ? renderSlot(d3.$slots, "am-pm-button", {
            key: 0,
            toggle: I2,
            value: W.value
          }) : createCommentVNode("", true),
          d3.$slots["am-pm-button"] ? createCommentVNode("", true) : (openBlock(), createElementBlock("button", {
            key: 1,
            ref_key: "amPmButton",
            ref: C,
            type: "button",
            class: "dp__pm_am_button",
            role: "button",
            "aria-label": (S3 = unref(m3).ariaLabels) == null ? void 0 : S3.amPmButton,
            tabindex: "0",
            onClick: I2,
            onKeydown: [
              withKeys(withModifiers(I2, ["prevent"]), ["enter"]),
              withKeys(withModifiers(I2, ["prevent"]), ["space"])
            ]
          }, toDisplayString(W.value), 41, lr))
        ])),
        (openBlock(true), createElementBlock(Fragment, null, renderList(B2.value, (b2, Z) => (openBlock(), createBlock(Transition, {
          key: Z,
          name: unref(T2)(_[b2.type]),
          css: unref(Y2)
        }, {
          default: withCtx(() => [
            _[b2.type] ? (openBlock(), createBlock(Rt, {
              key: 0,
              items: J(b2.type),
              "disabled-values": unref(m3).filters.times[b2.type].concat(ce.value(b2.type)),
              "esc-close": d3.escClose,
              "aria-labels": unref(m3).ariaLabels,
              "hide-navigation": d3.hideNavigation,
              "onUpdate:modelValue": (r) => y3(b2.type, r),
              onSelected: (r) => O2(b2.type),
              onToggle: (r) => O2(b2.type),
              onResetFlow: u2[0] || (u2[0] = (r) => d3.$emit("reset-flow")),
              type: b2.type
            }, createSlots({
              "button-icon": withCtx(() => [
                d3.$slots["clock-icon"] ? renderSlot(d3.$slots, "clock-icon", { key: 0 }) : createCommentVNode("", true),
                d3.$slots["clock-icon"] ? createCommentVNode("", true) : (openBlock(), createBlock(unref(Xn), { key: 1 }))
              ]),
              _: 2
            }, [
              d3.$slots[`${b2.type}-overlay-value`] ? {
                name: "item",
                fn: withCtx(({ item: r }) => [
                  renderSlot(d3.$slots, `${b2.type}-overlay-value`, {
                    text: r.text,
                    value: r.value
                  })
                ]),
                key: "0"
              } : void 0
            ]), 1032, ["items", "disabled-values", "esc-close", "aria-labels", "hide-navigation", "onUpdate:modelValue", "onSelected", "onToggle", "type"])) : createCommentVNode("", true)
          ]),
          _: 2
        }, 1032, ["name", "css"]))), 128))
      ]));
    };
  }
});
var or = ["aria-label"];
var sr = ["tabindex"];
var ir = ["aria-label"];
var ur = defineComponent({
  __name: "TimePicker",
  props: {
    hours: { type: [Number, Array], default: 0 },
    minutes: { type: [Number, Array], default: 0 },
    seconds: { type: [Number, Array], default: 0 },
    internalModelValue: { type: [Date, Array], default: null },
    ...dt
  },
  emits: [
    "update:hours",
    "update:minutes",
    "update:seconds",
    "mount",
    "reset-flow",
    "overlay-opened",
    "overlay-closed",
    "am-pm-change"
  ],
  setup(e2, { expose: n, emit: a3 }) {
    const t2 = e2, { buildMatrix: i2, setTimePicker: v } = ut(), m3 = useSlots(), { hideNavigationButtons: T2, defaults: Y2 } = xe(t2), { transitionName: _, showTransition: W } = jt(Y2.value.transitions), C = ref(null), c2 = ref(null), g = ref([]), Q2 = ref(null);
    onMounted(() => {
      a3("mount"), !t2.timePicker && t2.arrowNavigation ? i2([Ae(C.value)], "time") : v(true, t2.timePicker);
    });
    const U = computed(() => t2.range && t2.modelAuto ? ra(t2.internalModelValue) : true), x2 = ref(false), V = (O2) => ({
      hours: Array.isArray(t2.hours) ? t2.hours[O2] : t2.hours,
      minutes: Array.isArray(t2.minutes) ? t2.minutes[O2] : t2.minutes,
      seconds: Array.isArray(t2.seconds) ? t2.seconds[O2] : t2.seconds
    }), F = computed(() => {
      const O2 = [];
      if (t2.range)
        for (let w2 = 0; w2 < 2; w2++)
          O2.push(V(w2));
      else
        O2.push(V(0));
      return O2;
    }), ae = (O2, w2 = false, f = "") => {
      w2 || a3("reset-flow"), x2.value = O2, a3(O2 ? "overlay-opened" : "overlay-closed"), t2.arrowNavigation && v(O2), nextTick(() => {
        f !== "" && g.value[0] && g.value[0].openChildCmp(f);
      });
    }, oe = computed(() => ({
      dp__btn: true,
      dp__button: true,
      dp__button_bottom: t2.autoApply && !t2.keepActionRow
    })), B2 = ht(m3, "timePicker"), G2 = (O2, w2, f) => t2.range ? w2 === 0 ? [O2, F.value[1][f]] : [F.value[0][f], O2] : O2, J = (O2) => {
      a3("update:hours", O2);
    }, ne = (O2) => {
      a3("update:minutes", O2);
    }, ce = (O2) => {
      a3("update:seconds", O2);
    }, ye = () => {
      if (Q2.value) {
        const O2 = ol(Q2.value);
        O2 && O2.focus({ preventScroll: true });
      }
    };
    return n({ toggleTimePicker: ae }), (O2, w2) => {
      var f;
      return openBlock(), createElementBlock("div", null, [
        !O2.timePicker && !O2.timePickerInline ? withDirectives((openBlock(), createElementBlock("button", {
          key: 0,
          type: "button",
          class: normalizeClass(oe.value),
          "aria-label": (f = unref(Y2).ariaLabels) == null ? void 0 : f.openTimePicker,
          tabindex: "0",
          ref_key: "openTimePickerBtn",
          ref: C,
          onKeydown: [
            w2[0] || (w2[0] = withKeys((N) => ae(true), ["enter"])),
            w2[1] || (w2[1] = withKeys((N) => ae(true), ["space"]))
          ],
          onClick: w2[2] || (w2[2] = (N) => ae(true))
        }, [
          O2.$slots["clock-icon"] ? renderSlot(O2.$slots, "clock-icon", { key: 0 }) : createCommentVNode("", true),
          O2.$slots["clock-icon"] ? createCommentVNode("", true) : (openBlock(), createBlock(unref(Xn), { key: 1 }))
        ], 42, or)), [
          [vShow, !unref(T2)("time")]
        ]) : createCommentVNode("", true),
        createVNode(Transition, {
          name: unref(_)(x2.value),
          css: unref(W) && !O2.timePickerInline
        }, {
          default: withCtx(() => {
            var N;
            return [
              x2.value || O2.timePicker || O2.timePickerInline ? (openBlock(), createElementBlock("div", {
                key: 0,
                class: normalizeClass({ dp__overlay: !O2.timePickerInline }),
                ref_key: "overlayRef",
                ref: Q2,
                tabindex: O2.timePickerInline ? void 0 : 0
              }, [
                createBaseVNode("div", {
                  class: normalizeClass(
                    O2.timePickerInline ? "dp__time_picker_inline_container" : "dp__overlay_container dp__container_flex dp__time_picker_overlay_container"
                  ),
                  style: { display: "flex" }
                }, [
                  O2.$slots["time-picker-overlay"] ? renderSlot(O2.$slots, "time-picker-overlay", {
                    key: 0,
                    hours: e2.hours,
                    minutes: e2.minutes,
                    seconds: e2.seconds,
                    setHours: J,
                    setMinutes: ne,
                    setSeconds: ce
                  }) : createCommentVNode("", true),
                  O2.$slots["time-picker-overlay"] ? createCommentVNode("", true) : (openBlock(), createElementBlock("div", {
                    key: 1,
                    class: normalizeClass(O2.timePickerInline ? "dp__flex" : "dp__overlay_row dp__flex_row")
                  }, [
                    (openBlock(true), createElementBlock(Fragment, null, renderList(F.value, (I2, E2) => withDirectives((openBlock(), createBlock(rr, mergeProps({ key: E2 }, {
                      ...O2.$props,
                      order: E2,
                      hours: I2.hours,
                      minutes: I2.minutes,
                      seconds: I2.seconds,
                      closeTimePickerBtn: c2.value,
                      disabled: E2 === 0 ? O2.fixedStart : O2.fixedEnd
                    }, {
                      ref_for: true,
                      ref_key: "timeInputRefs",
                      ref: g,
                      "onUpdate:hours": (D2) => J(G2(D2, E2, "hours")),
                      "onUpdate:minutes": (D2) => ne(G2(D2, E2, "minutes")),
                      "onUpdate:seconds": (D2) => ce(G2(D2, E2, "seconds")),
                      onMounted: ye,
                      onOverlayClosed: ye,
                      onAmPmChange: w2[3] || (w2[3] = (D2) => O2.$emit("am-pm-change", D2))
                    }), createSlots({ _: 2 }, [
                      renderList(unref(B2), (D2, y3) => ({
                        name: D2,
                        fn: withCtx((d3) => [
                          renderSlot(O2.$slots, D2, normalizeProps(guardReactiveProps(d3)))
                        ])
                      }))
                    ]), 1040, ["onUpdate:hours", "onUpdate:minutes", "onUpdate:seconds"])), [
                      [vShow, E2 === 0 ? true : U.value]
                    ])), 128))
                  ], 2)),
                  !O2.timePicker && !O2.timePickerInline ? withDirectives((openBlock(), createElementBlock("button", {
                    key: 2,
                    type: "button",
                    ref_key: "closeTimePickerBtn",
                    ref: c2,
                    class: normalizeClass(oe.value),
                    "aria-label": (N = unref(Y2).ariaLabels) == null ? void 0 : N.closeTimePicker,
                    tabindex: "0",
                    onKeydown: [
                      w2[4] || (w2[4] = withKeys((I2) => ae(false), ["enter"])),
                      w2[5] || (w2[5] = withKeys((I2) => ae(false), ["space"]))
                    ],
                    onClick: w2[6] || (w2[6] = (I2) => ae(false))
                  }, [
                    O2.$slots["calendar-icon"] ? renderSlot(O2.$slots, "calendar-icon", { key: 0 }) : createCommentVNode("", true),
                    O2.$slots["calendar-icon"] ? createCommentVNode("", true) : (openBlock(), createBlock(unref(Kt), { key: 1 }))
                  ], 42, ir)), [
                    [vShow, !unref(T2)("time")]
                  ]) : createCommentVNode("", true)
                ], 2)
              ], 10, sr)) : createCommentVNode("", true)
            ];
          }),
          _: 3
        }, 8, ["name", "css"])
      ]);
    };
  }
});
var dr = (e2, n) => {
  const { isDisabled: a3, matchDate: t2, getWeekFromDate: i2, defaults: v } = xe(n), m3 = ref(null), T2 = ref(A()), Y2 = (u2) => {
    !u2.current && n.hideOffsetDates || (m3.value = u2.value);
  }, _ = () => {
    m3.value = null;
  }, W = (u2) => Array.isArray(e2.value) && n.range && e2.value[0] && m3.value ? u2 ? Fe(m3.value, e2.value[0]) : Ve(m3.value, e2.value[0]) : true, C = (u2, S3) => {
    const b2 = () => e2.value ? S3 ? e2.value[0] || null : e2.value[1] : null, Z = e2.value && Array.isArray(e2.value) ? b2() : null;
    return ke(A(u2.value), Z);
  }, c2 = (u2) => {
    const S3 = Array.isArray(e2.value) ? e2.value[0] : null;
    return u2 ? !Ve(m3.value || null, S3) : true;
  }, g = (u2, S3 = true) => (n.range || n.weekPicker) && Array.isArray(e2.value) && e2.value.length === 2 ? n.hideOffsetDates && !u2.current ? false : ke(A(u2.value), e2.value[S3 ? 0 : 1]) : n.range ? C(u2, S3) && c2(S3) || ke(u2.value, Array.isArray(e2.value) ? e2.value[0] : null) && W(S3) : false, Q2 = (u2, S3, b2) => Array.isArray(e2.value) && e2.value[0] && e2.value.length === 1 ? u2 ? false : b2 ? Fe(e2.value[0], S3.value) : Ve(e2.value[0], S3.value) : false, U = (u2) => !e2.value || n.hideOffsetDates && !u2.current ? false : n.range ? n.modelAuto && Array.isArray(e2.value) ? ke(u2.value, e2.value[0] ? e2.value[0] : T2.value) : false : n.multiDates && Array.isArray(e2.value) ? e2.value.some((S3) => ke(S3, u2.value)) : ke(u2.value, e2.value ? e2.value : T2.value), x2 = (u2) => {
    if (n.autoRange || n.weekPicker) {
      if (m3.value) {
        if (n.hideOffsetDates && !u2.current)
          return false;
        const S3 = addDays(m3.value, +n.autoRange), b2 = i2(A(m3.value));
        return n.weekPicker ? ke(b2[1], A(u2.value)) : ke(S3, A(u2.value));
      }
      return false;
    }
    return false;
  }, V = (u2) => {
    if (n.autoRange || n.weekPicker) {
      if (m3.value) {
        const S3 = addDays(m3.value, +n.autoRange);
        if (n.hideOffsetDates && !u2.current)
          return false;
        const b2 = i2(A(m3.value));
        return n.weekPicker ? Fe(u2.value, b2[0]) && Ve(u2.value, b2[1]) : Fe(u2.value, m3.value) && Ve(u2.value, S3);
      }
      return false;
    }
    return false;
  }, F = (u2) => {
    if (n.autoRange || n.weekPicker) {
      if (m3.value) {
        if (n.hideOffsetDates && !u2.current)
          return false;
        const S3 = i2(A(m3.value));
        return n.weekPicker ? ke(S3[0], u2.value) : ke(m3.value, u2.value);
      }
      return false;
    }
    return false;
  }, ae = (u2) => ea(e2.value, m3.value, u2.value), oe = () => n.modelAuto && Array.isArray(n.internalModelValue) ? !!n.internalModelValue[0] : false, B2 = () => n.modelAuto ? ra(n.internalModelValue) : true, G2 = (u2) => {
    if (Array.isArray(e2.value) && e2.value.length || n.weekPicker)
      return false;
    const S3 = n.range ? !g(u2) && !g(u2, false) : true;
    return !a3(u2.value) && !U(u2) && !(!u2.current && n.hideOffsetDates) && S3;
  }, J = (u2) => n.range ? n.modelAuto ? oe() && U(u2) : false : U(u2), ne = (u2) => {
    var S3;
    return n.highlight ? t2(
      u2.value,
      (S3 = n.arrMapValues) != null && S3.highlightedDates ? n.arrMapValues.highlightedDates : n.highlight
    ) : false;
  }, ce = (u2) => a3(u2.value) && n.highlightDisabledDays === false, ye = (u2) => n.highlightWeekDays && n.highlightWeekDays.includes(u2.value.getDay()), O2 = (u2) => (n.range || n.weekPicker) && (!(v.value.multiCalendars > 0) || u2.current) && B2() && !(!u2.current && n.hideOffsetDates) && !U(u2) ? ae(u2) : false, w2 = (u2) => {
    const { isRangeStart: S3, isRangeEnd: b2 } = I2(u2), Z = n.range ? S3 || b2 : false;
    return {
      dp__cell_offset: !u2.current,
      dp__pointer: !n.disabled && !(!u2.current && n.hideOffsetDates) && !a3(u2.value),
      dp__cell_disabled: a3(u2.value),
      dp__cell_highlight: !ce(u2) && (ne(u2) || ye(u2)) && !J(u2) && !Z,
      dp__cell_highlight_active: !ce(u2) && (ne(u2) || ye(u2)) && J(u2),
      dp__today: !n.noToday && ke(u2.value, T2.value) && u2.current
    };
  }, f = (u2) => ({
    dp__active_date: J(u2),
    dp__date_hover: G2(u2)
  }), N = (u2) => ({
    ...E2(u2),
    ...D2(u2),
    dp__range_between_week: O2(u2) && n.weekPicker
  }), I2 = (u2) => {
    const S3 = v.value.multiCalendars > 0 ? u2.current && g(u2) && B2() : g(u2) && B2(), b2 = v.value.multiCalendars > 0 ? u2.current && g(u2, false) && B2() : g(u2, false) && B2();
    return { isRangeStart: S3, isRangeEnd: b2 };
  }, E2 = (u2) => {
    const { isRangeStart: S3, isRangeEnd: b2 } = I2(u2);
    return {
      dp__range_start: S3,
      dp__range_end: b2,
      dp__range_between: O2(u2) && !n.weekPicker,
      dp__date_hover_start: Q2(G2(u2), u2, true),
      dp__date_hover_end: Q2(G2(u2), u2, false)
    };
  }, D2 = (u2) => ({
    ...E2(u2),
    dp__cell_auto_range: V(u2),
    dp__cell_auto_range_start: F(u2),
    dp__cell_auto_range_end: x2(u2)
  }), y3 = (u2) => n.range ? n.autoRange ? D2(u2) : n.modelAuto ? { ...f(u2), ...E2(u2) } : E2(u2) : n.weekPicker ? N(u2) : f(u2);
  return {
    setHoverDate: Y2,
    clearHoverDate: _,
    getDayClassData: (u2) => n.hideOffsetDates && !u2.current ? {} : {
      ...w2(u2),
      ...y3(u2),
      [n.dayClass ? n.dayClass(u2.value) : ""]: true,
      [n.calendarCellClassName]: !!n.calendarCellClassName
    }
  };
};
var cr = ["id", "onKeydown"];
var fr = {
  key: 0,
  class: "dp__sidebar_left"
};
var vr = {
  key: 1,
  class: "dp__preset_ranges"
};
var mr = ["onClick"];
var yr = {
  key: 2,
  class: "dp__sidebar_right"
};
var gr = {
  key: 3,
  class: "dp__action_extra"
};
var hr = defineComponent({
  __name: "DatepickerMenu",
  props: {
    openOnTop: { type: Boolean, default: false },
    internalModelValue: { type: [Date, Array], default: null },
    arrMapValues: { type: Object, default: () => ({}) },
    ...dt
  },
  emits: [
    "close-picker",
    "select-date",
    "auto-apply",
    "time-update",
    "flow-step",
    "update-month-year",
    "invalid-select",
    "update:internal-model-value",
    "recalculate-position",
    "invalid-fixed-range",
    "tooltip-open",
    "tooltip-close",
    "time-picker-open",
    "time-picker-close",
    "am-pm-change",
    "range-start",
    "range-end"
  ],
  setup(e2, { expose: n, emit: a3 }) {
    const t2 = e2, i2 = computed(() => {
      const { openOnTop: h3, internalModelValue: z2, arrMapValues: pe, ...Me } = t2;
      return Me;
    }), { setMenuFocused: v, setShiftKey: m3, control: T2 } = ta(), { getCalendarDays: Y2, defaults: _ } = xe(t2), W = useSlots(), C = ref(null), c2 = reactive({
      timePicker: !!(!t2.enableTimePicker || t2.timePicker || t2.monthPicker),
      monthYearInput: !!t2.timePicker,
      calendar: false
    }), g = ref([]), Q2 = ref([]), U = ref(null), x2 = ref(null), V = ref(0), F = ref(false), ae = ref(0);
    onMounted(() => {
      var z2;
      F.value = true, !((z2 = t2.presetRanges) != null && z2.length) && !W["left-sidebar"] && !W["right-sidebar"] && (ze(), window.addEventListener("resize", ze));
      const h3 = Ae(x2);
      if (h3 && !t2.textInput && !t2.inline && (v(true), ce()), h3) {
        const pe = (Me) => {
          t2.allowPreventDefault && Me.preventDefault(), Me.stopImmediatePropagation(), Me.stopPropagation();
        };
        h3.addEventListener("pointerdown", pe), h3.addEventListener("mousedown", pe);
      }
    }), onUnmounted(() => {
      window.removeEventListener("resize", ze);
    });
    const { arrowRight: oe, arrowLeft: B2, arrowDown: G2, arrowUp: J } = ut(), ne = (h3) => {
      h3 || h3 === 0 ? Q2.value[h3].triggerTransition(
        N.value(h3),
        I2.value(h3)
      ) : Q2.value.forEach(
        (z2, pe) => z2.triggerTransition(N.value(pe), I2.value(pe))
      );
    }, ce = () => {
      const h3 = Ae(x2);
      h3 && h3.focus({ preventScroll: true });
    }, ye = () => {
      var h3;
      (h3 = t2.flow) != null && h3.length && ae.value !== -1 && (ae.value += 1, a3("flow-step", ae.value), s3());
    }, O2 = () => {
      ae.value = -1;
    }, {
      calendars: w2,
      modelValue: f,
      month: N,
      year: I2,
      time: E2,
      updateTime: D2,
      updateMonthYear: y3,
      selectDate: d3,
      getWeekNum: u2,
      monthYearSelect: S3,
      handleScroll: b2,
      handleArrow: Z,
      handleSwipe: r,
      getMarker: o,
      selectCurrentDate: l,
      presetDateRange: M3
    } = ml(t2, a3, ye, ne, ae), { setHoverDate: re, clearHoverDate: se, getDayClassData: Pe } = dr(f, t2), ee = {
      modelValue: f,
      month: N,
      year: I2,
      time: E2,
      updateTime: D2,
      updateMonthYear: y3,
      selectDate: d3,
      presetDateRange: M3,
      handleMonthYearChange: (h3) => {
        g.value[0] && g.value[0].handleMonthYearChange(h3);
      }
    };
    watch(
      w2,
      () => {
        t2.openOnTop && setTimeout(() => {
          a3("recalculate-position");
        }, 0);
      },
      { deep: true }
    );
    const Ue = ht(W, "calendar"), Ie = ht(W, "action"), Te = ht(W, "timePicker"), Xe = ht(W, "monthYear"), ct = computed(() => t2.openOnTop ? "dp__arrow_bottom" : "dp__arrow_top"), et = computed(() => tl(t2.yearRange, t2.reverseYears)), wt = computed(() => nl(t2.formatLocale, t2.locale, t2.monthNameFormat)), ze = () => {
      const h3 = Ae(C);
      h3 && (V.value = h3.getBoundingClientRect().width);
    }, j = computed(() => (h3) => Y2(N.value(h3), I2.value(h3))), te = computed(
      () => _.value.multiCalendars > 0 ? [...Array(_.value.multiCalendars).keys()] : [0]
    ), ue = computed(
      () => (h3) => h3 === 1
    ), Tt = computed(() => t2.monthPicker || t2.timePicker || t2.yearPicker), ft = computed(
      () => ({
        dp__menu_inner: true,
        dp__flex_display: _.value.multiCalendars > 0
      })
    ), Gt = computed(() => ({
      dp__instance_calendar: _.value.multiCalendars > 0
    })), Yt = computed(() => ({
      dp__menu_disabled: t2.disabled,
      dp__menu_readonly: t2.readonly
    })), St = computed(
      () => (h3) => qt(j, h3)
    ), Zt = computed(
      () => ({
        dp__menu: true,
        dp__menu_index: !t2.inline,
        dp__relative: t2.inline,
        [t2.menuClassName]: !!t2.menuClassName
      })
    ), qt = (h3, z2) => h3.value(z2).map((pe) => ({
      ...pe,
      days: pe.days.map((Me) => (Me.marker = o(Me), Me.classData = Pe(Me), Me))
    })), Xt = (h3) => {
      h3.stopPropagation(), h3.stopImmediatePropagation();
    }, Vt = () => {
      t2.escClose && a3("close-picker");
    }, Mn = (h3, z2 = false) => {
      d3(h3, z2), t2.spaceConfirm && a3("select-date");
    }, Et = (h3) => {
      var z2;
      (z2 = t2.flow) != null && z2.length && (c2[h3] = true, Object.keys(c2).filter((pe) => !c2[pe]).length || s3());
    }, bt = (h3, z2, pe, Me, ...Je) => {
      if (t2.flow[ae.value] === h3) {
        const q2 = Me ? z2.value[0] : z2.value;
        q2 && q2[pe](...Je);
      }
    }, s3 = () => {
      bt("month", g, "toggleMonthPicker", true, true), bt("year", g, "toggleYearPicker", true, true), bt("calendar", U, "toggleTimePicker", false, false, true), bt("time", U, "toggleTimePicker", false, true, true);
      const h3 = t2.flow[ae.value];
      (h3 === "hours" || h3 === "minutes" || h3 === "seconds") && bt(h3, U, "toggleTimePicker", false, true, true, h3);
    }, k2 = (h3) => {
      if (t2.arrowNavigation) {
        if (h3 === "up")
          return J();
        if (h3 === "down")
          return G2();
        if (h3 === "left")
          return B2();
        if (h3 === "right")
          return oe();
      } else
        h3 === "left" || h3 === "up" ? Z("left", 0, h3 === "up") : Z("right", 0, h3 === "down");
    }, X2 = (h3) => {
      m3(h3.shiftKey), !t2.disableMonthYearSelect && h3.code === "Tab" && h3.target.classList.contains("dp__menu") && T2.value.shiftKeyInMenu && (h3.preventDefault(), h3.stopImmediatePropagation(), a3("close-picker"));
    }, ie = () => {
      ce(), a3("time-picker-close");
    }, $e = (h3) => {
      var z2, pe, Me, Je, q2;
      (z2 = U.value) == null || z2.toggleTimePicker(false, false), (Me = (pe = g.value) == null ? void 0 : pe[h3]) == null || Me.toggleMonthPicker(false, false), (q2 = (Je = g.value) == null ? void 0 : Je[h3]) == null || q2.toggleYearPicker(false, false);
    };
    return n({
      updateMonthYear: y3,
      switchView: (h3, z2 = 0) => {
        var pe, Me, Je, q2, nt;
        return h3 === "month" ? (Me = (pe = g.value) == null ? void 0 : pe[z2]) == null ? void 0 : Me.toggleMonthPicker(false, true) : h3 === "year" ? (q2 = (Je = g.value) == null ? void 0 : Je[z2]) == null ? void 0 : q2.toggleYearPicker(false, true) : h3 === "time" ? (nt = U.value) == null ? void 0 : nt.toggleTimePicker(true, false) : $e(z2);
      }
    }), (h3, z2) => {
      var pe;
      return openBlock(), createBlock(Transition, {
        appear: "",
        name: (pe = unref(_).transitions) == null ? void 0 : pe.menuAppear,
        css: !!h3.transitions
      }, {
        default: withCtx(() => {
          var Me, Je;
          return [
            createBaseVNode("div", {
              id: h3.uid ? `dp-menu-${h3.uid}` : void 0,
              tabindex: "0",
              ref_key: "dpMenuRef",
              ref: x2,
              role: "dialog",
              class: normalizeClass(Zt.value),
              onMouseleave: z2[14] || (z2[14] = //@ts-ignore
              (...q2) => unref(se) && unref(se)(...q2)),
              onClick: Xt,
              onKeydown: [
                withKeys(Vt, ["esc"]),
                z2[15] || (z2[15] = withKeys(withModifiers((q2) => k2("left"), ["prevent"]), ["left"])),
                z2[16] || (z2[16] = withKeys(withModifiers((q2) => k2("up"), ["prevent"]), ["up"])),
                z2[17] || (z2[17] = withKeys(withModifiers((q2) => k2("down"), ["prevent"]), ["down"])),
                z2[18] || (z2[18] = withKeys(withModifiers((q2) => k2("right"), ["prevent"]), ["right"])),
                X2
              ]
            }, [
              (h3.disabled || h3.readonly) && h3.inline ? (openBlock(), createElementBlock("div", {
                key: 0,
                class: normalizeClass(Yt.value)
              }, null, 2)) : createCommentVNode("", true),
              !h3.inline && !h3.teleportCenter ? (openBlock(), createElementBlock("div", {
                key: 1,
                class: normalizeClass(ct.value)
              }, null, 2)) : createCommentVNode("", true),
              createBaseVNode("div", {
                class: normalizeClass({
                  dp__menu_content_wrapper: ((Me = h3.presetRanges) == null ? void 0 : Me.length) || !!h3.$slots["left-sidebar"] || !!h3.$slots["right-sidebar"]
                })
              }, [
                h3.$slots["left-sidebar"] ? (openBlock(), createElementBlock("div", fr, [
                  renderSlot(h3.$slots, "left-sidebar", normalizeProps(guardReactiveProps(ee)))
                ])) : createCommentVNode("", true),
                (Je = h3.presetRanges) != null && Je.length ? (openBlock(), createElementBlock("div", vr, [
                  (openBlock(true), createElementBlock(Fragment, null, renderList(h3.presetRanges, (q2, nt) => (openBlock(), createElementBlock("div", {
                    key: nt,
                    style: normalizeStyle(q2.style || {}),
                    class: "dp__preset_range",
                    onClick: (me) => unref(M3)(q2.range, !!q2.slot)
                  }, [
                    q2.slot ? renderSlot(h3.$slots, q2.slot, {
                      key: 0,
                      presetDateRange: unref(M3),
                      label: q2.label,
                      range: q2.range
                    }) : (openBlock(), createElementBlock(Fragment, { key: 1 }, [
                      createTextVNode(toDisplayString(q2.label), 1)
                    ], 64))
                  ], 12, mr))), 128))
                ])) : createCommentVNode("", true),
                createBaseVNode("div", {
                  class: "dp__instance_calendar",
                  ref_key: "calendarWrapperRef",
                  ref: C,
                  role: "document"
                }, [
                  createBaseVNode("div", {
                    class: normalizeClass(ft.value)
                  }, [
                    (openBlock(true), createElementBlock(Fragment, null, renderList(te.value, (q2, nt) => (openBlock(), createElementBlock("div", {
                      key: q2,
                      class: normalizeClass(Gt.value)
                    }, [
                      !h3.disableMonthYearSelect && !h3.timePicker ? (openBlock(), createBlock(Gl, mergeProps({
                        key: 0,
                        ref_for: true,
                        ref: (me) => {
                          me && (g.value[nt] = me);
                        },
                        months: wt.value,
                        years: et.value,
                        month: unref(N)(q2),
                        year: unref(I2)(q2),
                        instance: q2,
                        "internal-model-value": e2.internalModelValue
                      }, i2.value, {
                        onMount: z2[0] || (z2[0] = (me) => Et("monthYearInput")),
                        onResetFlow: O2,
                        onUpdateMonthYear: (me) => unref(y3)(q2, me),
                        onMonthYearSelect: unref(S3),
                        onOverlayClosed: ce
                      }), createSlots({ _: 2 }, [
                        renderList(unref(Xe), (me, sa) => ({
                          name: me,
                          fn: withCtx((Jt) => [
                            renderSlot(h3.$slots, me, normalizeProps(guardReactiveProps(Jt)))
                          ])
                        }))
                      ]), 1040, ["months", "years", "month", "year", "instance", "internal-model-value", "onUpdateMonthYear", "onMonthYearSelect"])) : createCommentVNode("", true),
                      createVNode(Yl, mergeProps({
                        ref_for: true,
                        ref: (me) => {
                          me && (Q2.value[nt] = me);
                        },
                        "specific-mode": Tt.value,
                        "get-week-num": unref(u2),
                        instance: q2,
                        "mapped-dates": St.value(q2),
                        month: unref(N)(q2),
                        year: unref(I2)(q2)
                      }, i2.value, {
                        onSelectDate: (me) => unref(d3)(me, !ue.value(q2)),
                        onHandleSpace: (me) => Mn(me, !ue.value(q2)),
                        onSetHoverDate: z2[1] || (z2[1] = (me) => unref(re)(me)),
                        onHandleScroll: (me) => unref(b2)(me, q2),
                        onHandleSwipe: (me) => unref(r)(me, q2),
                        onMount: z2[2] || (z2[2] = (me) => Et("calendar")),
                        onResetFlow: O2,
                        onTooltipOpen: z2[3] || (z2[3] = (me) => h3.$emit("tooltip-open", me)),
                        onTooltipClose: z2[4] || (z2[4] = (me) => h3.$emit("tooltip-close", me))
                      }), createSlots({ _: 2 }, [
                        renderList(unref(Ue), (me, sa) => ({
                          name: me,
                          fn: withCtx((Jt) => [
                            renderSlot(h3.$slots, me, normalizeProps(guardReactiveProps({ ...Jt })))
                          ])
                        }))
                      ]), 1040, ["specific-mode", "get-week-num", "instance", "mapped-dates", "month", "year", "onSelectDate", "onHandleSpace", "onHandleScroll", "onHandleSwipe"])
                    ], 2))), 128))
                  ], 2),
                  createBaseVNode("div", null, [
                    h3.$slots["time-picker"] ? renderSlot(h3.$slots, "time-picker", normalizeProps(mergeProps({ key: 0 }, { time: unref(E2), updateTime: unref(D2) }))) : (openBlock(), createElementBlock(Fragment, { key: 1 }, [
                      h3.enableTimePicker && !h3.monthPicker && !h3.weekPicker ? (openBlock(), createBlock(ur, mergeProps({
                        key: 0,
                        ref_key: "timePickerRef",
                        ref: U,
                        hours: unref(E2).hours,
                        minutes: unref(E2).minutes,
                        seconds: unref(E2).seconds,
                        "internal-model-value": e2.internalModelValue
                      }, i2.value, {
                        onMount: z2[5] || (z2[5] = (q2) => Et("timePicker")),
                        "onUpdate:hours": z2[6] || (z2[6] = (q2) => unref(D2)(q2)),
                        "onUpdate:minutes": z2[7] || (z2[7] = (q2) => unref(D2)(q2, false)),
                        "onUpdate:seconds": z2[8] || (z2[8] = (q2) => unref(D2)(q2, false, true)),
                        onResetFlow: O2,
                        onOverlayClosed: ie,
                        onOverlayOpened: z2[9] || (z2[9] = (q2) => h3.$emit("time-picker-open", q2)),
                        onAmPmChange: z2[10] || (z2[10] = (q2) => h3.$emit("am-pm-change", q2))
                      }), createSlots({ _: 2 }, [
                        renderList(unref(Te), (q2, nt) => ({
                          name: q2,
                          fn: withCtx((me) => [
                            renderSlot(h3.$slots, q2, normalizeProps(guardReactiveProps(me)))
                          ])
                        }))
                      ]), 1040, ["hours", "minutes", "seconds", "internal-model-value"])) : createCommentVNode("", true)
                    ], 64))
                  ])
                ], 512),
                h3.$slots["right-sidebar"] ? (openBlock(), createElementBlock("div", yr, [
                  renderSlot(h3.$slots, "right-sidebar", normalizeProps(guardReactiveProps(ee)))
                ])) : createCommentVNode("", true),
                h3.$slots["action-extra"] ? (openBlock(), createElementBlock("div", gr, [
                  h3.$slots["action-extra"] ? renderSlot(h3.$slots, "action-extra", {
                    key: 0,
                    selectCurrentDate: unref(l)
                  }) : createCommentVNode("", true)
                ])) : createCommentVNode("", true)
              ], 2),
              !h3.autoApply || h3.keepActionRow ? (openBlock(), createBlock(Sl, mergeProps({
                key: 2,
                "menu-mount": F.value,
                "calendar-width": V.value,
                "internal-model-value": e2.internalModelValue
              }, i2.value, {
                onClosePicker: z2[11] || (z2[11] = (q2) => h3.$emit("close-picker")),
                onSelectDate: z2[12] || (z2[12] = (q2) => h3.$emit("select-date")),
                onInvalidSelect: z2[13] || (z2[13] = (q2) => h3.$emit("invalid-select")),
                onSelectNow: unref(l)
              }), createSlots({ _: 2 }, [
                renderList(unref(Ie), (q2, nt) => ({
                  name: q2,
                  fn: withCtx((me) => [
                    renderSlot(h3.$slots, q2, normalizeProps(guardReactiveProps({ ...me })))
                  ])
                }))
              ]), 1040, ["menu-mount", "calendar-width", "internal-model-value", "onSelectNow"])) : createCommentVNode("", true)
            ], 42, cr)
          ];
        }),
        _: 3
      }, 8, ["name", "css"]);
    };
  }
});
var pr = typeof window < "u" ? window : void 0;
var dn = () => {
};
var kr = (e2) => getCurrentScope() ? (onScopeDispose(e2), true) : false;
var wr = (e2, n, a3, t2) => {
  if (!e2)
    return dn;
  let i2 = dn;
  const v = watch(
    () => unref(e2),
    (T2) => {
      i2(), T2 && (T2.addEventListener(n, a3, t2), i2 = () => {
        T2.removeEventListener(n, a3, t2), i2 = dn;
      });
    },
    { immediate: true, flush: "post" }
  ), m3 = () => {
    v(), i2();
  };
  return kr(m3), m3;
};
var br = (e2, n, a3, t2 = {}) => {
  const { window: i2 = pr, event: v = "pointerdown" } = t2;
  return i2 ? wr(i2, v, (T2) => {
    const Y2 = Ae(e2), _ = Ae(n);
    !Y2 || !_ || Y2 === T2.target || T2.composedPath().includes(Y2) || T2.composedPath().includes(_) || a3(T2);
  }, { passive: true }) : void 0;
};
var Dr = defineComponent({
  __name: "VueDatePicker",
  props: {
    ...dt
  },
  emits: [
    "update:model-value",
    "text-submit",
    "closed",
    "cleared",
    "open",
    "focus",
    "blur",
    "internal-model-change",
    "recalculate-position",
    "flow-step",
    "update-month-year",
    "invalid-select",
    "invalid-fixed-range",
    "tooltip-open",
    "tooltip-close",
    "time-picker-open",
    "time-picker-close",
    "am-pm-change",
    "range-start",
    "range-end"
  ],
  setup(e2, { expose: n, emit: a3 }) {
    const t2 = e2, i2 = useSlots(), v = ref(false), m3 = toRef(t2, "modelValue"), T2 = toRef(t2, "timezone"), Y2 = ref(null), _ = ref(null), W = ref(false), C = ref(null), c2 = reactive({
      disabledDates: null,
      allowedDates: null,
      highlightedDates: null
    }), { setMenuFocused: g, setShiftKey: Q2 } = ta(), { clearArrowNav: U } = ut(), { validateDate: x2, isValidTime: V, defaults: F, mapDatesArrToMap: ae } = xe(t2);
    onMounted(() => {
      N(t2.modelValue), t2.inline || (O2(C.value).addEventListener("scroll", S3), window.addEventListener("resize", b2)), t2.inline && (v.value = true), ae(c2);
    }), onUnmounted(() => {
      if (!t2.inline) {
        const j = O2(C.value);
        j && j.removeEventListener("scroll", S3), window.removeEventListener("resize", b2);
      }
    });
    const oe = ht(i2, "all", t2.presetRanges), B2 = ht(i2, "input");
    watch(
      [m3, T2],
      () => {
        N(m3.value);
      },
      { deep: true }
    );
    const { openOnTop: G2, menuStyle: J, resetPosition: ne, setMenuPosition: ce, setInitialPosition: ye, getScrollableParent: O2 } = hl(Y2, _, a3, t2), {
      inputValue: w2,
      internalModelValue: f,
      parseExternalModelValue: N,
      emitModelValue: I2,
      formatInputValue: E2,
      checkBeforeEmit: D2
    } = yl(a3, t2, W), y3 = computed(
      () => ({
        dp__main: true,
        dp__theme_dark: t2.dark,
        dp__theme_light: !t2.dark,
        dp__flex_display: t2.inline,
        dp__flex_display_with_input: t2.inlineWithInput
      })
    ), d3 = computed(() => t2.dark ? "dp__theme_dark" : "dp__theme_light"), u2 = computed(() => t2.teleport ? {
      to: typeof t2.teleport == "boolean" ? "body" : t2.teleport,
      disabled: t2.inline
    } : { class: "dp__outer_menu_wrap" }), S3 = () => {
      v.value && (t2.closeOnScroll ? Se() : ce());
    }, b2 = () => {
      v.value && ce();
    }, Z = async () => {
      var j, te, ue;
      !t2.disabled && !t2.readonly && (ne(), await nextTick(), v.value = true, await nextTick(), ye(), await nextTick(), ce(), delete J.value.opacity, !((j = F.value.transitions) != null && j.menuAppear) && t2.transitions && ((ue = (te = Y2.value) == null ? void 0 : te.$el) == null || ue.classList.add("dp__menu_transitioned")), v.value && a3("open"), v.value || Pe(), N(t2.modelValue));
    }, r = () => {
      w2.value = "", Pe(), a3("update:model-value", null), a3("cleared"), t2.closeOnClearValue && Se();
    }, o = () => {
      const j = f.value;
      return !j || !Array.isArray(j) && x2(j) ? true : Array.isArray(j) ? j.length === 2 && x2(j[0]) && x2(j[1]) ? true : x2(j[0]) : false;
    }, l = () => {
      D2() && o() ? (I2(), Se()) : a3("invalid-select", f.value);
    }, M3 = (j) => {
      re(), I2(), t2.closeOnAutoApply && !j && Se();
    }, re = () => {
      _.value && t2.textInput && _.value.setParsedDate(f.value);
    }, se = (j = false) => {
      t2.autoApply && V(f.value) && o() && (t2.range && Array.isArray(f.value) ? (t2.partialRange || f.value.length === 2) && M3(j) : M3(j));
    }, Pe = () => {
      t2.textInput || (f.value = null);
    }, Se = () => {
      t2.inline || (v.value && (v.value = false, g(false), Q2(false), U(), a3("closed"), ye(), w2.value && N(m3.value)), Pe());
    }, ee = (j, te) => {
      if (!j) {
        f.value = null;
        return;
      }
      f.value = j, te && (l(), a3("text-submit"));
    }, Ue = () => {
      t2.autoApply && V(f.value) && I2(), re();
    }, Ie = () => v.value ? Se() : Z(), Te = (j) => {
      f.value = j;
    }, Xe = () => {
      t2.textInput && (W.value = true, E2()), a3("focus");
    }, ct = () => {
      t2.textInput && (W.value = false, N(t2.modelValue)), a3("blur");
    }, et = (j) => {
      Y2.value && Y2.value.updateMonthYear(0, {
        month: Fn(j.month),
        year: Fn(j.year)
      });
    }, wt = (j) => {
      N(j || t2.modelValue);
    }, ze = (j, te) => {
      var ue;
      (ue = Y2.value) == null || ue.switchView(j, te);
    };
    return br(
      Y2,
      _,
      t2.onClickOutside ? () => t2.onClickOutside(o) : Se
    ), n({
      closeMenu: Se,
      selectDate: l,
      clearValue: r,
      openMenu: Z,
      onScroll: S3,
      formatInputValue: E2,
      // exposed for testing purposes
      updateInternalModelValue: Te,
      // modify internal modelValue
      setMonthYear: et,
      parseModel: wt,
      switchView: ze
    }), (j, te) => (openBlock(), createElementBlock("div", {
      class: normalizeClass(y3.value),
      ref_key: "pickerWrapperRef",
      ref: C
    }, [
      createVNode($l, mergeProps({
        ref_key: "inputRef",
        ref: _,
        "is-menu-open": v.value,
        "input-value": unref(w2),
        "onUpdate:inputValue": te[0] || (te[0] = (ue) => isRef(w2) ? w2.value = ue : null)
      }, j.$props, {
        onClear: r,
        onOpen: Z,
        onSetInputDate: ee,
        onSetEmptyDate: unref(I2),
        onSelectDate: l,
        onToggle: Ie,
        onClose: Se,
        onFocus: Xe,
        onBlur: ct,
        onRealBlur: te[1] || (te[1] = (ue) => W.value = false)
      }), createSlots({ _: 2 }, [
        renderList(unref(B2), (ue, Tt) => ({
          name: ue,
          fn: withCtx((ft) => [
            renderSlot(j.$slots, ue, normalizeProps(guardReactiveProps(ft)))
          ])
        }))
      ]), 1040, ["is-menu-open", "input-value", "onSetEmptyDate"]),
      v.value ? (openBlock(), createBlock(resolveDynamicComponent(j.teleport ? Teleport : "div"), normalizeProps(mergeProps({ key: 0 }, u2.value)), {
        default: withCtx(() => [
          v.value ? (openBlock(), createBlock(hr, mergeProps({
            key: 0,
            ref_key: "dpMenuRef",
            ref: Y2,
            class: d3.value,
            style: j.inline ? void 0 : unref(J),
            "open-on-top": unref(G2),
            "arr-map-values": c2
          }, j.$props, {
            "internal-model-value": unref(f),
            "onUpdate:internalModelValue": te[2] || (te[2] = (ue) => isRef(f) ? f.value = ue : null),
            onClosePicker: Se,
            onSelectDate: l,
            onAutoApply: se,
            onTimeUpdate: Ue,
            onFlowStep: te[3] || (te[3] = (ue) => j.$emit("flow-step", ue)),
            onUpdateMonthYear: te[4] || (te[4] = (ue) => j.$emit("update-month-year", ue)),
            onInvalidSelect: te[5] || (te[5] = (ue) => j.$emit("invalid-select", unref(f))),
            onInvalidFixedRange: te[6] || (te[6] = (ue) => j.$emit("invalid-fixed-range", ue)),
            onRecalculatePosition: unref(ce),
            onTooltipOpen: te[7] || (te[7] = (ue) => j.$emit("tooltip-open", ue)),
            onTooltipClose: te[8] || (te[8] = (ue) => j.$emit("tooltip-close", ue)),
            onTimePickerOpen: te[9] || (te[9] = (ue) => j.$emit("time-picker-open", ue)),
            onTimePickerClose: te[10] || (te[10] = (ue) => j.$emit("time-picker-close", ue)),
            onAmPmChange: te[11] || (te[11] = (ue) => j.$emit("am-pm-change", ue)),
            onRangeStart: te[12] || (te[12] = (ue) => j.$emit("range-start", ue)),
            onRangeEnd: te[13] || (te[13] = (ue) => j.$emit("range-end", ue))
          }), createSlots({ _: 2 }, [
            renderList(unref(oe), (ue, Tt) => ({
              name: ue,
              fn: withCtx((ft) => [
                renderSlot(j.$slots, ue, normalizeProps(guardReactiveProps({ ...ft })))
              ])
            }))
          ]), 1040, ["class", "style", "open-on-top", "arr-map-values", "internal-model-value", "onRecalculatePosition"])) : createCommentVNode("", true)
        ]),
        _: 3
      }, 16)) : createCommentVNode("", true)
    ], 2));
  }
});
var oa = (() => {
  const e2 = Dr;
  return e2.install = (n) => {
    n.component("Vue3DatePicker", e2);
  }, e2;
})();
var $r = Object.freeze(Object.defineProperty({
  __proto__: null,
  default: oa
}, Symbol.toStringTag, { value: "Module" }));
Object.entries($r).forEach(([e2, n]) => {
  e2 !== "default" && (oa[e2] = n);
});
export {
  oa as default
};
//# sourceMappingURL=@vuepic_vue-datepicker.js.map
